/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import Acme.NoRobots;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import scone.netobjects.SimpleUri;
import scone.robot.HttpConnectionPool;
import scone.robot.PageLoaderPool;
import scone.robot.PageLoaderPoolStats;
import scone.robot.QueueEntry;
import scone.robot.RobotHtmlNode;
import scone.robot.RobotTask;
import scone.robot.RobotTaskExpiryTimer;
import scone.robot.URLQueue;
import scone.util.PersistentProperties;

public class Robot {
    private static Robot instance = null;
    private PageLoaderPool pageLoaderPool;
    private HttpConnectionPool httpConnectionPool;
    private URLQueue urlQueue;
    private NoRobots noRobotsTester;
    private Timer timer;
    private Vector robotTasks;
    private String robotName;
    private int maxConcurrentRequests;
    private int timeout;
    private int maxThreads;
    private int maxIdleTime;
    private int threadPriority;
    private Vector validFileExtensions;
    private static int lastRobotTaskId;

    private Robot() {
        PersistentProperties props = new PersistentProperties("config/scone/robot.xml");
        this.maxThreads = 5;
        this.maxIdleTime = 3000;
        this.threadPriority = 5;
        this.robotName = "Scone-Robot";
        this.timeout = 5000;
        this.validFileExtensions = new Vector();
        this.validFileExtensions.add("htm");
        this.validFileExtensions.add("html");
        String queue = "scone.robot.BreadthSearchURLQueue";
        if (props.get("Maximum number of threads") != null) {
            this.maxThreads = Integer.parseInt(props.get("Maximum number of threads"));
            if (this.maxThreads < 1 || this.maxThreads > 100) {
                throw new NumberFormatException();
            }
        } else {
            throw new NumberFormatException();
        }
        if (props.get("Timeout for idle threads") != null) {
            this.maxIdleTime = Integer.parseInt(props.get("Timeout for idle threads"));
            if (this.maxIdleTime < 1 || this.maxIdleTime > 100000) {
                throw new NumberFormatException();
            }
        } else {
            throw new NumberFormatException();
        }
        if (props.get("Thread priority") != null) {
            this.threadPriority = Integer.parseInt(props.get("Thread priority"));
            if (this.threadPriority < 1 || this.threadPriority > 10) {
                throw new NumberFormatException();
            }
        } else {
            throw new NumberFormatException();
        }
        if (props.get("Robot name") != null) {
            this.robotName = props.get("Robot name");
        }
        if (props.get("Network timeout") != null) {
            this.timeout = Integer.parseInt(props.get("Network timeout"));
            if (this.timeout < 1 || this.timeout > 100000) {
                throw new NumberFormatException();
            }
        } else {
            throw new NumberFormatException();
        }
        if (props.get("Valid file extensions") != null) {
            String extensions = props.get("Valid file extensions");
            extensions = extensions.toLowerCase();
            this.validFileExtensions = new Vector();
            StringTokenizer st = new StringTokenizer(extensions);
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                this.validFileExtensions.add(e);
            }
        }
        if (props.get("Queue class") != null) {
            queue = props.get("Queue class");
        }
        Class<?> c = null;
        try {
            c = Class.forName(queue);
            this.urlQueue = (URLQueue)c.newInstance();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Properties pageLoaderPoolProperties = new Properties();
        pageLoaderPoolProperties.setProperty("minThreads", "0");
        pageLoaderPoolProperties.setProperty("maxThreads", Integer.toString(this.maxThreads));
        pageLoaderPoolProperties.setProperty("maxIdleTime", Integer.toString(this.maxIdleTime));
        pageLoaderPoolProperties.setProperty("priority", Integer.toString(this.threadPriority));
        this.pageLoaderPool = new PageLoaderPool(pageLoaderPoolProperties, this, this.urlQueue);
        this.httpConnectionPool = new HttpConnectionPool(this.maxThreads * 2);
        this.noRobotsTester = new NoRobots(this.robotName);
        this.timer = new Timer(true);
        this.robotTasks = new Vector();
        lastRobotTaskId = 0;
    }

    public static Robot instance() {
        if (instance == null) {
            instance = new Robot();
        }
        return instance;
    }

    public void scan(RobotTask robotTask) {
        robotTask.setArrivalTime();
        robotTask.incCheckedUris();
        if (robotTask.getDefaultFilter().filter(robotTask.getStartURI())) {
            this.robotTasks.add(robotTask);
            QueueEntry qe = new QueueEntry(robotTask.getStartURI(), robotTask.getDepth(), robotTask);
            this.queue(qe);
            robotTask.incQueuedUris();
            RobotTaskExpiryTimer et = new RobotTaskExpiryTimer(robotTask, this);
            if (qe.getRobotTask().getExpiry() != -1L) {
                this.timer.schedule((TimerTask)et, qe.getRobotTask().getExpiry());
            }
        } else {
            robotTask.incFilteredUris();
            robotTask.getRobotUser().robotTaskFinished(robotTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRobotTask(RobotTask robotTask) {
        robotTask.stop();
        this.urlQueue.removeAllQueueEntries(robotTask);
        URLQueue uRLQueue = this.urlQueue;
        synchronized (uRLQueue) {
            if (robotTask.openThreads() == 0) {
                this.robotTasks.remove(robotTask);
                if (!robotTask.isFinished()) {
                    robotTask.getRobotUser().robotTaskFinished(robotTask);
                }
                robotTask.setFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRobotTask(int robotTaskId) {
        Enumeration tasks = this.robotTasks.elements();
        while (tasks.hasMoreElements()) {
            RobotTask robotTask = (RobotTask)tasks.nextElement();
            if (robotTask.getId() != robotTaskId) continue;
            robotTask.stop();
            this.urlQueue.removeAllQueueEntries(robotTask);
            URLQueue uRLQueue = this.urlQueue;
            synchronized (uRLQueue) {
                if (robotTask.openThreads() == 0) {
                    this.robotTasks.remove(robotTask);
                    if (!robotTask.isFinished()) {
                        robotTask.getRobotUser().robotTaskFinished(robotTask);
                    }
                    robotTask.setFinished();
                }
                break;
            }
        }
    }

    public Vector getRobotTasks() {
        return this.robotTasks;
    }

    public int getNumberOfRobotTasks() {
        return this.robotTasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pageFinished(QueueEntry qe, RobotHtmlNode robotHtmlNode) {
        qe.getRobotTask().getRobotUser().robotNewPage(robotHtmlNode, qe.getRobotTask());
        URLQueue uRLQueue = this.urlQueue;
        synchronized (uRLQueue) {
            if (this.urlQueue.getNumberOfPendingQueueEntries(qe.getRobotTask()) == 0 && qe.getRobotTask().getNumberOfOpenUris() == 0 && qe.getRobotTask().noOtherThreadsOpen() && !qe.getRobotTask().isFinished()) {
                qe.getRobotTask().setEndTime();
                this.robotTasks.remove(qe.getRobotTask());
                long difference = qe.getRobotTask().getEndTime() - qe.getRobotTask().getStartTime();
                qe.getRobotTask().getRobotUser().robotTaskFinished(qe.getRobotTask());
                qe.getRobotTask().setFinished();
            }
            qe.getRobotTask().decOpenThreads();
        }
    }

    public String getRobotName() {
        return this.robotName;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getMaxNumberOfThreads() {
        return this.maxThreads;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    synchronized void queue(QueueEntry qe) {
        this.pageLoaderPool.queue(qe);
    }

    synchronized void removeQueueEntry(QueueEntry qe) {
        this.urlQueue.removeQueueEntry(qe);
    }

    synchronized void removeAllQueueEntries(RobotTask robotTask) {
        this.urlQueue.removeAllQueueEntries(robotTask);
    }

    public synchronized void printPageLoaderPoolStatus() {
        System.out.println(this.pageLoaderPool.getStats());
    }

    public synchronized PageLoaderPoolStats getPageLoaderPoolStatus() {
        return this.pageLoaderPool.getStats();
    }

    public synchronized int getJobsInPageLoaderPool() {
        return this.pageLoaderPool.getStats().jobsInProgress + this.pageLoaderPool.getStats().pendingJobs;
    }

    public synchronized boolean isPendingURL(SimpleUri uri, RobotTask robotTask) {
        return this.urlQueue.isPendingURL(uri, robotTask);
    }

    public synchronized QueueEntry getPendingURL(SimpleUri uri, RobotTask robotTask) {
        return this.urlQueue.getPendingURL(uri, robotTask);
    }

    public synchronized Vector getPendingQueueEntries(SimpleUri uri) {
        return this.urlQueue.getPendingQueueEntries(uri);
    }

    public synchronized int getNumberOfPendingQueueEntries(SimpleUri uri) {
        return this.urlQueue.getNumberOfPendingQueueEntries(uri);
    }

    public synchronized Vector getPendingQueueEntries(RobotTask robotTask) {
        return this.urlQueue.getPendingQueueEntries(robotTask);
    }

    public synchronized int getNumberOfPendingQueueEntries(RobotTask robotTask) {
        return this.urlQueue.getNumberOfPendingQueueEntries(robotTask);
    }

    boolean noRobotsTest(SimpleUri uri) {
        return this.noRobotsTester.ok(uri.toURL());
    }

    HttpConnectionPool getHttpConnectionPool() {
        return this.httpConnectionPool;
    }

    Timer getTimer() {
        return this.timer;
    }

    public boolean isValidFileExtension(String file) {
        if (file.length() == 0) {
            return true;
        }
        if (file.indexOf(".") == -1) {
            return true;
        }
        file = file.toLowerCase();
        Enumeration extensions = this.validFileExtensions.elements();
        while (extensions.hasMoreElements()) {
            String extension = (String)extensions.nextElement();
            extension = "." + extension;
            if (file.indexOf(extension) == -1) continue;
            return true;
        }
        return false;
    }

    public static synchronized int getNextRobotTaskId() {
        return ++lastRobotTaskId;
    }
}

