/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import java.util.Hashtable;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.netobjects.SimpleUri;
import scone.robot.NoHtmlNodeException;

public class RobotHtmlNode {
    private String nodeId;
    private SimpleUri simpleUri;
    private int scannedDepth;
    private Hashtable pageAttributes;
    private boolean onlyNetNode;

    public RobotHtmlNode(HtmlNode htmlNode, int scannedDepth) {
        this.nodeId = htmlNode.getNode().getNodeId();
        this.simpleUri = htmlNode.getNode().getSUri();
        this.scannedDepth = scannedDepth;
        this.pageAttributes = new Hashtable();
        this.onlyNetNode = false;
    }

    public RobotHtmlNode(NetNode netNode, int scannedDepth) {
        this.nodeId = netNode.getNodeId();
        this.simpleUri = netNode.getSUri();
        this.scannedDepth = scannedDepth;
        this.pageAttributes = new Hashtable();
        this.onlyNetNode = true;
    }

    public SimpleUri getSimpleUri() {
        return this.simpleUri;
    }

    public HtmlNode getHtmlNode() throws NoHtmlNodeException {
        if (this.onlyNetNode) {
            throw new NoHtmlNodeException();
        }
        return HtmlNodeCache.get(NetNodeCache.getById(this.nodeId));
    }

    public void setHtmlNode(HtmlNode htmlNode) {
        this.nodeId = htmlNode.getNode().getNodeId();
        this.simpleUri = htmlNode.getNode().getSUri();
        this.onlyNetNode = false;
    }

    public NetNode getNetNode() {
        return NetNodeCache.getById(this.nodeId);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNetNode(NetNode netNode) {
        this.nodeId = netNode.getNodeId();
        this.simpleUri = netNode.getSUri();
        this.onlyNetNode = true;
    }

    public int getScannedDepth() {
        return this.scannedDepth;
    }

    public void setScannedDepth(int scannedDepth) {
        this.scannedDepth = scannedDepth;
    }

    public String getAttribute(String key) {
        return (String)this.pageAttributes.get(key);
    }

    public void setAttribute(String key, String value) {
        this.pageAttributes.put(key, value);
    }
}

