/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import com.ibm.wbi.Meg;
import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.ResponseToRequest;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpGenerator;
import com.ibm.wbi.protocol.http.HttpRequest;
import com.ibm.wbi.protocol.http.HttpResponse;
import com.ibm.wbi.protocol.http.beans.FileGenerator;
import com.ibm.wbi.protocol.http.beans.FormHelper;
import com.ibm.wbi.protocol.http.beans.StaticHtmlGenerator;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import scone.netobjects.SimpleUri;
import scone.robot.QueueEntry;
import scone.robot.Robot;
import scone.robot.RobotHtmlNode;
import scone.robot.RobotTask;
import scone.robot.RobotUser;

class RobotMonitorMeg
extends HttpGenerator {
    private DocumentInfo documentInfo;
    private String file;
    private Properties formParameter;
    private HttpRequest request;
    private HttpResponse response;
    private String id;
    private long userId = 0L;
    private Robot robot;

    RobotMonitorMeg() {
    }

    private StaticHtmlGenerator listRobotTasks() {
        StaticHtmlGenerator sg = new StaticHtmlGenerator();
        String htmlCode = "<HTML>\n<HEAD>\n<TITLE>Scone Robot-Monitor</TITLE>\n</HEAD>\n<BODY>\n";
        htmlCode = htmlCode + "<img src=\"http://_robot.scone.de/scone.jpg\"><BR>\n";
        htmlCode = htmlCode + "<H2><I>Scone Robot-Monitor</I></H2>\n";
        htmlCode = htmlCode + "<P><b>Tasks: " + this.robot.getNumberOfRobotTasks() + "<br>Jobs in PageLoaderpool: " + this.robot.getJobsInPageLoaderPool() + "</b></P>\n";
        htmlCode = htmlCode + "<TABLE border=1 cellpadding=1 cellspacing=0>\n";
        htmlCode = htmlCode + "<TR><TH align=left>Task</TH><TH align=left>Depth</TH><TH align=left>Queue-Lenght</TH><TH align=left>Open URLs</TH><TH align=left>Found Pages</TH><TH>&nbsp;</TH></TR>\n";
        Vector robotTasks = this.robot.getRobotTasks();
        Enumeration tasks = robotTasks.elements();
        while (tasks.hasMoreElements()) {
            RobotTask rt = (RobotTask)tasks.nextElement();
            Enumeration openUrisEnum = rt.getOpenUris();
            String openUrisString = "";
            while (openUrisEnum.hasMoreElements()) {
                QueueEntry qe = (QueueEntry)openUrisEnum.nextElement();
                SimpleUri suri = qe.getURI();
                openUrisString = openUrisString + suri.toString() + "<br>";
            }
            htmlCode = htmlCode + "<TR><TD>" + rt.getStartURI().toString() + "</TD><TD>" + rt.getDepth() + "</TD><TD>" + this.robot.getNumberOfPendingQueueEntries(rt) + "</TD><TD>" + openUrisString + rt.getNumberOfOpenUris() + "</TD><TD>" + rt.getNumberOfResultNodes() + "<TD><a href=\"http://_robot.scone.de/_stopTask?task_id=" + rt.getId() + "\">stop</a></TD></TR>\n";
        }
        htmlCode = htmlCode + "</TABLE><BR>\n";
        htmlCode = htmlCode + "<P><A href=\"http://_robot.scone.de\"><B>Refresh</B></A></P>\n";
        htmlCode = htmlCode + "<H3>Create new RobotTask</H3>";
        htmlCode = htmlCode + "<FORM method=\"get\" action=\"http://_robot.scone.de/_newTask\">";
        htmlCode = htmlCode + "<TABLE border=\"0\">";
        htmlCode = htmlCode + "<TR><TD>Start URL:</TD><TD><INPUT type=\"text\" name=\"url\" size=\"50\"></TD></TR>";
        htmlCode = htmlCode + "<TR><TD>Crawl depth:</TD><TD><INPUT type=\"text\" name=\"depth\" size=\"2\" value=\"2\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; or download only HEAD: <input type=\"checkbox\" name=\"headonly\" value=\"1\"></TD></TR>";
        htmlCode = htmlCode + "<TR><TD valign=\"top\">Crawl restriction:</TD><TD>";
        htmlCode = htmlCode + "<INPUT type=\"radio\" name=\"restriction\" value=\"no\">No restriction<BR>";
        htmlCode = htmlCode + "<INPUT type=\"radio\" name=\"restriction\" value=\"internal\" checked>Only internal links<BR>";
        htmlCode = htmlCode + "<INPUT type=\"radio\" name=\"restriction\" value=\"subdirectories\">Only sub directories<BR>";
        htmlCode = htmlCode + "<INPUT type=\"radio\" name=\"restriction\" value=\"external\">Only external links<BR>";
        htmlCode = htmlCode + "</TD></TR>";
        htmlCode = htmlCode + "<TR><TD>Max downloaded URLS:</TD><TD><INPUT type=\"text\" name=\"maxdownloadurls\" size=\"10\" value=\"-1\"> (-1 means no limit)</TD></TR>";
        htmlCode = htmlCode + "<TR><TD>Max download time:</TD><TD><INPUT type=\"text\" name=\"maxdownloadtime\" size=\"10\" value=\"30000\"> (-1 means no limit)</TD></TR>";
        htmlCode = htmlCode + "<TR><TD>Max download size:</TD><TD><INPUT type=\"text\" name=\"maxpagesize\" size=\"10\" value=\"50000\"> (-1 means no limit)</TD></TR>";
        htmlCode = htmlCode + "<TR><TD>Check database:</TD><TD><input type=\"checkbox\" name=\"checkdatabase\" value=\"1\" checked></TD></TR>";
        htmlCode = htmlCode + "<TR><TD>Content seen test:</TD><TD><input type=\"checkbox\" name=\"contentseen\" value=\"1\"></TD></TR>";
        htmlCode = htmlCode + "<TR><TD>Update time:</TD><TD><INPUT type=\"text\" name=\"updatetime\" size=\"10\" value=\"1440\"> minutes (-1 means infinite update time)</TD></TR>";
        htmlCode = htmlCode + "</TABLE>";
        htmlCode = htmlCode + "<INPUT type=\"submit\" name=\"submit\" value=\"Start\">";
        htmlCode = htmlCode + "</FORM>";
        htmlCode = htmlCode + "</BODY></HTML>";
        sg.setStaticHtml(htmlCode);
        return sg;
    }

    public void handleRequest(RequestEvent e) throws RequestRejectedException {
        this.documentInfo = (DocumentInfo)e.getRequestInfo();
        this.file = this.documentInfo.getPath();
        this.formParameter = FormHelper.interpretFormData((ResponseToRequest)e);
        this.request = new HttpRequest((ResponseToRequest)e, true);
        this.robot = Robot.instance();
        StaticHtmlGenerator g = null;
        if (this.file.equals("/_stopTask")) {
            this.robot.stopRobotTask(Integer.parseInt(this.formParameter.getProperty("task_id")));
        } else if (this.file.equals("/_newTask")) {
            SimpleUri starturi = new SimpleUri(this.formParameter.getProperty("url"));
            int depth = Integer.parseInt(this.formParameter.getProperty("depth"));
            String r = this.formParameter.getProperty("restriction");
            int restriction = 4;
            if (r.equals("internal")) {
                restriction = 1;
            } else if (r.equals("subdirectories")) {
                restriction = 2;
            } else if (r.equals("external")) {
                restriction = 3;
            }
            RobotTask rt = new RobotTask(starturi, depth, restriction, new SimpleRobotUser());
            int maxDownloadUrls = Integer.parseInt(this.formParameter.getProperty("maxdownloadurls"));
            rt.setMaxDownloadUris(maxDownloadUrls);
            long maxDownloadTime = Long.parseLong(this.formParameter.getProperty("maxdownloadtime"));
            rt.setMaxDownloadTime(maxDownloadTime);
            int maxPageSize = Integer.parseInt(this.formParameter.getProperty("maxpagesize"));
            rt.setMaxPageSize(maxPageSize);
            boolean headOnly = this.formParameter.getProperty("headonly") != null;
            rt.setHeadOnly(headOnly);
            boolean checkDatabase = this.formParameter.getProperty("checkdatabase") != null;
            rt.setCheckDatabase(checkDatabase);
            if (this.formParameter.getProperty("contentseen") != null) {
                rt.setDoContentSeenTest();
            }
            long updateTime = Long.parseLong(this.formParameter.getProperty("updatetime"));
            Date updateDate = new Date();
            rt.setUpdateDate(updateDate.getTime() - (updateTime *= 60000L));
            this.robot.scan(rt);
        } else if (this.file.length() > 1) {
            String ext = this.file.substring(this.file.lastIndexOf(".") + 1);
            FileGenerator rg = new FileGenerator("resources/scone/proxy" + this.file, this.getContentType(ext));
            g = rg;
        }
        if (g == null) {
            g = this.listRobotTasks();
        }
        this.response = g.getHttpResponse();
        this.response.setCache(false);
        try {
            this.forwardRequest((Meg)g, e);
        }
        catch (IOException ex) {
            System.out.println("Error sending response in RobotMonitorMeg!");
        }
    }

    private String getContentType(String ext) {
        if ((ext = ext.toLowerCase()).equals("txt")) {
            return "text/txt";
        }
        if (ext.equals("css")) {
            return "text/css";
        }
        if (ext.equals("js")) {
            return "application/x-javascript";
        }
        if (ext.equals("gif")) {
            return "image/gif";
        }
        if (ext.equals("jpg")) {
            return "image/jpeg";
        }
        return "text/html";
    }

    public class SimpleRobotUser
    implements RobotUser {
        public void robotNewPage(RobotHtmlNode robotHtmlNode, RobotTask robotTask) {
        }

        public void robotTaskFinished(RobotTask robotTask) {
            System.out.println("");
            System.out.println("RobotTask " + robotTask.getStartURI().toString() + " finished");
            long time = Math.round((robotTask.getEndTime() - robotTask.getStartTime()) / 1000L);
            System.out.println("Time : " + time + " seconds");
            System.out.println("Checked URL: " + robotTask.getCheckedUris());
            System.out.println("Filtered URLS " + robotTask.getFilteredUris());
            System.out.println("Queued URL: " + robotTask.getQueuedUris());
            System.out.println("Cache Hits: " + robotTask.getCacheHits());
            System.out.println("Downloaded URLs: " + robotTask.getDownloadedUris());
            System.out.println("");
        }
    }
}

