/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import scone.netobjects.SimpleUri;
import scone.robot.ContentSeenFilter;
import scone.robot.DefaultFilter;
import scone.robot.LinkClassifier;
import scone.robot.LinkFilter;
import scone.robot.PageClassifier;
import scone.robot.PageFilter;
import scone.robot.QueueEntry;
import scone.robot.Robot;
import scone.robot.RobotHtmlNode;
import scone.robot.RobotUser;

public class RobotTask {
    private int id = Robot.getNextRobotTaskId();
    private RobotUser robotUser;
    private SimpleUri startURI;
    private boolean headOnly;
    private int depth;
    private int restriction;
    private boolean obeyRobotExclusion;
    private long expiry;
    private int maxDownloadUris;
    private boolean checkDatabase;
    private long updateDate;
    private int maxPageSize;
    private long maxDownloadTime;
    private Vector pageClassifierList;
    private Vector linkClassifierList;
    private Vector pageFilterList;
    private Vector linkFilterList;
    private DefaultFilter defaultFilter;
    private boolean doContentSeenTest;
    private boolean requireSourceCode;
    private long arrivalTime;
    private long startTime;
    private long endTime;
    private int checkedUris;
    private int queuedUris;
    private int filteredUris;
    private int downloadedUris;
    private int cacheHits;
    private Vector resultNodes;
    private Vector openUris;
    private int openThreads;
    private boolean stopped;
    private boolean finished;
    public static final int INTERNAL = 1;
    public static final int SUBDIRECTORIES = 2;
    public static final int EXTERNAL = 3;
    public static final int ALL = 4;
    private Object statisticsLock;

    public RobotTask(SimpleUri startURI, int depth, int restriction, RobotUser robotUser) {
        this.robotUser = robotUser;
        this.startURI = startURI;
        this.headOnly = false;
        this.depth = depth;
        this.restriction = restriction;
        this.obeyRobotExclusion = false;
        this.expiry = -1L;
        this.maxDownloadUris = -1;
        this.checkDatabase = true;
        this.updateDate = -1L;
        this.maxPageSize = -1;
        this.maxDownloadTime = -1L;
        this.pageClassifierList = new Vector();
        this.linkClassifierList = new Vector();
        this.pageFilterList = new Vector();
        this.linkFilterList = new Vector();
        this.defaultFilter = new DefaultFilter(restriction, startURI);
        this.doContentSeenTest = false;
        this.requireSourceCode = true;
        this.arrivalTime = -1L;
        this.startTime = -1L;
        this.endTime = -1L;
        this.checkedUris = 0;
        this.queuedUris = 0;
        this.filteredUris = 0;
        this.downloadedUris = 0;
        this.cacheHits = 0;
        this.resultNodes = new Vector();
        this.openUris = new Vector();
        this.openThreads = 0;
        this.stopped = false;
        this.finished = false;
        this.statisticsLock = new Object();
    }

    public int getId() {
        return this.id;
    }

    RobotUser getRobotUser() {
        return this.robotUser;
    }

    public SimpleUri getStartURI() {
        return this.startURI;
    }

    public void setHeadOnly(boolean headOnly) {
        this.headOnly = headOnly;
        this.defaultFilter.setHeadOnly(headOnly);
    }

    public boolean getHeadOnly() {
        return this.headOnly;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setObeyRobotExclusion(boolean obeyRobotExclusion) {
        this.obeyRobotExclusion = obeyRobotExclusion;
    }

    public boolean getObeyRobotExclusion() {
        return this.obeyRobotExclusion;
    }

    public void setExpiry(long time) {
        this.expiry = time;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setMaxDownloadUris(int max) {
        this.maxDownloadUris = max;
    }

    public int getMaxDownloadUris() {
        return this.maxDownloadUris;
    }

    public void setCheckDatabase(boolean checkDatabase) {
        this.checkDatabase = checkDatabase;
    }

    public boolean getCheckDatabase() {
        return this.checkDatabase;
    }

    public void setUpdateDate(long date) {
        this.updateDate = date;
    }

    public long getUpdateDate() {
        return this.updateDate;
    }

    public void setMaxPageSize(int size) {
        this.maxPageSize = size;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxDownloadTime(long time) {
        this.maxDownloadTime = time;
    }

    public long getMaxDownloadTime() {
        return this.maxDownloadTime;
    }

    public void addPageClassifier(PageClassifier pageClassifier) {
        this.pageClassifierList.add(pageClassifier);
    }

    public void removePageClassifier(PageClassifier pageClassifier) {
        this.pageClassifierList.remove(pageClassifier);
    }

    public void addLinkClassifier(LinkClassifier linkClassifier) {
        this.linkClassifierList.add(linkClassifier);
    }

    public void removeLinkClassifier(LinkClassifier linkClassifier) {
        this.linkClassifierList.remove(linkClassifier);
    }

    public void addPageFilter(PageFilter pageFilter) {
        this.pageFilterList.add(pageFilter);
    }

    public void removePageFilter(PageFilter pageFilter) {
        this.pageFilterList.remove(pageFilter);
    }

    public void addLinkFilter(LinkFilter linkFilter) {
        this.linkFilterList.add(linkFilter);
    }

    public void removeLinkFilter(LinkFilter linkFilter) {
        this.linkFilterList.remove(linkFilter);
    }

    public Enumeration getPageClassifier() {
        return this.pageClassifierList.elements();
    }

    public Enumeration getLinkClassifier() {
        return this.linkClassifierList.elements();
    }

    public Enumeration getPageFilter() {
        return this.pageFilterList.elements();
    }

    public Enumeration getLinkFilter() {
        return this.linkFilterList.elements();
    }

    DefaultFilter getDefaultFilter() {
        return this.defaultFilter;
    }

    public void setDoContentSeenTest() {
        this.doContentSeenTest = true;
        this.pageFilterList.add(new ContentSeenFilter());
    }

    public boolean getDoContenSeenTest() {
        return this.doContentSeenTest;
    }

    public void setRequireSourceCode(boolean requireSourceCode) {
        this.requireSourceCode = requireSourceCode;
    }

    public boolean getRequireSourceCode() {
        return this.requireSourceCode;
    }

    void setArrivalTime() {
        Date d = new Date();
        this.arrivalTime = d.getTime();
    }

    public long getArrivalTime() {
        return this.arrivalTime;
    }

    void setStartTime() {
        Date d = new Date();
        this.startTime = d.getTime();
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setEndTime() {
        Date d = new Date();
        this.endTime = d.getTime();
    }

    public long getEndTime() {
        return this.endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incCheckedUris() {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.checkedUris;
        }
    }

    public int getCheckedUris() {
        return this.checkedUris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incQueuedUris() {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.queuedUris;
        }
    }

    public int getQueuedUris() {
        return this.queuedUris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incFilteredUris() {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.filteredUris;
        }
    }

    public int getFilteredUris() {
        return this.filteredUris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incDownloadedUris() {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.downloadedUris;
        }
    }

    public int getDownloadedUris() {
        return this.downloadedUris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incCacheHits() {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.cacheHits;
        }
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    synchronized void addOpenUri(QueueEntry qe) {
        this.openUris.add(qe);
    }

    synchronized void moveOpenUriToResult(QueueEntry qe, RobotHtmlNode robotHtmlNode) {
        if (!this.resultNodes.contains(robotHtmlNode)) {
            this.resultNodes.add(robotHtmlNode);
        }
        this.openUris.remove(qe);
    }

    public synchronized boolean isOpenUri(SimpleUri uri) {
        Enumeration links = this.openUris.elements();
        while (links.hasMoreElements()) {
            QueueEntry qe = (QueueEntry)links.nextElement();
            SimpleUri link = qe.getURI();
            if (!link.equals(uri)) continue;
            return true;
        }
        return false;
    }

    public synchronized QueueEntry getOpenUri(SimpleUri uri) {
        Enumeration links = this.openUris.elements();
        while (links.hasMoreElements()) {
            QueueEntry qe = (QueueEntry)links.nextElement();
            SimpleUri link = qe.getURI();
            if (!link.equals(uri)) continue;
            return qe;
        }
        return null;
    }

    public synchronized int getNumberOfOpenUris() {
        return this.openUris.size();
    }

    public synchronized Enumeration getOpenUris() {
        return this.openUris.elements();
    }

    public synchronized void addResultNode(RobotHtmlNode robotHtmlNode) {
        this.resultNodes.add(robotHtmlNode);
    }

    public synchronized boolean isResultUri(SimpleUri uri) {
        Enumeration links = this.resultNodes.elements();
        while (links.hasMoreElements()) {
            RobotHtmlNode robotHtmlNode = (RobotHtmlNode)links.nextElement();
            SimpleUri link = null;
            try {
                link = robotHtmlNode.getSimpleUri();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!link.equals(uri)) continue;
            return true;
        }
        return false;
    }

    public synchronized int getNumberOfResultNodes() {
        return this.resultNodes.size();
    }

    public synchronized Enumeration getResultNodes() {
        return this.resultNodes.elements();
    }

    public synchronized RobotHtmlNode getResultNode(SimpleUri uri) {
        Enumeration links = this.resultNodes.elements();
        while (links.hasMoreElements()) {
            RobotHtmlNode robotHtmlNode = (RobotHtmlNode)links.nextElement();
            SimpleUri link = null;
            try {
                link = robotHtmlNode.getSimpleUri();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!link.equals(uri)) continue;
            return robotHtmlNode;
        }
        return null;
    }

    void incOpenThreads() {
        ++this.openThreads;
    }

    void decOpenThreads() {
        --this.openThreads;
    }

    boolean noOtherThreadsOpen() {
        return this.openThreads == 1;
    }

    int openThreads() {
        return this.openThreads;
    }

    void stop() {
        this.stopped = true;
    }

    public boolean wasStopped() {
        return this.stopped;
    }

    void setFinished() {
        this.finished = true;
    }

    boolean isFinished() {
        return this.finished;
    }
}

