/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import scone.Plugin;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.robot.Robot;
import scone.robot.RobotHtmlNode;
import scone.robot.RobotTask;
import scone.robot.RobotUser;

public class RobotTestPlugin
extends Plugin
implements Observer,
RobotUser {
    private Robot robot;
    private RobotTask rt;
    private int depth = 2;
    private int restriction = 1;

    public int getRequirements() {
        return 17956889;
    }

    public void init() {
        int d;
        this.robot = Robot.instance();
        AccessCache.putObserver(this);
        if (this.getProperties().get("Crawl depth") != null) {
            d = Integer.parseInt(this.getProperties().get("Crawl depth"));
            if (d < 0 || d > 10) {
                throw new NumberFormatException();
            }
        } else {
            throw new NumberFormatException();
        }
        this.depth = d;
        System.out.print("(" + this.depth + ")");
        if (this.getProperties().get("Crawl restriction") != null) {
            System.out.print("(" + this.getProperties().get("Crawl restriction") + ")");
            if (this.getProperties().get("Crawl restriction").equals("Internal")) {
                this.restriction = 1;
            } else if (this.getProperties().get("Crawl restriction").equals("Sub-directories")) {
                this.restriction = 2;
            } else if (this.getProperties().get("Crawl restriction").equals("External")) {
                this.restriction = 3;
            } else if (this.getProperties().get("Crawl restriction").equals("No restriction")) {
                this.restriction = 4;
            } else {
                throw new NumberFormatException();
            }
        }
        System.out.print("...");
    }

    public void update(Observable o, Object arg) {
        AccessEvent e;
        if (o instanceof AccessCache && (e = (AccessEvent)arg).getAccess().getAction() == 0 && e.getAccess().getStayTime() == 0L) {
            System.out.println("RobotTest ---> " + e.getUser().getUserName() + " accessed " + e.getNode().toString());
            HtmlNode hNode = HtmlNodeCache.check(e.getNode());
            if (hNode == null) {
                System.out.println("Error: Access from non HTML-Page!");
            } else {
                try {
                    if (this.rt != null) {
                        this.robot.stopRobotTask(this.rt);
                    }
                    this.rt = new RobotTask(hNode.getSUri(), this.depth, this.restriction, this);
                    this.robot.scan(this.rt);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                System.out.println("Title: " + hNode.getTitle());
            }
        }
    }

    public void robotNewPage(RobotHtmlNode robotHtmlNode, RobotTask robotTask) {
    }

    public void robotTaskFinished(RobotTask robotTask) {
        System.out.println("Task: " + robotTask.getStartURI().toString() + " Depth: " + robotTask.getDepth() + " finished");
        System.out.println("Results: ");
        Enumeration downloadedNodes = robotTask.getResultNodes();
        while (downloadedNodes.hasMoreElements()) {
            RobotHtmlNode robotHtmlNode = (RobotHtmlNode)downloadedNodes.nextElement();
            System.out.println(robotHtmlNode.getSimpleUri().toString());
        }
    }
}

