/*
 * Decompiled with CFR 0.152.
 */
package scone.thumbnailgenerator;

import horst.HTMLPane;
import horst.HTMLWindow;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.net.URL;
import scone.netobjects.SimpleUri;

public class ThumbnailGenerator {
    private static HTMLWindow hw = new HTMLWindow();
    private static HTMLPane hp = hw.getHTMLPane();
    private Image img;
    private Image thumbnail;

    public void generateThumbnail(SimpleUri sUri) {
        this.generateThumbnail(sUri.toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateThumbnail(URL url) {
        HTMLPane hTMLPane = hp;
        synchronized (hTMLPane) {
            hp.setProgressiveDisplay(false);
            try {
                hp.syncOpenPage(url);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            Frame f = new Frame();
            f.addNotify();
            f.add((Component)hw);
            try {
                this.img = hp.getPageImage(1, 800, 600);
                this.thumbnail = this.img.getScaledInstance(-1, 110, 4);
            }
            catch (Exception e) {
                System.out.println("No thumbnail available for " + url);
            }
        }
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public Image getImage() {
        return this.img;
    }

    public void flush() {
        try {
            this.img.flush();
            this.thumbnail.flush();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

