/*
 * Decompiled with CFR 0.152.
 */
package scone.usertesttool;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import scone.util.ErrorLog;

public class CurrentState {
    private int numberOfTasks = 0;
    private int currentTask = 0;
    private int completedTasks = 0;
    private String parentFrameAndFrameName;
    private String testPerson;
    private String xmlFile;
    private String resultPath;
    private String resultFilename;
    private int testNumber;
    private Document resultDoc;

    public CurrentState(String testPerson, String xmlFile, int testNumber, int numberOfTasks, String resultPath) {
        this.numberOfTasks = numberOfTasks;
        this.testPerson = testPerson;
        this.xmlFile = xmlFile;
        this.testNumber = testNumber;
        this.resultPath = resultPath;
        String leadingZeros = "";
        if (testNumber < 1000) {
            leadingZeros = leadingZeros + "0";
        }
        if (testNumber < 100) {
            leadingZeros = leadingZeros + "0";
        }
        if (testNumber < 10) {
            leadingZeros = leadingZeros + "0";
        }
        File file = new File(xmlFile);
        this.resultFilename = this.forceEndingSlash(resultPath) + file.getName().substring(0, file.getName().length() - 4) + "." + leadingZeros + Integer.toString(testNumber) + "." + testPerson + ".xml";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.resultDoc = builder.newDocument();
            Element userTestResult = this.resultDoc.createElement("userTestResult");
            this.resultDoc.appendChild(userTestResult);
            userTestResult.setAttribute("timeStamp", new Date(System.currentTimeMillis()).toString());
            userTestResult.setAttribute("testPerson", testPerson);
            userTestResult.setAttribute("xmlFile", xmlFile);
            userTestResult.setAttribute("numberOfTasks", Integer.toString(numberOfTasks));
            userTestResult.setAttribute("completedTasks", "0");
            Text textNode = this.resultDoc.createTextNode("\n");
            userTestResult.appendChild(textNode);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }

    public CurrentState(String resultFile, String resultPath, int startTask) {
        this.resultFilename = resultFile;
        this.resultPath = resultPath;
        this.currentTask = startTask;
        this.resultDoc = this.parseXmlFile(this.resultFilename);
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        while (nList.getLength() >= startTask) {
            nList.item(0).getParentNode().removeChild(nList.item(nList.getLength() - 1));
            nList = this.resultDoc.getElementsByTagName("task");
        }
        this.completedTasks = nList.getLength();
        nList = this.resultDoc.getElementsByTagName("userTestResult");
        try {
            this.numberOfTasks = Integer.parseInt(this.getAttribByName("numberOfTasks", nList.item(0)));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.testPerson = this.getAttribByName("testPerson", nList.item(0));
        this.xmlFile = this.getAttribByName("xmlFile", nList.item(0));
        ((Element)nList.item(0)).setAttribute("completedTasks", Integer.toString(this.completedTasks));
        --this.currentTask;
        this.startNextTask();
    }

    public Document parseXmlFile(String fileName) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(fileName));
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document;
    }

    public boolean hasMoreTasks() {
        return this.currentTask != this.numberOfTasks;
    }

    public void startNextTask() {
        ++this.currentTask;
        NodeList nList = this.resultDoc.getElementsByTagName("userTestResult");
        Node utr = nList.item(0);
        Text textNode = this.resultDoc.createTextNode("  ");
        utr.appendChild(textNode);
        Element newTaskNode = this.resultDoc.createElement("task");
        utr.appendChild(newTaskNode);
        newTaskNode.setAttribute("timeStamp", new Long(System.currentTimeMillis()).toString());
        textNode = this.resultDoc.createTextNode("\n");
        newTaskNode.appendChild(textNode);
    }

    public void setTaskName(String name) {
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        Node taskNode = nList.item(this.currentTask - 1);
        ((Element)taskNode).setAttribute("name", name);
    }

    public void addButtonClick(String name) {
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        Node taskNode = nList.item(this.currentTask - 1);
        Text textNode = this.resultDoc.createTextNode("    ");
        taskNode.appendChild(textNode);
        Element buttonClickNode = this.resultDoc.createElement("buttonClick");
        taskNode.appendChild(buttonClickNode);
        buttonClickNode.setAttribute("action", "click");
        buttonClickNode.setAttribute("timeStamp", new Long(System.currentTimeMillis()).toString());
        buttonClickNode.setAttribute("name", name);
        textNode = this.resultDoc.createTextNode("\n");
        taskNode.appendChild(textNode);
    }

    public void addLinkEvent(String action, String uri, String frameName) {
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        Node taskNode = nList.item(this.currentTask - 1);
        Text textNode = this.resultDoc.createTextNode("    ");
        taskNode.appendChild(textNode);
        Element linkClickNode = this.resultDoc.createElement("link");
        taskNode.appendChild(linkClickNode);
        linkClickNode.setAttribute("action", action);
        linkClickNode.setAttribute("timeStamp", new Long(System.currentTimeMillis()).toString());
        linkClickNode.setAttribute("uri", uri);
        linkClickNode.setAttribute("frameName", frameName);
        textNode = this.resultDoc.createTextNode("\n");
        taskNode.appendChild(textNode);
    }

    public void addFormData(String action, String uri, String frameName) {
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        Node taskNode = nList.item(this.currentTask - 1);
        Text textNode = this.resultDoc.createTextNode("    ");
        taskNode.appendChild(textNode);
        Element linkClickNode = this.resultDoc.createElement("formData");
        taskNode.appendChild(linkClickNode);
        linkClickNode.setAttribute("action", action);
        linkClickNode.setAttribute("timeStamp", new Long(System.currentTimeMillis()).toString());
        linkClickNode.setAttribute("uri", uri);
        linkClickNode.setAttribute("frameName", frameName);
        textNode = this.resultDoc.createTextNode("\n");
        taskNode.appendChild(textNode);
    }

    public void addBrowserEvent(String action, String uri, String frameName) {
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        Node taskNode = nList.item(this.currentTask - 1);
        Text textNode = this.resultDoc.createTextNode("    ");
        taskNode.appendChild(textNode);
        Element BrowserButtonNode = this.resultDoc.createElement("browser");
        taskNode.appendChild(BrowserButtonNode);
        BrowserButtonNode.setAttribute("action", action);
        BrowserButtonNode.setAttribute("timeStamp", new Long(System.currentTimeMillis()).toString());
        BrowserButtonNode.setAttribute("uri", uri);
        BrowserButtonNode.setAttribute("frameName", frameName);
        textNode = this.resultDoc.createTextNode("\n");
        taskNode.appendChild(textNode);
    }

    public void addBrowserControlEvent(String action, String uri, String frameName) {
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        Node taskNode = nList.item(this.currentTask - 1);
        Text textNode = this.resultDoc.createTextNode("    ");
        taskNode.appendChild(textNode);
        Element BrowserButtonNode = this.resultDoc.createElement("browserControl");
        taskNode.appendChild(BrowserButtonNode);
        BrowserButtonNode.setAttribute("action", action);
        BrowserButtonNode.setAttribute("timeStamp", new Long(System.currentTimeMillis()).toString());
        BrowserButtonNode.setAttribute("uri", uri);
        BrowserButtonNode.setAttribute("frameName", frameName);
        textNode = this.resultDoc.createTextNode("\n");
        taskNode.appendChild(textNode);
    }

    public void addData(String tagname, String actionData, String componentName, String timeStamp) {
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        Node taskNode = nList.item(this.currentTask - 1);
        Text textNode = this.resultDoc.createTextNode("    ");
        taskNode.appendChild(textNode);
        Element dataNode = this.resultDoc.createElement(tagname);
        taskNode.appendChild(dataNode);
        dataNode.setAttribute("action", actionData);
        dataNode.setAttribute("name", componentName);
        dataNode.setAttribute("timeStamp", timeStamp);
        textNode = this.resultDoc.createTextNode("\n");
        taskNode.appendChild(textNode);
    }

    public void addStopWatch(String action, String name, long time) {
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        Node taskNode = nList.item(this.currentTask - 1);
        Text textNode = this.resultDoc.createTextNode("    ");
        taskNode.appendChild(textNode);
        Element StopWatchNode = this.resultDoc.createElement("stopWatch");
        taskNode.appendChild(StopWatchNode);
        StopWatchNode.setAttribute("action", action);
        StopWatchNode.setAttribute("name", name);
        StopWatchNode.setAttribute("periodOfTime", new Long(time).toString());
        textNode = this.resultDoc.createTextNode("\n");
        taskNode.appendChild(textNode);
    }

    public void endTask() {
        NodeList nList = this.resultDoc.getElementsByTagName("task");
        Node taskNode = nList.item(this.currentTask - 1);
        Text textNode = this.resultDoc.createTextNode("  ");
        taskNode.appendChild(textNode);
        nList = this.resultDoc.getElementsByTagName("userTestResult");
        Element userTestResult = (Element)nList.item(0);
        textNode = this.resultDoc.createTextNode("\n");
        userTestResult.appendChild(textNode);
        if (taskNode.hasChildNodes()) {
            this.completedTasks = this.currentTask;
            userTestResult.setAttribute("completedTasks", Integer.toString(this.completedTasks));
        }
    }

    public void writeXmlResults() {
        block4: {
            try {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                File outputFile = new File(this.resultFilename);
                DOMSource source = new DOMSource(this.resultDoc);
                StreamResult result = new StreamResult(outputFile);
                transformer.transform(source, result);
            }
            catch (TransformerConfigurationException tce) {
                ErrorLog.log(this, "writeXmlResults", "Transformer Factory error", tce);
                Throwable x = tce;
                if (tce.getException() != null) {
                    x = tce.getException();
                }
            }
            catch (TransformerException te) {
                ErrorLog.log(this, "writeXmlResults", "Transformation error", te);
                TransformerException x = te;
                if (te.getException() == null) break block4;
                Throwable throwable = te.getException();
            }
        }
    }

    public void writeTabDevidedResults() {
        String textFilename = this.resultFilename.substring(0, this.resultFilename.length() - 4) + ".txt";
        File outFile = new File(textFilename);
        try {
            FileWriter out = new FileWriter(outFile);
            NodeList nodeList = this.resultDoc.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.tabDevidedOutput(nodeList.item(i), out);
            }
            out.close();
        }
        catch (IOException e) {
            ErrorLog.log(this, "writeTabDevidedResults", "Error while writing to textfile", e);
        }
    }

    public void tabDevidedOutput(Node node, FileWriter out) {
        if (node.getNodeType() == 1) {
            try {
                if (node.getNodeName().equals("userTestResult")) {
                    out.write(node.getNodeName() + "\t" + this.getAttribByName("testPerson", node) + "\t" + this.getAttribByName("xmlFile", node) + "\t" + this.getAttribByName("timeStamp", node) + "\t" + this.getAttribByName("completedTasks", node) + " / " + this.getAttribByName("numberOfTasks", node) + "\t" + "\r\n");
                } else if (node.getNodeName().equals("stopWatch")) {
                    out.write(node.getNodeName() + "\t" + this.getAttribByName("name", node) + "\t" + this.getAttribByName("action", node) + "\t" + this.getAttribByName("timeStamp", node) + "\t" + this.getAttribByName("periodOfTime", node) + "\t" + "\r\n");
                } else if (node.getNodeName().equals("browser") || node.getNodeName().equals("browserControl") || node.getNodeName().equals("link")) {
                    out.write(node.getNodeName() + "\t" + this.getAttribByName("frameName", node) + "\t" + this.getAttribByName("action", node) + "\t" + this.getAttribByName("timeStamp", node) + "\t" + this.getAttribByName("uri", node) + "\t" + "\r\n");
                } else {
                    out.write(node.getNodeName() + "\t" + this.getAttribByName("name", node) + "\t" + this.getAttribByName("action", node) + "\t" + this.getAttribByName("timeStamp", node) + "\t" + this.getAttribByName("uri", node) + "\t" + "\r\n");
                }
            }
            catch (IOException e) {
                ErrorLog.log(this, "writeTabDevidedResults", "Error while writing to textfile", e);
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.tabDevidedOutput(nodeList.item(i), out);
        }
    }

    public int getCurrentTask() {
        return this.currentTask;
    }

    public String getXmlFilename() {
        return this.xmlFile;
    }

    public String getResultFilename() {
        return this.resultFilename;
    }

    public void setParentFrameAndFrameName(String parentFrameAndFrameName) {
        this.parentFrameAndFrameName = parentFrameAndFrameName;
    }

    public String getParentFrameAndFrameName() {
        return this.parentFrameAndFrameName;
    }

    public int getNumberOfTasks() {
        return this.numberOfTasks;
    }

    public int getCompletedTasks() {
        return this.completedTasks;
    }

    protected String forceEndingSlash(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + "/";
        }
        return path;
    }

    private String getText(Node node) {
        String textString = "";
        NodeList nList = node.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            if (nList.item(i).getNodeType() != 3) continue;
            textString = textString + nList.item(i).getNodeValue();
        }
        return textString;
    }

    private String getAttribByName(String attrName, Node node) {
        NamedNodeMap nMap = node.getAttributes();
        String result = "";
        for (int i = 0; i < nMap.getLength(); ++i) {
            if (!nMap.item(i).getNodeName().toLowerCase().equals(attrName.toLowerCase())) continue;
            result = this.getText(nMap.item(i));
        }
        return result;
    }
}

