/*
 * Decompiled with CFR 0.152.
 */
package scone.usertesttool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import scone.util.ErrorLog;

class StatesOfTests {
    private static StatesOfTests _instance = null;
    private ArrayList testDescriptions = new ArrayList();
    private ArrayList unfinishedTests = new ArrayList();
    private Document document;
    private String xmlPath;
    private String resultPath;

    static StatesOfTests getInstance() {
        if (_instance == null) {
            _instance = new StatesOfTests();
        }
        return _instance;
    }

    private StatesOfTests() {
    }

    public void setDirs(String xmlPath, String resultPath) {
        File xmlDir;
        int i;
        this.xmlPath = xmlPath;
        this.resultPath = resultPath;
        File file = new File(this.forceEndingSlash(resultPath) + "StateOfTests.xml");
        if (file.exists()) {
            this.document = this.parseXmlFile(this.forceEndingSlash(resultPath) + "StateOfTests.xml");
            NodeList nodeList = this.document.getElementsByTagName("testDescription");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                File file2 = new File(this.forceEndingSlash(xmlPath) + this.getAttribByName("name", nodeList.item(i2)));
                if (!file2.exists()) continue;
                this.testDescriptions.add(new TestDescription(this.getAttribByName("name", nodeList.item(i2)), Integer.parseInt(this.getAttribByName("lastTestNumber", nodeList.item(i2)))));
            }
            nodeList = this.document.getElementsByTagName("unfinishedTest");
            for (i = 0; i < nodeList.getLength(); ++i) {
                File file2 = new File(this.forceEndingSlash(xmlPath) + this.getAttribByName("name", nodeList.item(i)));
                if (!file2.exists() || !file2.getName().endsWith(".xml")) continue;
                String filename = this.getAttribByName("name", nodeList.item(i));
                String numberOfTasks = this.getAttribByName("numberOfTasks", nodeList.item(i));
                String completedTasks = this.getAttribByName("completedTasks", nodeList.item(i));
                try {
                    this.unfinishedTests.add(new UnfinishedTest(filename, Integer.parseInt(numberOfTasks), Integer.parseInt(completedTasks)));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if ((xmlDir = new File(xmlPath)).listFiles() != null) {
            File[] fileArray = xmlDir.listFiles();
            for (int i3 = 0; i3 < fileArray.length; ++i3) {
                if (!fileArray[i3].isFile() || !fileArray[i3].toString().toLowerCase().endsWith(".xml") || !this.containsTestDescription(fileArray[i3].toString())) continue;
                boolean found = false;
                for (int j = 0; j < this.testDescriptions.size(); ++j) {
                    found = ((TestDescription)this.testDescriptions.get(j)).getXmlFilename().equals(fileArray[i3].getName().substring(0, fileArray[i3].getName().length() - 4));
                }
                if (found) continue;
                this.testDescriptions.add(new TestDescription(fileArray[i3].getName().substring(0, fileArray[i3].getName().length() - 4), 0));
            }
        }
        File destDir = new File(resultPath);
        int testNumber = 0;
        if (destDir.listFiles() != null) {
            String testNumString = null;
            for (i = 0; i < destDir.listFiles().length; ++i) {
                testNumber = 0;
                for (int j = 0; j < this.testDescriptions.size(); ++j) {
                    String descName = ((TestDescription)this.testDescriptions.get(j)).getXmlFilename() + ".";
                    if (!destDir.listFiles()[i].getName().startsWith(descName) || !destDir.listFiles()[i].getName().endsWith(".xml") || (testNumString = destDir.listFiles()[i].getName().substring(descName.length(), descName.length() + 4)).compareTo("9999") > 0 || testNumString.compareTo("0000") < 0) continue;
                    try {
                        if (testNumber >= Integer.parseInt(testNumString)) continue;
                        testNumber = Integer.parseInt(testNumString);
                        ((TestDescription)this.testDescriptions.get(j)).setLastTestNumber(testNumber);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                boolean found = false;
                for (int j = 0; j < this.unfinishedTests.size(); ++j) {
                    found = destDir.listFiles()[i].getName().toLowerCase().equals(((UnfinishedTest)this.unfinishedTests.get(j)).getXmlFilename().toLowerCase() + ".xml");
                }
                if (found) continue;
                int[] unfinished = new int[]{0, 0};
                if (!destDir.listFiles()[i].getName().endsWith(".xml") || !this.testIsUnfinished(destDir.listFiles()[i].toString(), unfinished)) continue;
                String filename = destDir.listFiles()[i].getName().substring(0, destDir.listFiles()[i].getName().length() - 4);
                this.unfinishedTests.add(new UnfinishedTest(filename, unfinished[0], unfinished[1]));
            }
        }
        this.writeToDisk();
    }

    public String getTestDescriptionPath() {
        return this.forceEndingSlash(this.xmlPath);
    }

    public String getTestResultPath() {
        return this.forceEndingSlash(this.resultPath);
    }

    public int getLastTestNumberFor(String xmlFilename) {
        int result = 0;
        for (int i = 0; i < this.testDescriptions.size(); ++i) {
            if (!((TestDescription)this.testDescriptions.get(i)).getXmlFilename().equals(xmlFilename)) continue;
            result = ((TestDescription)this.testDescriptions.get(i)).getLastTestNumber();
        }
        return result;
    }

    public void setLastTestNumberFor(String xmlFilename, int lastTestNumber) {
        boolean replaced = false;
        for (int i = 0; i < this.testDescriptions.size(); ++i) {
            if (!((TestDescription)this.testDescriptions.get(i)).getXmlFilename().equals(xmlFilename)) continue;
            ((TestDescription)this.testDescriptions.get(i)).setLastTestNumber(lastTestNumber);
            replaced = true;
        }
        if (!replaced) {
            this.testDescriptions.add(new TestDescription(xmlFilename, lastTestNumber));
        }
        this.writeToDisk();
    }

    public String[] getTestDescriptions() {
        String[] descFilenames = new String[this.testDescriptions.size()];
        for (int i = 0; i < this.testDescriptions.size(); ++i) {
            descFilenames[i] = ((TestDescription)this.testDescriptions.get(i)).getXmlFilename();
        }
        return descFilenames;
    }

    public String[] getUnfinishedTests() {
        String[] unfinishedFiles = new String[this.unfinishedTests.size()];
        for (int i = 0; i < this.unfinishedTests.size(); ++i) {
            unfinishedFiles[i] = ((UnfinishedTest)this.unfinishedTests.get(i)).getXmlFilename();
        }
        return unfinishedFiles;
    }

    public int getNumberOfTasksFromUnfinishedTest(String filename) {
        int result = 0;
        for (int i = 0; i < this.unfinishedTests.size(); ++i) {
            if (!((UnfinishedTest)this.unfinishedTests.get(i)).getXmlFilename().equals(filename)) continue;
            result = ((UnfinishedTest)this.unfinishedTests.get(i)).getNumberOfTasks();
        }
        return result;
    }

    public int getCompletedTasksFromUnfinishedTest(String filename) {
        int result = 0;
        for (int i = 0; i < this.unfinishedTests.size(); ++i) {
            if (!((UnfinishedTest)this.unfinishedTests.get(i)).getXmlFilename().equals(filename)) continue;
            result = ((UnfinishedTest)this.unfinishedTests.get(i)).getCompletedTasks();
        }
        return result;
    }

    public int getCompletedTasksFromUnfinishedTest(int testNumber) {
        int result = 0;
        result = ((UnfinishedTest)this.unfinishedTests.get(testNumber)).getCompletedTasks();
        return result;
    }

    public void addToUnfinishedTests(String filename, int numberOfTasks, int completedTasks) {
        boolean found = false;
        for (int i = 0; i < this.unfinishedTests.size(); ++i) {
            if (!((UnfinishedTest)this.unfinishedTests.get(i)).getXmlFilename().equals(filename)) continue;
            found = true;
            ((UnfinishedTest)this.unfinishedTests.get(i)).setNumberOfTasks(numberOfTasks);
            ((UnfinishedTest)this.unfinishedTests.get(i)).setCompletedTasks(completedTasks);
        }
        if (!found) {
            this.unfinishedTests.add(new UnfinishedTest(filename, numberOfTasks, completedTasks));
        }
        this.writeToDisk();
    }

    public void removeFromUnfinishedTests(String filename) {
        for (int i = 0; i < this.unfinishedTests.size(); ++i) {
            if (!((UnfinishedTest)this.unfinishedTests.get(i)).getXmlFilename().equals(filename)) continue;
            this.unfinishedTests.remove(i);
        }
        this.writeToDisk();
    }

    public void writeToDisk() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Throwable x;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document stateDoc = builder.newDocument();
            Element statesOfTestsNode = stateDoc.createElement("statesOfTests");
            stateDoc.appendChild(statesOfTestsNode);
            Text tNode = stateDoc.createTextNode("\n  ");
            statesOfTestsNode.appendChild(tNode);
            Element testDescriptionsNode = stateDoc.createElement("testDescriptions");
            statesOfTestsNode.appendChild(testDescriptionsNode);
            tNode = stateDoc.createTextNode("\n");
            testDescriptionsNode.appendChild(tNode);
            for (int i = 0; i < this.testDescriptions.size(); ++i) {
                Text textNode = stateDoc.createTextNode("    ");
                testDescriptionsNode.appendChild(textNode);
                Element testDescriptionNode = stateDoc.createElement("testDescription");
                testDescriptionsNode.appendChild(testDescriptionNode);
                testDescriptionNode.setAttribute("name", ((TestDescription)this.testDescriptions.get(i)).getXmlFilename());
                testDescriptionNode.setAttribute("lastTestNumber", Integer.toString(((TestDescription)this.testDescriptions.get(i)).getLastTestNumber()));
                textNode = stateDoc.createTextNode("\n");
                testDescriptionsNode.appendChild(textNode);
            }
            tNode = stateDoc.createTextNode("  ");
            testDescriptionsNode.appendChild(tNode);
            tNode = stateDoc.createTextNode("\n  ");
            statesOfTestsNode.appendChild(tNode);
            Element unfinishedTestsNode = stateDoc.createElement("unfinishedTests");
            statesOfTestsNode.appendChild(unfinishedTestsNode);
            tNode = stateDoc.createTextNode("\n");
            unfinishedTestsNode.appendChild(tNode);
            for (int i = 0; i < this.unfinishedTests.size(); ++i) {
                Text textNode = stateDoc.createTextNode("    ");
                unfinishedTestsNode.appendChild(textNode);
                Element unfinishedTestNode = stateDoc.createElement("unfinishedTest");
                unfinishedTestsNode.appendChild(unfinishedTestNode);
                unfinishedTestNode.setAttribute("name", ((UnfinishedTest)this.unfinishedTests.get(i)).getXmlFilename());
                unfinishedTestNode.setAttribute("numberOfTasks", Integer.toString(((UnfinishedTest)this.unfinishedTests.get(i)).getNumberOfTasks()));
                unfinishedTestNode.setAttribute("completedTasks", Integer.toString(((UnfinishedTest)this.unfinishedTests.get(i)).getCompletedTasks()));
                textNode = stateDoc.createTextNode("\n");
                unfinishedTestsNode.appendChild(textNode);
            }
            tNode = stateDoc.createTextNode("  ");
            unfinishedTestsNode.appendChild(tNode);
            try {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                String fileName = this.forceEndingSlash(this.resultPath) + "StateOfTests.xml";
                File outputFile = new File(fileName);
                DOMSource source = new DOMSource(stateDoc);
                StreamResult result = new StreamResult(outputFile);
                transformer.transform(source, result);
            }
            catch (TransformerConfigurationException tce) {
                ErrorLog.log(this, "writeToDisk", "Transformer Factory error", tce);
                x = tce;
                if (tce.getException() != null) {
                    x = tce.getException();
                }
            }
            catch (TransformerException te) {
                ErrorLog.log(this, "writeToDisk", "Transformation error", te);
                x = te;
                if (te.getException() != null) {
                    x = te.getException();
                }
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }

    public Document parseXmlFile(String fileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(new File(fileName));
        }
        catch (SAXException sxe) {
            ErrorLog.log(this, "parseXmlFile", "Error generated during parsing", sxe);
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            System.out.println("\n\n\nScone: UserTestTool ERROR!\n\nThe XML file\n" + fileName + "\nhas an error. The description of the error is:\n" + x.getMessage() + "\nPlease fix the error and restart Scone,\n" + "to avoid any problems with the \"TEA-UserTestTool\" plugin.\n\n");
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            ErrorLog.log(this, "parseXmlFile", "Parser with specified options can't be built", pce);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            ErrorLog.log(this, "parseXmlFile", "I/O error", ioe);
        }
        return this.document;
    }

    private String getText(Node node) {
        String textString = "";
        NodeList nList = node.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            if (nList.item(i).getNodeType() != 3) continue;
            textString = textString + nList.item(i).getNodeValue();
        }
        return textString;
    }

    private String getAttribByName(String attrName, Node node) {
        NamedNodeMap nMap = node.getAttributes();
        String result = "";
        for (int i = 0; i < nMap.getLength(); ++i) {
            if (!nMap.item(i).getNodeName().toLowerCase().equals(attrName.toLowerCase())) continue;
            result = this.getText(nMap.item(i));
        }
        return result;
    }

    protected boolean containsTestDescription(String filename) {
        Document document = this.parseXmlFile(filename);
        return document.getElementsByTagName("userTest").getLength() > 0;
    }

    protected boolean testIsUnfinished(String filename, int[] unfinished) {
        Document document = this.parseXmlFile(filename);
        NodeList nList = document.getElementsByTagName("userTestResult");
        if (nList.getLength() == 1) {
            try {
                unfinished[0] = Integer.parseInt(this.getAttribByName("numberOfTasks", nList.item(0)));
                unfinished[1] = Integer.parseInt(this.getAttribByName("completedTasks", nList.item(0)));
                return unfinished[0] != unfinished[1];
            }
            catch (Exception e) {}
        } else {
            return false;
        }
        return false;
    }

    protected String forceEndingSlash(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + "/";
        }
        return path;
    }

    class UnfinishedTest {
        private String xmlFilename = "";
        private int numberOfTasks = 0;
        private int completedTasks = 0;

        public UnfinishedTest(String xmlFilename, int numberOfTasks, int completedTasks) {
            this.xmlFilename = xmlFilename;
            this.numberOfTasks = numberOfTasks;
            this.completedTasks = completedTasks;
        }

        public String getXmlFilename() {
            return this.xmlFilename;
        }

        public int getNumberOfTasks() {
            return this.numberOfTasks;
        }

        public int getCompletedTasks() {
            return this.completedTasks;
        }

        public void setNumberOfTasks(int numberOfTasks) {
            this.numberOfTasks = numberOfTasks;
        }

        public void setCompletedTasks(int completedTasks) {
            this.completedTasks = completedTasks;
        }
    }

    class TestDescription {
        private String xmlFilename = "";
        private int lastTestNumber = 0;

        public TestDescription(String xmlFilename, int lastTestNumber) {
            this.xmlFilename = xmlFilename;
            this.lastTestNumber = lastTestNumber;
        }

        public String getXmlFilename() {
            return this.xmlFilename;
        }

        public int getLastTestNumber() {
            return this.lastTestNumber;
        }

        public void setLastTestNumber(int lastTestNumber) {
            this.lastTestNumber = lastTestNumber;
        }
    }
}

