/*
 * Decompiled with CFR 0.152.
 */
package scone.usertesttool;

import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scone.usertesttool.ButtonComponent;
import scone.usertesttool.TaskPanel;
import scone.usertesttool.UTButton;
import scone.usertesttool.UTDropDownBox;
import scone.usertesttool.UTLikertScale;
import scone.usertesttool.UTSlider;
import scone.usertesttool.UTTextField;
import scone.usertesttool.UserTestControl;
import scone.util.ErrorLog;

public class Task {
    private boolean caseSensitive = true;
    private String title = "";
    private String taskName = "";
    private ArrayList components;
    private TaskPanel panel = null;
    private UserTestControl utc;

    public Task(Node userTextXml, int taskNumber, UserTestControl utc) {
        this.utc = utc;
        this.xmlTaskToPanel(userTextXml, taskNumber);
    }

    public Task(Node userTextXml, int taskNumber, UserTestControl utc, boolean caseSensitive) {
        this.utc = utc;
        this.caseSensitive = caseSensitive;
        this.xmlTaskToPanel(userTextXml, taskNumber);
    }

    public void xmlTaskToPanel(Node userTestXml, int taskNumber) {
        this.panel = new TaskPanel();
        this.components = new ArrayList();
        try {
            NodeList nodeList = userTestXml.getChildNodes();
            int foundTask = 0;
            for (int i = 0; i < nodeList.getLength() && foundTask != taskNumber; ++i) {
                if (!nodeList.item(i).getNodeName().equals("task") && (!nodeList.item(i).getNodeName().toLowerCase().equals("task") || this.caseSensitive) || ++foundTask != taskNumber) continue;
                this.taskName = this.getAttribByName("name", nodeList.item(i));
                this.outputDebugInfo("Task: TaskName=" + this.taskName);
                NodeList nList = nodeList.item(i).getChildNodes();
                for (int j = 0; j < nList.getLength(); ++j) {
                    this.outputDebugInfo("Task:   " + nList.item(j).getNodeName());
                    if (this.equalsNodeName(nList.item(j), "title")) {
                        this.title = this.getText(nList.item(j));
                        this.outputDebugInfo("Task:     Title=" + this.title);
                        continue;
                    }
                    if (this.equalsNodeName(nList.item(j), "text")) {
                        int bottomPadding = 10;
                        this.panel.addHtml(this.getHtmlText(nList.item(j)), (int)this.utc.getTaskWindow().getSize().getWidth());
                        try {
                            bottomPadding = Integer.parseInt(this.getAttribByName("bottomPadding", nList.item(j)));
                            this.outputDebugInfo("Task:     bottomPadding=" + this.getAttribByName("bottomPadding", nList.item(j)));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (bottomPadding > 0) {
                            this.panel.addPadding(bottomPadding);
                        }
                        this.outputDebugInfo("Task:     Text=" + this.getText(nList.item(j)));
                        continue;
                    }
                    if (this.equalsNodeName(nList.item(j), "button")) {
                        UTButton button = new UTButton(this.utc);
                        button.setComponentName(this.getAttribByName("name", nList.item(j)));
                        this.getButtonProperties(button, nList.item(j));
                        this.components.add(button);
                        this.panel.addItem(button);
                        continue;
                    }
                    if (this.equalsNodeName(nList.item(j), "textField")) {
                        UTTextField textField = new UTTextField(this.utc);
                        textField.setComponentName(this.getAttribByName("name", nList.item(j)));
                        this.getTextFieldProperties(textField, nList.item(j));
                        this.components.add(textField);
                        this.panel.addItem(textField);
                        continue;
                    }
                    if (this.equalsNodeName(nList.item(j), "dropDownBox")) {
                        UTDropDownBox dropDownBox = new UTDropDownBox(this.utc);
                        dropDownBox.setComponentName(this.getAttribByName("name", nList.item(j)));
                        this.getDropDownBoxProperties(dropDownBox, nList.item(j));
                        this.components.add(dropDownBox);
                        this.panel.addItem(dropDownBox);
                        continue;
                    }
                    if (this.equalsNodeName(nList.item(j), "slider")) {
                        UTSlider slider = new UTSlider(this.utc);
                        slider.setComponentName(this.getAttribByName("name", nList.item(j)));
                        this.getSliderProperties(slider, nList.item(j));
                        this.components.add(slider);
                        this.panel.addItem(slider);
                        continue;
                    }
                    if (this.equalsNodeName(nList.item(j), "likertScale")) {
                        UTLikertScale likertScale = new UTLikertScale();
                        likertScale.setComponentName(this.getAttribByName("name", nList.item(j)));
                        this.getLikertScaleProperties(likertScale, nList.item(j));
                        this.components.add(likertScale);
                        this.panel.addItem(likertScale);
                        continue;
                    }
                    if (!this.equalsNodeName(nList.item(j), "useTemplate")) continue;
                    this.outputDebugInfo("Task:     useTemplate name=" + this.getAttribByName("name", nList.item(j)));
                    this.componentsFromTemplate(nList.item(j).getChildNodes(), this.getAttribByName("name", nList.item(j)), userTestXml);
                }
            }
        }
        catch (Exception e) {
            ErrorLog.log(this, "xmlTaskToPanel", "Error while converting xml to Task:\n", e);
        }
    }

    private void componentsFromTemplate(NodeList taskComps, String templateName, Node userTestXml) {
        block31: {
            try {
                NodeList nodeList = userTestXml.getChildNodes();
                int i = 0;
                boolean found = false;
                while (i < nodeList.getLength() && !found) {
                    if (nodeList.item(i).getNodeName().equals("layout")) {
                        found = true;
                        nodeList = nodeList.item(i).getChildNodes();
                        continue;
                    }
                    ++i;
                }
                if (found) {
                    for (i = 0; i < nodeList.getLength(); ++i) {
                        if (!nodeList.item(i).getNodeName().equals("template") || !this.getAttribByName("name", nodeList.item(i)).equals(templateName) || nodeList.item(i).getChildNodes().getLength() < 1) continue;
                        NodeList templateComps = nodeList.item(i).getChildNodes();
                        this.outputDebugInfo("Template gefunden");
                        for (int j = 0; j < templateComps.getLength(); ++j) {
                            this.outputDebugInfo("Task:   " + templateComps.item(j).getNodeName());
                            if (this.equalsNodeName(templateComps.item(j), "title")) {
                                this.title = this.getText(templateComps.item(j));
                                Node node = this.getNodeByTagNameAndNameAttrib(taskComps, "title", "");
                                if (node != null && !this.getText(node).equals("")) {
                                    this.title = this.getText(node);
                                }
                                this.outputDebugInfo("Task:     Title=" + this.title);
                                continue;
                            }
                            if (this.equalsNodeName(templateComps.item(j), "text")) {
                                String textStr = this.getHtmlText(templateComps.item(j));
                                int bottomPadding = 10;
                                try {
                                    bottomPadding = Integer.parseInt(this.getAttribByName("bottomPadding", templateComps.item(j)));
                                    this.outputDebugInfo("Task:     bottomPadding=" + this.getAttribByName("bottomPadding", templateComps.item(j)));
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                                Node node = this.getNodeByTagNameAndNameAttrib(taskComps, "text", this.getAttribByName("name", templateComps.item(j)));
                                if (node != null) {
                                    if (node.hasChildNodes()) {
                                        textStr = this.getHtmlText(node);
                                    }
                                    try {
                                        bottomPadding = Integer.parseInt(this.getAttribByName("bottomPadding", node));
                                        this.outputDebugInfo("Task:     bottomPadding=" + this.getAttribByName("bottomPadding", node));
                                    }
                                    catch (NumberFormatException e) {
                                        // empty catch block
                                    }
                                }
                                this.panel.addHtml(textStr, (int)this.utc.getTaskWindow().getSize().getWidth());
                                if (bottomPadding > 0) {
                                    this.panel.addPadding(bottomPadding);
                                }
                                this.outputDebugInfo("Task:     Text=" + textStr);
                                continue;
                            }
                            if (this.equalsNodeName(templateComps.item(j), "button")) {
                                UTButton button = new UTButton(this.utc);
                                this.getButtonProperties(button, templateComps.item(j));
                                Node node = this.getNodeByTagNameAndNameAttrib(taskComps, "button", this.getAttribByName("name", templateComps.item(j)));
                                if (node != null) {
                                    this.getButtonProperties(button, node);
                                    button.setComponentName(this.getAttribByName("name", node));
                                    this.components.add(button);
                                } else {
                                    button.setComponentName(this.getAttribByName("name", templateComps.item(j)));
                                    this.components.add(button);
                                }
                                this.panel.addItem(button);
                                continue;
                            }
                            if (this.equalsNodeName(templateComps.item(j), "textField")) {
                                UTTextField textField = new UTTextField(this.utc);
                                this.getTextFieldProperties(textField, templateComps.item(j));
                                Node node = this.getNodeByTagNameAndNameAttrib(taskComps, "textField", this.getAttribByName("name", templateComps.item(j)));
                                if (node != null) {
                                    this.getTextFieldProperties(textField, node);
                                    textField.setComponentName(this.getAttribByName("name", node));
                                    this.components.add(textField);
                                } else {
                                    textField.setComponentName(this.getAttribByName("name", templateComps.item(j)));
                                    this.components.add(textField);
                                }
                                this.panel.addItem(textField);
                                continue;
                            }
                            if (this.equalsNodeName(templateComps.item(j), "dropDownBox")) {
                                UTDropDownBox dropDownBox = new UTDropDownBox(this.utc);
                                this.getDropDownBoxProperties(dropDownBox, templateComps.item(j));
                                Node node = this.getNodeByTagNameAndNameAttrib(taskComps, "dropDownBox", this.getAttribByName("name", templateComps.item(j)));
                                if (node != null) {
                                    this.getDropDownBoxProperties(dropDownBox, node);
                                    dropDownBox.setComponentName(this.getAttribByName("name", node));
                                    this.components.add(dropDownBox);
                                } else {
                                    dropDownBox.setComponentName(this.getAttribByName("name", templateComps.item(j)));
                                    this.components.add(dropDownBox);
                                }
                                this.panel.addItem(dropDownBox);
                                continue;
                            }
                            if (this.equalsNodeName(templateComps.item(j), "slider")) {
                                UTSlider slider = new UTSlider(this.utc);
                                this.getSliderProperties(slider, templateComps.item(j));
                                Node node = this.getNodeByTagNameAndNameAttrib(taskComps, "slider ", this.getAttribByName("name", templateComps.item(j)));
                                if (node != null) {
                                    this.getSliderProperties(slider, node);
                                    slider.setComponentName(this.getAttribByName("name", node));
                                    this.components.add(slider);
                                } else {
                                    slider.setComponentName(this.getAttribByName("name", templateComps.item(j)));
                                    this.components.add(slider);
                                }
                                this.panel.addItem(slider);
                                continue;
                            }
                            if (!this.equalsNodeName(templateComps.item(j), "likertScale")) continue;
                            UTLikertScale likertScale = new UTLikertScale();
                            this.getLikertScaleProperties(likertScale, templateComps.item(j));
                            Node node = this.getNodeByTagNameAndNameAttrib(taskComps, "likertScale", this.getAttribByName("name", templateComps.item(j)));
                            if (node != null) {
                                this.getLikertScaleProperties(likertScale, node);
                                likertScale.setComponentName(this.getAttribByName("name", node));
                                this.components.add(likertScale);
                            } else {
                                likertScale.setComponentName(this.getAttribByName("name", templateComps.item(j)));
                                this.components.add(likertScale);
                            }
                            this.panel.addItem(likertScale);
                        }
                    }
                    break block31;
                }
                System.out.println("");
                System.out.println("Scone: UserTestTool");
                System.out.println("");
                System.out.println("Eroor: The XML file that controls the current user test refers to template");
                System.out.println(templateName + ". However, in this XML file no \"layout\" section can");
                System.out.println("be found in the \"userTest\" element, that defines the ");
                System.out.println("required templates.");
                System.out.println("");
            }
            catch (Exception e) {
                ErrorLog.log(this, "componentsFromTemplate", "Error while converting xml to Task:\n", e);
            }
        }
    }

    private void getButtonProperties(UTButton button, Node node) {
        this.outputDebugInfo("Task:     name=" + this.getAttribByName("name", node));
        button.setName(this.getAttribByName("name", node));
        if (this.getAttribByNameOrReturnNull("text", node) != null) {
            button.setText(this.getAttribByName("text", node));
            this.outputDebugInfo("Task:     text=" + this.getAttribByName("text", node));
        }
        if (this.getAttribByNameOrReturnNull("enabled", node) != null) {
            if (this.getAttribByName("enabled", node).toLowerCase().equals("false")) {
                button.setComponentEnabled(false);
                this.outputDebugInfo("Task:     enabled=\"false\"");
            }
            if (this.getAttribByName("enabled", node).toLowerCase().equals("true")) {
                button.setComponentEnabled(true);
                this.outputDebugInfo("Task:     enabled=\"true\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("highlighted", node) != null) {
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("true")) {
                button.setComponentHighlighted(true);
                this.outputDebugInfo("Task:     highlighted=\"true\"");
            }
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("false")) {
                button.setComponentHighlighted(false);
                this.outputDebugInfo("Task:     highlighted=\"false\"");
            }
        }
        try {
            button.setComponentBottomPadding(Integer.parseInt(this.getAttribByName("bottomPadding", node)));
            this.outputDebugInfo("Task:     bottomPadding=" + this.getAttribByName("bottomPadding", node));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.readActions(button, node);
    }

    private void getTextFieldProperties(UTTextField textField, Node node) {
        this.outputDebugInfo("Task:     name=" + this.getAttribByName("name", node));
        textField.setName(this.getAttribByName("name", node));
        if (this.getAttribByNameOrReturnNull("text", node) != null) {
            textField.setDescription(this.getAttribByName("text", node));
            this.outputDebugInfo("Task:     text=" + this.getAttribByName("text", node));
        }
        if (this.getAttribByNameOrReturnNull("description", node) != null) {
            textField.setDescription(this.getAttribByName("description", node));
            this.outputDebugInfo("Task:     description=" + this.getAttribByName("description", node));
        }
        if (this.getAttribByNameOrReturnNull("height", node) != null) {
            try {
                textField.setHeight(Integer.parseInt(this.getAttribByName("height", node)));
                this.outputDebugInfo("Task:     height=" + this.getAttribByName("height", node));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this.getAttribByNameOrReturnNull("required", node) != null) {
            if (this.getAttribByName("required", node).toLowerCase().equals("true")) {
                textField.setInputRequired(true);
                this.outputDebugInfo("Task:     required=\"true\"");
            }
            if (this.getAttribByName("required", node).toLowerCase().equals("false")) {
                textField.setInputRequired(false);
                this.outputDebugInfo("Task:     required=\"false\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("enabled", node) != null) {
            if (this.getAttribByName("enabled", node).toLowerCase().equals("false")) {
                textField.setComponentEnabled(false);
                this.outputDebugInfo("Task:     enabled=\"false\"");
            }
            if (this.getAttribByName("enabled", node).toLowerCase().equals("true")) {
                textField.setComponentEnabled(true);
                this.outputDebugInfo("Task:     enabled=\"true\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("highlighted", node) != null) {
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("true")) {
                textField.setComponentHighlighted(true);
                this.outputDebugInfo("Task:     highlighted=\"true\"");
            }
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("false")) {
                textField.setComponentHighlighted(false);
                this.outputDebugInfo("Task:     highlighted=\"false\"");
            }
        }
        try {
            textField.setComponentBottomPadding(Integer.parseInt(this.getAttribByName("bottomPadding", node)));
            this.outputDebugInfo("Task:     bottomPadding=" + this.getAttribByName("bottomPadding", node));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void getDropDownBoxProperties(UTDropDownBox dropDownBox, Node node) {
        this.outputDebugInfo("Task:     name=" + this.getAttribByName("name", node));
        dropDownBox.setName(this.getAttribByName("name", node));
        if (this.getAttribByNameOrReturnNull("description", node) != null) {
            dropDownBox.setDescription(this.getAttribByName("description", node));
            this.outputDebugInfo("Task:     description=" + this.getAttribByName("description", node));
        }
        if (this.getAttribByNameOrReturnNull("required", node) != null) {
            if (this.getAttribByName("required", node).toLowerCase().equals("true")) {
                dropDownBox.setInputRequired(true);
                this.outputDebugInfo("Task:     required=\"true\"");
            }
            if (this.getAttribByName("required", node).toLowerCase().equals("false")) {
                dropDownBox.setInputRequired(false);
                this.outputDebugInfo("Task:     required=\"false\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("enabled", node) != null) {
            if (this.getAttribByName("enabled", node).toLowerCase().equals("false")) {
                dropDownBox.setComponentEnabled(false);
                this.outputDebugInfo("Task:     enabled=\"false\"");
            }
            if (this.getAttribByName("enabled", node).toLowerCase().equals("true")) {
                dropDownBox.setComponentEnabled(true);
                this.outputDebugInfo("Task:     enabled=\"true\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("highlighted", node) != null) {
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("true")) {
                dropDownBox.setComponentHighlighted(true);
                this.outputDebugInfo("Task:     highlighted=\"true\"");
            }
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("false")) {
                dropDownBox.setComponentHighlighted(false);
                this.outputDebugInfo("Task:     highlighted=\"false\"");
            }
        }
        try {
            dropDownBox.setComponentBottomPadding(Integer.parseInt(this.getAttribByName("bottomPadding", node)));
            this.outputDebugInfo("Task:     bottomPadding=" + this.getAttribByName("bottomPadding", node));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.readItems(dropDownBox, node);
    }

    private void getSliderProperties(UTSlider slider, Node node) {
        this.outputDebugInfo("Task:     Slider: name=" + this.getAttribByName("name", node));
        slider.setName(this.getAttribByName("name", node));
        if (this.getAttribByNameOrReturnNull("description", node) != null) {
            slider.setDescription(this.getAttribByName("description", node));
            this.outputDebugInfo("Task:     description=" + this.getAttribByName("description", node));
        }
        try {
            slider.setMajorTickSpacing(Integer.parseInt(this.getAttribByName("majorTickSpacing", node)));
            this.outputDebugInfo("Task:     majorTickSpacing=" + this.getAttribByName("majorTickSpacing", node));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            slider.setMinorTickSpacing(Integer.parseInt(this.getAttribByName("minorTickSpacing", node)));
            this.outputDebugInfo("Task:     minorTickSpacing=" + this.getAttribByName("minorTickSpacing", node));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            slider.setMinimum(Integer.parseInt(this.getAttribByName("minimum", node)));
            this.outputDebugInfo("Task:     minimum=" + this.getAttribByName("minimum", node));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            slider.setMaximum(Integer.parseInt(this.getAttribByName("maximum", node)));
            this.outputDebugInfo("Task:     maximum=" + this.getAttribByName("maximum", node));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            slider.setDefault(Integer.parseInt(this.getAttribByName("default", node)));
            this.outputDebugInfo("Task:     default=" + this.getAttribByName("default", node));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.getAttribByNameOrReturnNull("snapToTicks", node) != null) {
            if (this.getAttribByName("snapToTicks", node).toLowerCase().equals("true")) {
                slider.setSnapToTicks(true);
                this.outputDebugInfo("Task:     snapToTicks=\"true\"");
            }
            if (this.getAttribByName("snapToTicks", node).toLowerCase().equals("false")) {
                slider.setSnapToTicks(false);
                this.outputDebugInfo("Task:     snapToTicks=\"false\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("paintLabels", node) != null) {
            if (this.getAttribByName("paintLabels", node).toLowerCase().equals("true")) {
                slider.setPaintLabels(true);
                this.outputDebugInfo("Task:     paintLabels=\"true\"");
            }
            if (this.getAttribByName("paintLabels", node).toLowerCase().equals("false")) {
                slider.setPaintLabels(false);
                this.outputDebugInfo("Task:     paintLabels=\"false\"");
            }
        }
        slider.createSlider();
        if (this.getAttribByNameOrReturnNull("required", node) != null) {
            if (this.getAttribByName("required", node).toLowerCase().equals("true")) {
                slider.setInputRequired(true);
                this.outputDebugInfo("Task:     required=\"true\"");
            }
            if (this.getAttribByName("required", node).toLowerCase().equals("false")) {
                slider.setInputRequired(false);
                this.outputDebugInfo("Task:     required=\"false\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("enabled", node) != null) {
            if (this.getAttribByName("enabled", node).toLowerCase().equals("false")) {
                slider.setComponentEnabled(false);
                this.outputDebugInfo("Task:     enabled=\"false\"");
            }
            if (this.getAttribByName("enabled", node).toLowerCase().equals("true")) {
                slider.setComponentEnabled(true);
                this.outputDebugInfo("Task:     enabled=\"true\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("highlighted", node) != null) {
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("true")) {
                slider.setComponentHighlighted(true);
                this.outputDebugInfo("Task:     highlighted=\"true\"");
            }
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("false")) {
                slider.setComponentHighlighted(false);
                this.outputDebugInfo("Task:     highlighted=\"false\"");
            }
        }
        try {
            slider.setComponentBottomPadding(Integer.parseInt(this.getAttribByName("bottomPadding", node)));
            this.outputDebugInfo("Task:     bottomPadding=" + this.getAttribByName("bottomPadding", node));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void getLikertScaleProperties(UTLikertScale likertScale, Node node) {
        this.outputDebugInfo("Task:     LikertScaleName=" + this.getAttribByName("name", node));
        likertScale.setName(this.getAttribByName("name", node));
        if (this.getAttribByNameOrReturnNull("description", node) != null) {
            likertScale.setDescription(this.getAttribByName("description", node));
            this.outputDebugInfo("Task:     description=" + this.getAttribByName("description", node));
        }
        int numberOfRatings = 5;
        try {
            likertScale.setNumberOfRatings(Integer.parseInt(this.getAttribByName("numberOfRatings", node)));
            this.outputDebugInfo("Task:     numberOfRatings=" + this.getAttribByName("numberOfRatings", node));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.getAttribByNameOrReturnNull("maxLabel", node) != null) {
            likertScale.setRightLabel(this.getAttribByName("maxLabel", node));
            this.outputDebugInfo("Task:     maxLabel=" + this.getAttribByName("maxLabel", node));
        }
        if (this.getAttribByNameOrReturnNull("minLabel", node) != null) {
            likertScale.setLeftLabel(this.getAttribByName("minLabel", node));
            this.outputDebugInfo("Task:     minLabel=" + this.getAttribByName("minLabel", node));
        }
        likertScale.createLikertScale();
        if (this.getAttribByNameOrReturnNull("required", node) != null) {
            if (this.getAttribByName("required", node).toLowerCase().equals("true")) {
                likertScale.setInputRequired(true);
                this.outputDebugInfo("Task:     required=\"true\"");
            }
            if (this.getAttribByName("required", node).toLowerCase().equals("false")) {
                likertScale.setInputRequired(false);
                this.outputDebugInfo("Task:     required=\"false\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("enabled", node) != null) {
            if (this.getAttribByName("enabled", node).toLowerCase().equals("false")) {
                likertScale.setComponentEnabled(false);
                this.outputDebugInfo("Task:     enabled=\"false\"");
            }
            if (this.getAttribByName("enabled", node).toLowerCase().equals("true")) {
                likertScale.setComponentEnabled(true);
                this.outputDebugInfo("Task:     enabled=\"true\"");
            }
        }
        if (this.getAttribByNameOrReturnNull("highlighted", node) != null) {
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("true")) {
                likertScale.setComponentHighlighted(true);
                this.outputDebugInfo("Task:     highlighted=\"true\"");
            }
            if (this.getAttribByName("highlighted", node).toLowerCase().equals("false")) {
                likertScale.setComponentHighlighted(false);
                this.outputDebugInfo("Task:     highlighted=\"false\"");
            }
        }
        try {
            likertScale.setComponentBottomPadding(Integer.parseInt(this.getAttribByName("bottomPadding", node)));
            this.outputDebugInfo("Task:     bottomPadding=" + this.getAttribByName("bottomPadding", node));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private Node getChildByName(Node node, String name) {
        int i = 0;
        Node result = null;
        boolean finished = false;
        NodeList nList = node.getChildNodes();
        while (i < nList.getLength() & !finished) {
            if (nList.item(i).getNodeName().equals(name)) {
                result = nList.item(i);
                finished = true;
            }
            ++i;
        }
        return result;
    }

    private String getText(Node node) {
        String textString = "";
        NodeList nList = node.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            if (nList.item(i).getNodeType() != 3) continue;
            textString = textString + nList.item(i).getNodeValue();
        }
        return textString;
    }

    private String getHtmlText(Node node) {
        String textString = "";
        NodeList nList = node.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            if (nList.item(i).getNodeType() == 3) {
                textString = textString + nList.item(i).getNodeValue();
                continue;
            }
            if (nList.item(i).getNodeType() != 1) continue;
            textString = textString + "<" + nList.item(i).getNodeName() + ">" + this.getHtmlText(nList.item(i)) + "</" + nList.item(i).getNodeName() + ">";
        }
        return textString;
    }

    private String getAttribByName(String attrName, Node node) {
        NamedNodeMap nMap = node.getAttributes();
        String result = "";
        if (nMap != null) {
            for (int i = 0; i < nMap.getLength(); ++i) {
                if (!nMap.item(i).getNodeName().equals(attrName)) continue;
                result = this.getText(nMap.item(i));
            }
        }
        return result;
    }

    private String getAttribByNameOrReturnNull(String attrName, Node node) {
        NamedNodeMap nMap = node.getAttributes();
        String result = null;
        if (nMap != null) {
            for (int i = 0; i < nMap.getLength(); ++i) {
                if (!nMap.item(i).getNodeName().equals(attrName)) continue;
                result = this.getText(nMap.item(i));
            }
        }
        return result;
    }

    private Node getNodeByTagNameAndNameAttrib(NodeList componentList, String tagName, String attribName) {
        for (int i = 0; i < componentList.getLength(); ++i) {
            if (!componentList.item(i).getNodeName().equals(tagName) || !this.getAttribByName("nameInTemplate", componentList.item(i)).equals(attribName)) continue;
            return componentList.item(i);
        }
        return null;
    }

    private void readActions(ButtonComponent component, Node node) {
        NodeList nList = node.getChildNodes();
        for (int k = 0; k < nList.getLength(); ++k) {
            if (this.equalsNodeName(nList.item(k), "openUri")) {
                component.addAction("openUri", this.getText(nList.item(k)));
                this.outputDebugInfo("Task:     openUri=" + this.getText(nList.item(k)));
            }
            if (this.equalsNodeName(nList.item(k), "javaScriptCommand")) {
                component.addAction("javaScriptCommand", this.getText(nList.item(k)));
                this.outputDebugInfo("Task:     javaScriptCommand=" + this.getText(nList.item(k)));
            }
            if (this.equalsNodeName(nList.item(k), "browserToFront")) {
                component.addAction("browserToFront", this.getText(nList.item(k)));
                this.outputDebugInfo("Task:     browserToFront");
            }
            if (this.equalsNodeName(nList.item(k), "browserResize")) {
                int browserWidth = 640;
                int browserHeight = 480;
                try {
                    browserWidth = Integer.parseInt(this.getAttribByName("width", nList.item(k)));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                try {
                    browserHeight = Integer.parseInt(this.getAttribByName("height", nList.item(k)));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                component.addAction("browserResize", browserWidth + "x" + browserHeight);
                this.outputDebugInfo("Task:     browserResize " + browserWidth + "x" + browserHeight);
            }
            if (this.equalsNodeName(nList.item(k), "moveBrowserWindow")) {
                int x = 0;
                int y = 0;
                try {
                    x = Integer.parseInt(this.getAttribByName("x", nList.item(k)));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                try {
                    y = Integer.parseInt(this.getAttribByName("y", nList.item(k)));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                component.addAction("moveBrowserWindow", x + "x" + y);
                this.outputDebugInfo("Task:     moveBrowserWindow " + x + "x" + y);
            }
            if (this.equalsNodeName(nList.item(k), "startNextTask")) {
                component.addAction("startNextTask", "");
                this.outputDebugInfo("Task:     startNextTask");
            }
            if (this.equalsNodeName(nList.item(k), "cancelTest")) {
                component.addAction("cancelTest", "");
                this.outputDebugInfo("Task:     cancelTest");
            }
            if (this.equalsNodeName(nList.item(k), "enable")) {
                component.addAction("enable", this.getText(nList.item(k)));
                this.outputDebugInfo("Task:     enable=" + this.getText(nList.item(k)));
            }
            if (this.equalsNodeName(nList.item(k), "disable")) {
                component.addAction("disable", this.getText(nList.item(k)));
                this.outputDebugInfo("Task:     disable=" + this.getText(nList.item(k)));
            }
            if (this.equalsNodeName(nList.item(k), "stopWatchStart")) {
                component.addAction("stopWatchStart", this.getText(nList.item(k)));
                this.outputDebugInfo("Task:     stopWatchStart=" + this.getText(nList.item(k)));
            }
            if (this.equalsNodeName(nList.item(k), "stopWatchElapsed")) {
                component.addAction("stopWatchElapsed", this.getText(nList.item(k)));
                this.outputDebugInfo("Task:     stopWatchElapsed=" + this.getText(nList.item(k)));
            }
            if (this.equalsNodeName(nList.item(k), "stopWatchLapTime")) {
                component.addAction("stopWatchLapTime", this.getText(nList.item(k)));
                this.outputDebugInfo("Task:     stopWatchLapTime=" + this.getText(nList.item(k)));
            }
            if (this.equalsNodeName(nList.item(k), "highlight")) {
                component.addAction("highlight", this.getText(nList.item(k)));
                this.outputDebugInfo("Task:     highlight" + this.getText(nList.item(k)));
            }
            if (!this.equalsNodeName(nList.item(k), "unhighlight")) continue;
            component.addAction("unhighlight", this.getText(nList.item(k)));
            this.outputDebugInfo("Task:     unhighlight=" + this.getText(nList.item(k)));
        }
    }

    private void readItems(UTDropDownBox component, Node node) {
        NodeList nList = node.getChildNodes();
        for (int k = 0; k < nList.getLength(); ++k) {
            if (!this.equalsNodeName(nList.item(k), "item")) continue;
            long value = 0L;
            boolean selectable = true;
            boolean showThisFirst = false;
            try {
                value = Integer.parseInt(this.getAttribByName("value", nList.item(k)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            selectable = !this.getAttribByName("selectable", nList.item(k)).toLowerCase().equals("false");
            showThisFirst = this.getAttribByName("showThisFirst", nList.item(k)).toLowerCase().equals("true");
            component.addItem(value, this.getText(nList.item(k)), selectable, showThisFirst);
            this.outputDebugInfo("Task:     DropDownBoxItem:" + this.getText(nList.item(k)));
        }
    }

    private boolean equalsNodeName(Node node, String name) {
        return node.getNodeName().equals(name) || node.getNodeName().toLowerCase().equals(name.toLowerCase()) && !this.caseSensitive;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public ArrayList getComponents() {
        return this.components;
    }

    public TaskPanel getTaskPanel() {
        return this.panel;
    }

    public String getTitle() {
        return this.title;
    }

    public void outputDebugInfo(String info) {
        if (this.utc.outputDebugInfo) {
            System.out.println(info);
        }
    }
}

