/*
 * Decompiled with CFR 0.152.
 */
package scone.usertesttool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import scone.usertesttool.AllComponents;
import scone.usertesttool.InputComponent;
import scone.usertesttool.UIStyle;
import scone.usertesttool.UserTestControl;

public class UTComboBox
extends Box
implements InputComponent,
AllComponents {
    private JComboBox jComboBox;
    private String compName = "";
    private ArrayList itemList = new ArrayList();
    private JLabel descriptionLabel = null;
    private String description = "";
    private long timeStamp = 0L;
    private UserTestControl utc;
    private UTComboBox thisInstance;
    int readOutCounter = 0;
    int numberOfData = 2;
    private boolean inputRequired = false;

    public UTComboBox(UserTestControl utc) {
        this(utc, "", 1300);
    }

    public UTComboBox(UserTestControl utc, String description) {
        this(utc, description, 1300);
    }

    public UTComboBox(UserTestControl utc, String description, int width) {
        this(utc, description, width, true);
    }

    public UTComboBox(UserTestControl utc, String description, int width, boolean enabled) {
        super(1);
        this.utc = utc;
        this.thisInstance = this;
        Box hBox = Box.createHorizontalBox();
        this.descriptionLabel = new JLabel(description);
        this.descriptionLabel.setFont(UIStyle.PLAINFONT);
        this.descriptionLabel.setForeground(Color.black);
        hBox.add(this.descriptionLabel);
        hBox.add(Box.createHorizontalGlue());
        this.add(hBox);
        hBox = Box.createHorizontalBox();
        this.jComboBox = new JComboBox();
        this.jComboBox.addActionListener(new Action2TimeStampActionListener());
        this.jComboBox.setPreferredSize(new Dimension(width, 22));
        this.jComboBox.setMaximumSize(new Dimension(width, 22));
        this.jComboBox.setEnabled(enabled);
        hBox.add(this.jComboBox);
        hBox.add(Box.createHorizontalGlue());
        this.add(hBox);
    }

    public void setComponentEnabled(boolean enable) {
        this.setEnabled(enable);
        this.jComboBox.setEnabled(enable);
        if (enable) {
            this.jComboBox.requestFocus();
        } else {
            this.setComponentHighlighted(false);
        }
    }

    public void setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
    }

    public void setDescription(String description) {
        this.description = description;
        this.descriptionLabel.setText(description);
    }

    public void addItem(long value, String text, boolean selectable, boolean showThisItemFirst) {
        this.itemList.add(new ComboItem(value, text, selectable));
        this.jComboBox.addItem(text);
        if (showThisItemFirst) {
            this.jComboBox.setSelectedIndex(this.jComboBox.getItemCount() - 1);
        }
    }

    public void componentRequestFocus() {
        this.jComboBox.requestFocus();
    }

    public void setComponentHighlighted(boolean highlight) {
        if (highlight) {
            this.setBackground(new Color(230, 230, 128));
        } else {
            this.setBackground(new Color(204, 204, 204));
        }
    }

    public boolean changedByUser() {
        if (this.inputRequired && !((ComboItem)this.itemList.get(this.jComboBox.getSelectedIndex())).isSelectable()) {
            this.jComboBox.requestFocus();
            return false;
        }
        return true;
    }

    public void setComponentName(String componentName) {
        this.compName = componentName;
    }

    public String getComponentName() {
        return this.compName;
    }

    public void startDataQuery() {
        this.readOutCounter = 0;
    }

    public boolean hasMoreData() {
        return this.readOutCounter < this.numberOfData;
    }

    public String getTagName() {
        switch (this.readOutCounter) {
            case 0: {
                return "comboBoxText";
            }
            case 1: {
                return "comboBoxValue";
            }
        }
        return "";
    }

    public String getData() {
        switch (this.readOutCounter) {
            case 0: {
                return (String)this.jComboBox.getSelectedItem();
            }
            case 1: {
                return Long.toString(((ComboItem)this.itemList.get(this.jComboBox.getSelectedIndex())).getValue());
            }
        }
        return "";
    }

    public String getTimeStamp() {
        return Long.toString(this.timeStamp);
    }

    public void getNextData() {
        if (this.readOutCounter < this.numberOfData) {
            ++this.readOutCounter;
        }
    }

    public void setComponentBottomPadding(int padding) {
    }

    class ComboItem {
        private long value;
        private String text;
        private boolean selectable;

        public ComboItem(long value, String text, boolean selectable) {
            this.value = value;
            this.text = text;
            this.selectable = selectable;
        }

        public long getValue() {
            return this.value;
        }

        public boolean isSelectable() {
            return this.selectable;
        }
    }

    class Action2TimeStampActionListener
    implements ActionListener {
        Action2TimeStampActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            UTComboBox.this.timeStamp = System.currentTimeMillis();
        }
    }
}

