/*
 * Decompiled with CFR 0.152.
 */
package scone.usertesttool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import scone.usertesttool.AllComponents;
import scone.usertesttool.InputComponent;
import scone.usertesttool.UIStyle;
import scone.usertesttool.UserTestControl;

public class UTDropDownBox
extends Box
implements InputComponent,
AllComponents {
    private JComboBox jDropDownBox;
    private String compName = "";
    private int bottomPadding = 10;
    private ArrayList itemList = new ArrayList();
    private JLabel descriptionLabel = null;
    private String description = "";
    private long timeStamp = 0L;
    private UserTestControl utc;
    private UTDropDownBox thisInstance;
    private Box descriptionBox;
    private Box dropDownBoxBox;
    private Box paddingBox;
    int readOutCounter = 0;
    int numberOfData = 2;
    private boolean inputRequired = false;

    public UTDropDownBox(UserTestControl utc) {
        this(utc, "", 1300);
    }

    public UTDropDownBox(UserTestControl utc, String description) {
        this(utc, description, 1300);
    }

    public UTDropDownBox(UserTestControl utc, String description, int width) {
        this(utc, description, width, true);
    }

    public UTDropDownBox(UserTestControl utc, String description, int width, boolean enabled) {
        super(1);
        this.utc = utc;
        this.thisInstance = this;
        this.descriptionBox = Box.createHorizontalBox();
        this.descriptionLabel = new JLabel(description);
        this.descriptionLabel.setFont(UIStyle.PLAINFONT);
        this.descriptionLabel.setForeground(Color.black);
        this.descriptionBox.add(this.descriptionLabel);
        this.descriptionBox.add(Box.createHorizontalGlue());
        this.add(this.descriptionBox);
        this.dropDownBoxBox = Box.createHorizontalBox();
        this.jDropDownBox = new JComboBox();
        this.jDropDownBox.addActionListener(new MyActionListener());
        this.jDropDownBox.setMaximumSize(this.jDropDownBox.getPreferredSize());
        this.jDropDownBox.setEnabled(enabled);
        this.dropDownBoxBox.add(this.jDropDownBox);
        this.dropDownBoxBox.add(Box.createHorizontalGlue());
        this.add(this.dropDownBoxBox);
        this.paddingBox = new Box(0);
        this.paddingBox.add(Box.createRigidArea(new Dimension(0, this.bottomPadding)));
        this.add(this.paddingBox);
    }

    public void setComponentEnabled(boolean enable) {
        this.setEnabled(enable);
        this.jDropDownBox.setEnabled(enable);
        if (enable) {
            this.jDropDownBox.requestFocus();
        } else {
            this.setComponentHighlighted(false);
        }
    }

    public void setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
    }

    public void setDescription(String description) {
        this.description = description;
        this.descriptionLabel.setText(description);
    }

    public void addItem(long value, String text, boolean selectable, boolean showThisItemFirst) {
        this.itemList.add(new ComboItem(value, text, selectable));
        this.jDropDownBox.addItem(text);
        if (showThisItemFirst) {
            this.jDropDownBox.setSelectedIndex(this.jDropDownBox.getItemCount() - 1);
        }
    }

    public void componentRequestFocus() {
        this.jDropDownBox.requestFocus();
    }

    public void setComponentHighlighted(boolean highlight) {
        if (highlight) {
            this.setBackground(new Color(230, 230, 128));
        } else {
            this.setBackground(new Color(204, 204, 204));
        }
    }

    public boolean changedByUser() {
        if (this.inputRequired && !((ComboItem)this.itemList.get(this.jDropDownBox.getSelectedIndex())).isSelectable()) {
            this.jDropDownBox.requestFocus();
            return false;
        }
        return true;
    }

    public void setComponentName(String componentName) {
        this.compName = componentName;
    }

    public void setComponentBottomPadding(int padding) {
        this.bottomPadding = padding;
        this.removeAll();
        this.paddingBox = new Box(0);
        this.paddingBox.add(Box.createRigidArea(new Dimension(0, this.bottomPadding)));
        this.add(this.descriptionBox);
        this.add(this.dropDownBoxBox);
        this.add(this.paddingBox);
    }

    public String getComponentName() {
        return this.compName;
    }

    public void startDataQuery() {
        this.readOutCounter = 0;
    }

    public boolean hasMoreData() {
        return this.readOutCounter < this.numberOfData;
    }

    public String getTagName() {
        switch (this.readOutCounter) {
            case 0: {
                return "dropDownBoxText";
            }
            case 1: {
                return "dropDownBoxValue";
            }
        }
        return "";
    }

    public String getData() {
        switch (this.readOutCounter) {
            case 0: {
                return (String)this.jDropDownBox.getSelectedItem();
            }
            case 1: {
                return Long.toString(((ComboItem)this.itemList.get(this.jDropDownBox.getSelectedIndex())).getValue());
            }
        }
        return "";
    }

    public String getTimeStamp() {
        return Long.toString(this.timeStamp);
    }

    public void getNextData() {
        if (this.readOutCounter < this.numberOfData) {
            ++this.readOutCounter;
        }
    }

    class ComboItem {
        private long value;
        private String text;
        private boolean selectable;

        public ComboItem(long value, String text, boolean selectable) {
            this.value = value;
            this.text = text;
            this.selectable = selectable;
        }

        public long getValue() {
            return this.value;
        }

        public boolean isSelectable() {
            return this.selectable;
        }
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            UTDropDownBox.this.timeStamp = System.currentTimeMillis();
        }
    }
}

