/*
 * Decompiled with CFR 0.152.
 */
package scone.usertesttool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import scone.usertesttool.AllComponents;
import scone.usertesttool.InputComponent;
import scone.usertesttool.UIStyle;

public class UTLikertScale
extends Box
implements InputComponent,
AllComponents {
    private String compName = "";
    private int bottomPadding = 10;
    private int numberOfRatings = 5;
    private String leftLabel = "";
    private String rightLabel = "";
    private String description = "";
    private boolean inputRequired = false;
    private long timeStamp = 0L;
    private JRadioButton[] buttons;
    private JLabel descriptionLabel = new JLabel();
    private Box descriptionBox;
    private Box scaleBox;
    private Box paddingBox;
    int readOutCounter = 0;
    int numberOfData = 1;

    public UTLikertScale() {
        super(1);
        this.createLikertScale();
    }

    public void createLikertScale() {
        this.removeAll();
        this.buttons = new JRadioButton[this.numberOfRatings];
        this.descriptionBox = Box.createHorizontalBox();
        this.descriptionLabel = new JLabel(this.description);
        this.descriptionLabel.setFont(UIStyle.PLAINFONT);
        this.descriptionLabel.setForeground(Color.black);
        this.descriptionBox.add(this.descriptionLabel);
        this.descriptionBox.add(Box.createHorizontalGlue());
        this.add(this.descriptionBox);
        ButtonGroup group = new ButtonGroup();
        this.scaleBox = Box.createHorizontalBox();
        JLabel jlabel = new JLabel(this.leftLabel);
        jlabel.setFont(UIStyle.PLAINFONT);
        jlabel.setForeground(Color.black);
        jlabel.setPreferredSize(new Dimension(120, 20));
        this.scaleBox.add(jlabel);
        this.scaleBox.add(Box.createRigidArea(new Dimension(10, 0)));
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new JRadioButton(Integer.toString(i + 1));
            this.buttons[i].setFont(UIStyle.PLAINFONT);
            this.buttons[i].addActionListener(new MyActionListener());
            group.add(this.buttons[i]);
            this.scaleBox.add(this.buttons[i]);
        }
        this.scaleBox.add(Box.createRigidArea(new Dimension(10, 0)));
        jlabel = new JLabel(this.rightLabel);
        jlabel.setFont(UIStyle.PLAINFONT);
        jlabel.setForeground(Color.black);
        this.scaleBox.add(jlabel);
        this.scaleBox.add(Box.createHorizontalGlue());
        this.add(this.scaleBox);
        this.paddingBox = new Box(0);
        this.paddingBox.add(Box.createRigidArea(new Dimension(0, this.bottomPadding)));
        this.add(this.paddingBox);
    }

    public void setDescription(String description) {
        this.description = description;
        this.descriptionLabel.setText(description);
    }

    public void setLeftLabel(String leftLabel) {
        this.leftLabel = leftLabel;
    }

    public void setRightLabel(String rightLabel) {
        this.rightLabel = rightLabel;
    }

    public void setNumberOfRatings(int numberOfRatings) {
        this.numberOfRatings = numberOfRatings;
    }

    public void setComponentEnabled(boolean enabled) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setEnabled(enabled);
        }
        if (!enabled) {
            this.setComponentHighlighted(false);
        }
    }

    public void setComponentHighlighted(boolean highlight) {
        if (highlight) {
            this.setBackground(new Color(230, 230, 128));
        } else {
            this.setBackground(new Color(204, 204, 204));
        }
    }

    public void componentRequestFocus() {
        this.buttons[0].requestFocus();
    }

    public void setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
    }

    public boolean changedByUser() {
        boolean foundSelectedButton = false;
        if (this.inputRequired) {
            for (int i = 0; i < this.buttons.length; ++i) {
                if (!this.buttons[i].isSelected()) continue;
                foundSelectedButton = true;
            }
            if (!foundSelectedButton) {
                this.buttons[0].requestFocus();
            }
        } else {
            foundSelectedButton = true;
        }
        return foundSelectedButton;
    }

    public void setComponentName(String componentName) {
        this.compName = componentName;
    }

    public void setComponentBottomPadding(int padding) {
        this.bottomPadding = padding;
        this.removeAll();
        this.paddingBox = new Box(0);
        this.paddingBox.add(Box.createRigidArea(new Dimension(0, this.bottomPadding)));
        this.add(this.descriptionBox);
        this.add(this.scaleBox);
        this.add(this.paddingBox);
    }

    public String getComponentName() {
        return this.compName;
    }

    public void startDataQuery() {
        this.readOutCounter = 0;
    }

    public boolean hasMoreData() {
        return this.readOutCounter < this.numberOfData;
    }

    public String getTagName() {
        return "likertScaleSelection";
    }

    public String getData() {
        String result = "";
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            result = this.buttons[i].getText();
        }
        return result;
    }

    public String getTimeStamp() {
        return Long.toString(this.timeStamp);
    }

    public void getNextData() {
        if (this.readOutCounter < this.numberOfData) {
            ++this.readOutCounter;
        }
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            UTLikertScale.this.timeStamp = System.currentTimeMillis();
        }
    }
}

