/*
 * Decompiled with CFR 0.152.
 */
package scone.usertesttool;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import scone.usertesttool.AllComponents;
import scone.usertesttool.InputComponent;
import scone.usertesttool.UserTestControl;

public class UTSlider
extends Box
implements InputComponent,
AllComponents {
    private String compName = "";
    private JSlider jSlider;
    private int bottomPadding = 10;
    private ArrayList itemList = new ArrayList();
    private String description = "";
    private long timeStamp = 0L;
    private int majorTickSpacing = 0;
    private int minorTickSpacing = 0;
    private int minimum = 0;
    private int maximum = 100;
    private int defaultValue = 50;
    private boolean snapToTicks = false;
    private boolean paintLabels = false;
    private UserTestControl utc;
    private UTSlider thisInstance;
    private Box sliderBox;
    private Box paddingBox;
    int readOutCounter = 0;
    int numberOfData = 1;
    private boolean inputRequired = false;

    public UTSlider(UserTestControl utc) {
        this(utc, "", 1300);
    }

    public UTSlider(UserTestControl utc, String description) {
        this(utc, description, 1300);
    }

    public UTSlider(UserTestControl utc, String description, int width) {
        this(utc, description, width, true);
    }

    public UTSlider(UserTestControl utc, String description, int width, boolean enabled) {
        super(1);
        this.utc = utc;
        this.description = description;
        this.thisInstance = this;
        this.createSlider();
        this.setComponentEnabled(enabled);
    }

    public void createSlider() {
        this.removeAll();
        this.sliderBox = Box.createHorizontalBox();
        this.sliderBox.add(Box.createHorizontalGlue());
        this.jSlider = new JSlider();
        this.jSlider.addChangeListener(new MyChangeListener());
        this.jSlider.setEnabled(true);
        this.jSlider.setBorder(BorderFactory.createTitledBorder(this.description));
        this.jSlider.setMinimum(this.minimum);
        this.jSlider.setMaximum(this.maximum);
        this.jSlider.setValue(this.defaultValue);
        if (this.majorTickSpacing > 0) {
            this.jSlider.setMajorTickSpacing(this.majorTickSpacing);
            this.jSlider.setPaintTicks(true);
        }
        if (this.minorTickSpacing > 0) {
            this.jSlider.setMinorTickSpacing(this.minorTickSpacing);
            this.jSlider.setPaintTicks(true);
        }
        this.jSlider.setPaintLabels(this.paintLabels);
        this.jSlider.setSnapToTicks(this.snapToTicks);
        this.jSlider.setPreferredSize(new Dimension(400, 80));
        this.sliderBox.add(this.jSlider);
        this.sliderBox.add(Box.createHorizontalGlue());
        this.add(this.sliderBox);
        this.paddingBox = new Box(0);
        this.paddingBox.add(Box.createRigidArea(new Dimension(0, this.bottomPadding)));
        this.add(this.paddingBox);
    }

    public void setComponentEnabled(boolean enable) {
        this.setEnabled(enable);
        this.jSlider.setEnabled(enable);
        if (enable) {
            this.jSlider.requestFocus();
        } else {
            this.setComponentHighlighted(false);
        }
    }

    public void setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMajorTickSpacing(int majorTickSpacing) {
        this.majorTickSpacing = majorTickSpacing;
    }

    public void setMinorTickSpacing(int minorTickSpacing) {
        this.minorTickSpacing = minorTickSpacing;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public void setDefault(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public void setSnapToTicks(boolean snapToTicks) {
        this.snapToTicks = snapToTicks;
    }

    public void setPaintLabels(boolean paintLabels) {
        this.paintLabels = paintLabels;
    }

    public void componentRequestFocus() {
        this.jSlider.requestFocus();
    }

    public void setComponentHighlighted(boolean highlight) {
        if (highlight) {
            this.jSlider.setBackground(new Color(230, 230, 128));
        } else {
            this.jSlider.setBackground(new Color(204, 204, 204));
        }
    }

    public boolean changedByUser() {
        if (this.inputRequired && !((ComboItem)this.itemList.get(this.jSlider.getValue())).isSelectable()) {
            this.jSlider.requestFocus();
            return false;
        }
        return true;
    }

    public void setComponentName(String componentName) {
        this.compName = componentName;
    }

    public void setComponentBottomPadding(int padding) {
        this.bottomPadding = padding;
        this.removeAll();
        this.paddingBox = new Box(0);
        this.paddingBox.add(Box.createRigidArea(new Dimension(0, this.bottomPadding)));
        this.add(this.sliderBox);
        this.add(this.paddingBox);
    }

    public String getComponentName() {
        return this.compName;
    }

    public void startDataQuery() {
        this.readOutCounter = 0;
    }

    public boolean hasMoreData() {
        return this.readOutCounter < this.numberOfData;
    }

    public String getTagName() {
        return "sliderValue";
    }

    public String getData() {
        return Integer.toString(this.jSlider.getValue());
    }

    public String getTimeStamp() {
        return Long.toString(this.timeStamp);
    }

    public void getNextData() {
        if (this.readOutCounter < this.numberOfData) {
            ++this.readOutCounter;
        }
    }

    class ComboItem {
        private long value;
        private String text;
        private boolean selectable;

        public ComboItem(long value, String text, boolean selectable) {
            this.value = value;
            this.text = text;
            this.selectable = selectable;
        }

        public long getValue() {
            return this.value;
        }

        public boolean isSelectable() {
            return this.selectable;
        }
    }

    class MyChangeListener
    implements ChangeListener {
        MyChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            UTSlider.this.timeStamp = System.currentTimeMillis();
        }
    }
}

