/*
 * Decompiled with CFR 0.152.
 */
package scone.usertesttool;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import scone.usertesttool.AllComponents;
import scone.usertesttool.InputComponent;
import scone.usertesttool.UIStyle;
import scone.usertesttool.UserTestControl;

public class UTTextField
extends Box
implements InputComponent,
AllComponents {
    private String compName = "";
    private JLabel jLabel = null;
    private String description = "";
    private String textFieldText = "";
    private long timeStamp = 0L;
    private int bottomPadding = 10;
    private int height = 20;
    private JTextArea jTextArea;
    private JScrollPane scrollPane;
    private UserTestControl utc;
    private UTTextField thisInstance;
    private Box paddingBox;
    private Box hbox;
    private boolean inputRequired = false;
    private boolean componentEnable = true;
    int readOutCounter = 0;
    int numberOfData = 1;

    public UTTextField(UserTestControl utc) {
        super(1);
        this.utc = utc;
        this.thisInstance = this;
        this.jLabel = new JLabel(this.description + "           ");
        this.jLabel.setFont(UIStyle.PLAINFONT);
        this.jLabel.setForeground(Color.black);
        this.hbox = Box.createHorizontalBox();
        this.hbox.add(this.jLabel);
        this.hbox.add(Box.createHorizontalGlue());
        this.add(this.hbox);
        this.jTextArea = new JTextArea();
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(true);
        this.jTextArea.setEnabled(this.componentEnable);
        this.jTextArea.getDocument().addDocumentListener(new MyDocumentListener());
        this.scrollPane = new JScrollPane(this.jTextArea, 20, 31);
        this.scrollPane.setPreferredSize(new Dimension(1300, this.height));
        this.scrollPane.setMaximumSize(new Dimension(1300, this.height));
        this.setComponentEnabled(this.componentEnable);
        this.add(this.scrollPane);
        this.paddingBox = new Box(0);
        this.paddingBox.add(Box.createRigidArea(new Dimension(0, this.bottomPadding)));
        this.add(this.paddingBox);
    }

    public void setDescription(String description) {
        this.description = description;
        this.jLabel.setText(description);
    }

    public void setText(String text) {
        this.jTextArea.setText(text);
        this.textFieldText = text;
    }

    public void setHeight(int height) {
        this.height = height;
        this.removeAll();
        this.scrollPane = new JScrollPane(this.jTextArea, 20, 31);
        this.scrollPane.setPreferredSize(new Dimension(1300, height));
        this.scrollPane.setMaximumSize(new Dimension(1300, height));
        this.add(this.hbox);
        this.add(this.scrollPane);
        this.add(this.paddingBox);
    }

    public void setComponentEnabled(boolean enable) {
        this.componentEnable = enable;
        this.setEnabled(enable);
        this.jTextArea.setEnabled(enable);
        this.jLabel.setEnabled(enable);
        if (enable) {
            this.jTextArea.requestFocus();
            this.jTextArea.setBackground(new Color(255, 255, 255));
        } else {
            this.setComponentHighlighted(false);
            this.jTextArea.setBackground(new Color(204, 204, 204));
        }
    }

    public void setComponentHighlighted(boolean highlight) {
        if (this.componentEnable) {
            if (highlight) {
                this.jTextArea.setBackground(new Color(230, 230, 128));
            } else {
                this.jTextArea.setBackground(new Color(255, 255, 255));
            }
        }
    }

    public void componentRequestFocus() {
        this.jTextArea.requestFocus();
    }

    public void setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
    }

    public boolean changedByUser() {
        if (this.inputRequired && this.jTextArea.getText().equals(this.textFieldText)) {
            this.jTextArea.requestFocus();
            return false;
        }
        return true;
    }

    public void setComponentName(String componentName) {
        this.compName = componentName;
    }

    public void setComponentBottomPadding(int padding) {
        this.bottomPadding = padding;
        this.removeAll();
        this.paddingBox = new Box(0);
        this.paddingBox.add(Box.createRigidArea(new Dimension(0, this.bottomPadding)));
        this.add(this.hbox);
        this.add(this.scrollPane);
        this.add(this.paddingBox);
    }

    public String getComponentName() {
        return this.compName;
    }

    public void startDataQuery() {
        this.readOutCounter = 0;
    }

    public boolean hasMoreData() {
        return this.readOutCounter < this.numberOfData;
    }

    public String getTagName() {
        return "textFieldText";
    }

    public String getData() {
        return this.jTextArea.getText();
    }

    public String getTimeStamp() {
        return Long.toString(this.timeStamp);
    }

    public void getNextData() {
        if (this.readOutCounter < this.numberOfData) {
            ++this.readOutCounter;
        }
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            UTTextField.this.timeStamp = System.currentTimeMillis();
        }

        public void removeUpdate(DocumentEvent e) {
            UTTextField.this.timeStamp = System.currentTimeMillis();
        }

        public void changedUpdate(DocumentEvent e) {
            UTTextField.this.timeStamp = System.currentTimeMillis();
        }
    }
}

