/*
 * Decompiled with CFR 0.152.
 */
package scone.usertesttool;

import com.ibm.wbi.protocol.http.beans.FormHelper;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import scone.netobjects.Access;
import scone.usertesttool.Action;
import scone.usertesttool.AllComponents;
import scone.usertesttool.BrowserControl;
import scone.usertesttool.CurrentState;
import scone.usertesttool.InputComponent;
import scone.usertesttool.PersistentTestStateStore;
import scone.usertesttool.StopWatch;
import scone.usertesttool.Task;
import scone.usertesttool.TaskPanel;
import scone.usertesttool.TaskWindow;
import scone.usertesttool.UIStyle;
import scone.usertesttool.UTButton;
import scone.usertesttool.UTTextField;
import scone.usertesttool.UserTestTool;
import scone.util.ErrorLog;
import scone.util.PersistentProperties;

public class UserTestControl
extends Thread {
    protected static ResourceBundle labels = UserTestTool.labels;
    protected static PersistentProperties props = UserTestTool.props;
    private Document document;
    private Node userTestXml;
    private Task task;
    private String frameName;
    private TaskWindow tw = null;
    private BrowserControl browserControl = null;
    private CurrentState currentState = null;
    private HashMap testComponents = null;
    private boolean testRunning = false;
    public boolean outputDebugInfo = false;
    private String xmlPath;
    private String destPath;
    private File destDir;
    private File xmlDir;
    private PersistentTestStateStore ptss;
    private long accessTime = 0L;

    public void run() {
        this.tw = new TaskWindow(this);
        this.browserControl = new BrowserControl();
        this.ptss = PersistentTestStateStore.getInstance();
        if (props.get("Path for XML test descriptions") != null) {
            this.xmlPath = props.get("Path for XML test descriptions");
            this.xmlDir = new File(this.xmlPath);
            if (!this.xmlDir.isDirectory()) {
                JOptionPane.showMessageDialog(this.tw, "The directory:\n" + this.xmlDir.getAbsolutePath() + "\n with the user test XML files does not exist.\nPlease create a new directory for your tests and configure it with runscone -config\nfor the UserTestTool-Plugin", "Scone: UserTestTool", 0);
            } else {
                File[] fileArray = this.xmlDir.listFiles();
                if (fileArray == null || fileArray.length == 0) {
                    JOptionPane.showMessageDialog(this.tw, "The directory:\n" + this.xmlDir.getAbsolutePath() + "\n does not contain any valid XML user test files.\n Please create the according files\n or copy them to that directory. You may also choose another directory for the user test files usind runscone -config\n", "Scone: UserTestTool", 0);
                } else {
                    this.destPath = props.get("Output path for test results") != null ? props.get("Output path for test results") : "";
                    this.destDir = new File(this.destPath);
                    if (!this.destDir.isDirectory()) {
                        this.destDir.mkdirs();
                    }
                    this.ptss.setDirs(this.xmlPath, this.destPath);
                }
            }
        }
        if (props.get("Output debug information to text window") != null && props.get("Output debug information to text window").equals("true")) {
            this.outputDebugInfo = true;
        }
    }

    public Document parseXmlFile(String fileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(fileName));
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document;
    }

    public void pageCalled(String pageName) {
    }

    public void pageLoading(Access access) {
        if (this.accessTime != access.getTime()) {
            this.accessTime = access.getTime();
            if (access.getNode().toString().toLowerCase().equals("http://usertest.scone.de/") && !this.testRunning) {
                this.testRunning = true;
                this.testComponents = new HashMap();
                this.frameName = access.getParentFrameName() + access.getFrameName();
                this.tw.displayTask(this.createTestChooser(this.ptss, this));
                this.tw.setTitle(labels.getString("testselecttitle"));
                this.tw.setVisible(true);
            }
            if (!access.getNode().toString().toLowerCase().startsWith("http://usertest.scone.de/") && this.testRunning) {
                if ((access.getAction() & 1) > 0) {
                    this.currentState.addLinkEvent("click", access.getNode().toString(), access.getFrameName());
                } else if ((access.getAction() & 2) > 0) {
                    this.currentState.addLinkEvent("fragmentOnSamePage", access.getNode().toString(), access.getFrameName());
                } else if ((access.getAction() & 4) > 0) {
                    this.currentState.addLinkEvent("samePage", access.getNode().toString(), access.getFrameName());
                } else if ((access.getAction() & 8) > 0) {
                    String key;
                    this.currentState.addLinkEvent("formSubmit", access.getNode().toString(), access.getFrameName());
                    Properties p = FormHelper.interpretFormData((String)this.unEscape(access.getPost()));
                    Enumeration<Object> e = p.keys();
                    while (e.hasMoreElements()) {
                        key = (String)e.nextElement();
                        this.currentState.addFormData(key + "=" + p.get(key), access.getNode().toString(), access.getFrameName());
                    }
                    p = FormHelper.interpretFormData((String)access.getQuery());
                    e = p.keys();
                    while (e.hasMoreElements()) {
                        key = (String)e.nextElement();
                        this.currentState.addFormData(key + "=" + p.get(key), access.getNode().toString(), access.getFrameName());
                    }
                } else if ((access.getAction() & 0x10) > 0) {
                    this.currentState.addBrowserEvent("reload", access.getNode().toString(), access.getFrameName());
                } else if ((access.getAction() & 0x80) > 0 && (access.getAction() & 0x20) > 0) {
                    this.currentState.addBrowserEvent("backSeveralPages", access.getNode().toString(), access.getFrameName());
                } else if ((access.getAction() & 0x80) > 0 && (access.getAction() & 0x40) > 0) {
                    this.currentState.addBrowserEvent("nextSeveralPages", access.getNode().toString(), access.getFrameName());
                } else if ((access.getAction() & 0x20) > 0) {
                    this.currentState.addBrowserEvent("back", access.getNode().toString(), access.getFrameName());
                } else if ((access.getAction() & 0x40) > 0) {
                    this.currentState.addBrowserEvent("next", access.getNode().toString(), access.getFrameName());
                } else if ((access.getAction() & 0x8000) > 0) {
                    this.currentState.addBrowserEvent("newUrl", access.getNode().toString(), access.getFrameName());
                }
            }
        }
    }

    public String unEscape(String escaped) {
        String unescaped = "";
        for (int i = 0; i < escaped.length(); ++i) {
            if (escaped.charAt(i) == '%' && i + 2 < escaped.length()) {
                byte[] charValue = new byte[]{37};
                try {
                    charValue[0] = (byte)Integer.parseInt(escaped.substring(i + 1, i + 3), 16);
                    ++i;
                    ++i;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                unescaped = unescaped + new String(charValue, 0, 1);
                continue;
            }
            unescaped = unescaped + escaped.charAt(i);
        }
        return unescaped;
    }

    public void prepareFirstTask(String testPerson, String xmlFile, int testNumber) {
        this.document = this.parseXmlFile(xmlFile);
        NodeList nList = this.document.getChildNodes();
        int i = 0;
        boolean found = false;
        while (i < nList.getLength() && !found) {
            if (nList.item(i).getNodeName().equals("userTest")) {
                found = true;
                this.userTestXml = nList.item(i);
                continue;
            }
            ++i;
        }
        int numberOfTasks = this.document.getElementsByTagName("task").getLength();
        this.currentState = new CurrentState(testPerson, xmlFile, testNumber, numberOfTasks, this.ptss.getTestResultPath());
        this.currentState.setParentFrameAndFrameName(this.frameName);
        File file = new File(this.currentState.getResultFilename());
        this.ptss.addToUnfinishedTests(file.getName().substring(0, file.getName().length() - 4), numberOfTasks, 0);
        this.startNextTask();
    }

    public void startNextTask() {
        if (this.currentState.hasMoreTasks()) {
            this.currentState.startNextTask();
            this.task = new Task(this.userTestXml, this.currentState.getCurrentTask(), this);
            this.currentState.setTaskName(this.task.getTaskName());
            if (this.tw != null) {
                this.tw.setTitle(this.task.getTitle());
                this.tw.setVisible(true);
                this.tw.displayTask(this.task.getTaskPanel());
            }
        } else {
            this.browserControl.openUri(this.currentState.getParentFrameAndFrameName(), "http://usertest.scone.de/testended");
            File file = new File(this.currentState.getResultFilename());
            this.ptss.removeFromUnfinishedTests(file.getName().substring(0, file.getName().length() - 4));
            this.testRunning = false;
            this.tw.setVisible(false);
        }
    }

    public void restartTest(String resultFile, int taskNumber) {
        this.currentState = new CurrentState(resultFile, this.ptss.getTestResultPath(), taskNumber);
        this.currentState.setParentFrameAndFrameName(this.frameName);
        this.document = this.parseXmlFile(this.currentState.getXmlFilename());
        NodeList nList = this.document.getChildNodes();
        int i = 0;
        boolean found = false;
        while (i < nList.getLength() && !found) {
            if (nList.item(i).getNodeName().equals("userTest")) {
                found = true;
                this.userTestXml = nList.item(i);
                continue;
            }
            ++i;
        }
        this.task = new Task(this.userTestXml, this.currentState.getCurrentTask(), this);
        this.currentState.setTaskName(this.task.getTaskName());
        if (this.tw != null) {
            this.tw.setTitle(this.task.getTitle());
            this.tw.setVisible(true);
            this.tw.displayTask(this.task.getTaskPanel());
        }
    }

    public void pageUnloading(Access access) {
    }

    public void buttonClick(UTButton button) {
        this.currentState.addButtonClick(button.getName());
        this.performActions(button.getActionList());
    }

    public void textFieldReturn(UTTextField textField) {
    }

    public void performActions(ArrayList actionList) {
        Action action = null;
        for (int i = 0; i < actionList.size(); ++i) {
            action = (Action)actionList.get(i);
            String parameter = "";
            try {
                if (action.getCommand().equals("enable")) {
                    parameter = action.getParameter().trim();
                    ((AllComponents)this.getComponentByName(parameter)).setComponentEnabled(true);
                }
                if (action.getCommand().equals("disable")) {
                    parameter = action.getParameter().trim();
                    ((AllComponents)this.getComponentByName(parameter)).setComponentEnabled(false);
                }
                if (action.getCommand().equals("highlight")) {
                    parameter = action.getParameter().trim();
                    ((AllComponents)this.getComponentByName(parameter)).setComponentHighlighted(true);
                }
                if (action.getCommand().equals("unhighlight")) {
                    parameter = action.getParameter().trim();
                    ((AllComponents)this.getComponentByName(parameter)).setComponentHighlighted(false);
                }
                if (action.getCommand().equals("requestFocus")) {
                    parameter = action.getParameter().trim();
                    ((AllComponents)this.getComponentByName(parameter)).componentRequestFocus();
                }
            }
            catch (NullPointerException e) {
                System.out.println("");
                System.out.println("Scone: UserTestTool");
                System.out.println("");
                System.out.println("The XML file that defines the current user test has an error.");
                System.out.println("Component: \"" + parameter + "\", Command: \"" + action.getCommand() + "\"");
                System.out.println("This component does not exist.");
                System.out.println("");
            }
            catch (Exception e) {
                ErrorLog.log(this, "performActions", "Error while performing actions of a component\n", e);
            }
            if (action.getCommand().equals("openUri")) {
                parameter = action.getParameter().trim();
                if (parameter.toLowerCase().equals("_blank")) {
                    parameter = "http://usertest.scone.de/blank";
                }
                if (parameter.indexOf("://") < 0) {
                    parameter = "http://" + parameter;
                }
                this.currentState.addBrowserControlEvent("openUri", parameter, this.currentState.getParentFrameAndFrameName());
                this.browserControl.openUri(this.currentState.getParentFrameAndFrameName(), parameter);
            }
            if (action.getCommand().equals("javaScriptCommand")) {
                parameter = action.getParameter().trim();
                this.currentState.addBrowserControlEvent("javaScriptCommand", parameter, this.currentState.getParentFrameAndFrameName());
                this.browserControl.javaScriptCommand(this.currentState.getParentFrameAndFrameName(), parameter);
            }
            if (action.getCommand().equals("browserToFront")) {
                this.currentState.addBrowserControlEvent("browserToFront", "", this.currentState.getParentFrameAndFrameName());
                this.browserControl.bringToFront(this.currentState.getParentFrameAndFrameName());
            }
            if (action.getCommand().equals("browserResize")) {
                parameter = action.getParameter().trim();
                int width = 640;
                int height = 480;
                try {
                    width = Integer.parseInt(parameter.substring(0, parameter.indexOf("x")));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    height = Integer.parseInt(parameter.substring(parameter.indexOf("x") + 1, parameter.length()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.currentState.addBrowserControlEvent("browserResize", parameter, this.currentState.getParentFrameAndFrameName());
                this.browserControl.resize(this.currentState.getParentFrameAndFrameName(), width, height);
            }
            if (action.getCommand().equals("moveBrowserWindow")) {
                parameter = action.getParameter().trim();
                int x = 0;
                int y = 0;
                try {
                    x = Integer.parseInt(parameter.substring(0, parameter.indexOf("x")));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    y = Integer.parseInt(parameter.substring(parameter.indexOf("x") + 1, parameter.length()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.currentState.addBrowserControlEvent("moveBrowserWindow", parameter, this.currentState.getParentFrameAndFrameName());
                this.browserControl.moveBrowserWindow(this.currentState.getParentFrameAndFrameName(), x, y);
            }
            if (action.getCommand().equals("startNextTask")) {
                int j;
                Object comp = null;
                String compName = null;
                ArrayList compList = this.task.getComponents();
                boolean userUsedRequiredComponents = true;
                for (j = 0; j < compList.size(); ++j) {
                    comp = compList.get(j);
                    compName = ((AllComponents)comp).getComponentName();
                    if (!this.isInputComponent(comp) || ((InputComponent)comp).changedByUser()) continue;
                    userUsedRequiredComponents = false;
                    JOptionPane.showMessageDialog(this.tw, labels.getString("enterallfields"), "Scone: UserTestTool", -1);
                }
                if (userUsedRequiredComponents) {
                    for (j = 0; j < compList.size(); ++j) {
                        comp = compList.get(j);
                        compName = ((AllComponents)comp).getComponentName();
                        if (!this.isInputComponent(comp)) continue;
                        ((InputComponent)comp).startDataQuery();
                        while (((InputComponent)comp).hasMoreData()) {
                            String tagname = ((InputComponent)comp).getTagName();
                            String actionData = ((InputComponent)comp).getData();
                            String timeStamp = ((InputComponent)comp).getTimeStamp();
                            this.currentState.addData(tagname, actionData, compName, timeStamp);
                            ((InputComponent)comp).getNextData();
                        }
                    }
                    this.currentState.endTask();
                    this.currentState.writeXmlResults();
                    this.currentState.writeTabDevidedResults();
                    File file = new File(this.currentState.getResultFilename());
                    this.ptss.addToUnfinishedTests(file.getName().substring(0, file.getName().length() - 4), this.currentState.getNumberOfTasks(), this.currentState.getCompletedTasks());
                    this.startNextTask();
                }
                return;
            }
            if (action.getCommand().equals("cancelTest")) {
                this.cancelTest();
            }
            if (action.getCommand().equals("stopWatchStart")) {
                parameter = action.getParameter().trim();
                this.testComponents.put(parameter, new StopWatch());
            }
            if (action.getCommand().equals("stopWatchElapsed") && this.testComponents.get(parameter = action.getParameter().trim()) != null) {
                this.currentState.addStopWatch("elapsedTime", parameter, ((StopWatch)this.testComponents.get(parameter)).getElapsedTime());
            }
            if (!action.getCommand().equals("stopWatchLapTime") || this.testComponents.get(parameter = action.getParameter().trim()) == null) continue;
            this.currentState.addStopWatch("lapTime", parameter, ((StopWatch)this.testComponents.get(parameter)).getLapTime());
        }
    }

    protected boolean isInputComponent(Object comp) {
        Class<?>[] classes = comp.getClass().getInterfaces();
        for (int y = 0; y < classes.length; ++y) {
            if (!classes[y].getName().equals("scone.usertesttool.InputComponent")) continue;
            return true;
        }
        return false;
    }

    protected Object getComponentByName(String compName) {
        ArrayList comps = this.task.getComponents();
        for (int i = 0; i < comps.size(); ++i) {
            if (!((AllComponents)comps.get(i)).getComponentName().equals(compName)) continue;
            return comps.get(i);
        }
        return null;
    }

    public void cancelTest() {
        if (this.currentState != null) {
            this.browserControl.openUri(this.currentState.getParentFrameAndFrameName(), "http://usertest.scone.de/testcanceled");
        }
        this.testRunning = false;
        this.tw.setVisible(false);
    }

    public TaskPanel createTestChooser(PersistentTestStateStore ptss, UserTestControl utc) {
        final UserTestControl _utc = utc;
        final PersistentTestStateStore _ptss = ptss;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        final TaskPanel panel = new TaskPanel();
        panel.setLayout(gridbag);
        c.insets = new Insets(2, 5, 2, 5);
        JLabel label = new JLabel("Scone User Test Tool");
        label.setFont(UIStyle.VERYBIGBOLDFONT);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.ipady = 40;
        c.anchor = 10;
        c.fill = 0;
        gridbag.setConstraints(label, c);
        panel.add(label);
        label = new JLabel(labels.getString("newtest"));
        label.setFont(UIStyle.BIGBOLDFONT);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.ipady = 40;
        c.anchor = 17;
        gridbag.setConstraints(label, c);
        panel.add(label);
        label = new JLabel(labels.getString("testdescription"));
        label.setFont(UIStyle.PLAINFONT);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.ipady = 0;
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(label, c);
        panel.add(label);
        final JComboBox<String> descriptionList = new JComboBox<String>(_ptss.getTestDescriptions());
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.ipady = 0;
        c.fill = 2;
        gridbag.setConstraints(descriptionList, c);
        panel.add(descriptionList);
        label = new JLabel(labels.getString("testno"));
        label.setFont(UIStyle.PLAINFONT);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.ipady = 0;
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(label, c);
        panel.add(label);
        final JTextField testNumber = new JTextField(Integer.toString(_ptss.getLastTestNumberFor((String)descriptionList.getSelectedItem()) + 1));
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.ipady = 0;
        c.fill = 2;
        gridbag.setConstraints(testNumber, c);
        panel.add(testNumber);
        descriptionList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                testNumber.setText(Integer.toString(_ptss.getLastTestNumberFor((String)cb.getSelectedItem()) + 1));
            }
        });
        label = new JLabel(labels.getString("participantname"));
        label.setFont(UIStyle.PLAINFONT);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.ipady = 0;
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(label, c);
        panel.add(label);
        final JTextField testPerson = new JTextField();
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.ipady = 0;
        c.fill = 2;
        gridbag.setConstraints(testPerson, c);
        panel.add(testPerson);
        JButton button = new JButton(labels.getString("startnewtest"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int numberOfTest = 0;
                boolean isNumber = true;
                testPerson.setText(testPerson.getText().trim());
                try {
                    numberOfTest = Integer.parseInt(testNumber.getText());
                }
                catch (NumberFormatException e) {
                    isNumber = false;
                }
                if (testPerson.getText().equals("")) {
                    JOptionPane.showMessageDialog(panel, labels.getString("entername"), "Scone: UserTestTool", -1);
                    testPerson.requestFocus();
                } else if (!isNumber) {
                    JOptionPane.showMessageDialog(panel, labels.getString("numbererror"), "Scone: UserTestTool", -1);
                    testNumber.requestFocus();
                } else {
                    File file;
                    String filename = _ptss.getTestResultPath() + (String)descriptionList.getSelectedItem() + ".";
                    if (numberOfTest < 1000) {
                        filename = filename + "0";
                    }
                    if (numberOfTest < 100) {
                        filename = filename + "0";
                    }
                    if (numberOfTest < 10) {
                        filename = filename + "0";
                    }
                    if ((file = new File(filename = filename + Integer.toString(numberOfTest) + "." + testPerson.getText() + ".xml")).exists()) {
                        String backupEnding = ".001";
                        int endNum = 1;
                        File renamedFile = new File(filename + backupEnding);
                        while (renamedFile.exists() && endNum < 1000) {
                            if (++endNum < 10) {
                                backupEnding = ".00" + Integer.toString(endNum);
                            } else if (endNum < 100) {
                                backupEnding = backupEnding + ".0" + Integer.toString(endNum);
                            }
                            renamedFile = new File(filename + backupEnding);
                        }
                        Object[] options = new Object[]{labels.getString("renamecontinue"), labels.getString("alterentry")};
                        int n = JOptionPane.showOptionDialog(panel, labels.getString("outputfileexists1") + "\n" + "\n" + filename + labels.getString("outputfileexists2") + "\n" + "\n" + filename + backupEnding + labels.getString("outputfileexists3") + "\n" + labels.getString("outputfileexists4"), "Scone: UserTestTool", 0, 3, null, options, options[0]);
                        if (n == 0) {
                            file.renameTo(renamedFile);
                            if (_ptss.getLastTestNumberFor((String)descriptionList.getSelectedItem()) < numberOfTest) {
                                _ptss.setLastTestNumberFor((String)descriptionList.getSelectedItem(), numberOfTest);
                            }
                            _utc.prepareFirstTask(testPerson.getText(), _ptss.getTestDescriptionPath() + (String)descriptionList.getSelectedItem() + ".xml", numberOfTest);
                        }
                    } else {
                        if (_ptss.getLastTestNumberFor((String)descriptionList.getSelectedItem()) < numberOfTest) {
                            _ptss.setLastTestNumberFor((String)descriptionList.getSelectedItem(), numberOfTest);
                        }
                        _utc.prepareFirstTask(testPerson.getText(), _ptss.getTestDescriptionPath() + (String)descriptionList.getSelectedItem() + ".xml", numberOfTest);
                    }
                }
            }
        });
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.ipady = 0;
        c.anchor = 13;
        c.fill = 0;
        gridbag.setConstraints(button, c);
        panel.add(button);
        label = new JLabel(labels.getString("continueaborted"));
        label.setFont(UIStyle.BIGBOLDFONT);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.ipady = 40;
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(label, c);
        panel.add(label);
        String[] unfinished = ptss.getUnfinishedTests();
        for (int i = 0; i < unfinished.length; ++i) {
            int n = i;
            unfinished[n] = unfinished[n] + " (" + ptss.getCompletedTasksFromUnfinishedTest(unfinished[i]) + " " + labels.getString("of") + ptss.getNumberOfTasksFromUnfinishedTest(unfinished[i]) + labels.getString("taskssolved") + ")";
        }
        final JComboBox<String> comboBox = new JComboBox<String>(unfinished);
        if (unfinished.length == 0) {
            comboBox.addItem(labels.getString("nocancelled"));
        }
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 2;
        c.ipady = 0;
        c.fill = 2;
        gridbag.setConstraints(comboBox, c);
        panel.add(comboBox);
        label = new JLabel(labels.getString("starttask"));
        label.setFont(UIStyle.PLAINFONT);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        c.ipady = 0;
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(label, c);
        panel.add(label);
        final JComboBox<Object> taskNames = new JComboBox<Object>();
        if (unfinished.length > 0) {
            taskNames.removeAllItems();
            Object[] nameArray = _ptss.getTaskNamesForResumableTest(0);
            for (int i = 0; i < nameArray.length; ++i) {
                taskNames.addItem(nameArray[i]);
            }
        }
        c.gridx = 1;
        c.gridy = 8;
        c.gridwidth = 1;
        c.ipady = 0;
        c.fill = 2;
        gridbag.setConstraints(taskNames, c);
        panel.add(taskNames);
        if (unfinished.length > 0) {
            comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox cb = (JComboBox)e.getSource();
                    taskNames.removeAllItems();
                    Object[] nameArray = _ptss.getTaskNamesForResumableTest(cb.getSelectedIndex());
                    for (int i = 0; i < nameArray.length; ++i) {
                        taskNames.addItem(nameArray[i]);
                    }
                }
            });
        }
        button = new JButton(labels.getString("continuetest"));
        if (unfinished.length > 0) {
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int iTaskNumber = 0;
                    boolean isNumber = false;
                    try {
                        iTaskNumber = taskNames.getSelectedIndex() + 1;
                        isNumber = true;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (!isNumber) {
                        JOptionPane.showMessageDialog(panel, labels.getString("enterwholeno"), "Scone: UserTestTool", -1);
                        taskNames.requestFocus();
                    } else if (iTaskNumber > _ptss.getCompletedTasksFromUnfinishedTest(comboBox.getSelectedIndex()) + 1 || iTaskNumber < 1) {
                        JOptionPane.showMessageDialog(panel, labels.getString("enter1toN1") + " " + _ptss.getCompletedTasksFromUnfinishedTest(comboBox.getSelectedIndex() + 1) + " " + labels.getString("enter1toN2"), "Scone: UserTestTool", -1);
                        taskNames.requestFocus();
                    } else {
                        _utc.restartTest(_ptss.getTestResultPath() + _ptss.getUnfinishedTests()[comboBox.getSelectedIndex()] + ".xml", iTaskNumber);
                    }
                }
            });
        }
        c.gridx = 1;
        c.gridy = 9;
        c.gridwidth = 1;
        c.ipady = 0;
        c.anchor = 13;
        c.fill = 0;
        gridbag.setConstraints(button, c);
        panel.add(button);
        return panel;
    }

    private String getText(Node node) {
        String textString = "";
        NodeList nList = node.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            if (nList.item(i).getNodeType() != 3) continue;
            textString = textString + nList.item(i).getNodeValue();
        }
        return textString;
    }

    private String getAttribByName(String attrName, Node node) {
        NamedNodeMap nMap = node.getAttributes();
        String result = "";
        for (int i = 0; i < nMap.getLength(); ++i) {
            if (!nMap.item(i).getNodeName().toLowerCase().equals(attrName.toLowerCase())) continue;
            result = this.getText(nMap.item(i));
        }
        return result;
    }

    public TaskWindow getTaskWindow() {
        return this.tw;
    }
}

