/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AlertBox
extends JDialog
implements ActionListener {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final String SPACE = "  ";
    private JButton okButton;
    private JPanel textPanel;
    private JPanel buttonPanel;

    public AlertBox(JFrame f, String[] message) {
        this(f, "Attention!", true, message);
    }

    public AlertBox(JFrame f, String title, boolean modal, String[] message) {
        this(f, title, modal, message, 1);
    }

    public AlertBox(JFrame f, String title, boolean modal, String[] message, int alignment) {
        super(f, title, modal);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.setBackground(Color.lightGray);
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new GridLayout(0, 1));
        int alignmentValue = alignment == 0 ? 2 : 0;
        for (int i = 0; i < message.length; ++i) {
            JLabel l = new JLabel(SPACE + message[i] + SPACE, alignmentValue);
            l.setFont(new Font("Serif", 1, 13));
            this.textPanel.add(l);
        }
        this.okButton = new JButton("  OK  ");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.okButton);
        cp.add("Center", this.textPanel);
        cp.add("South", this.buttonPanel);
        this.pack();
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 100);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

