/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import java.io.IOException;
import java.io.InterruptedIOException;

public class BrowserControl {
    public static void displayURL(String url) throws IOException {
        if (BrowserControl.isWindows()) {
            if (url.endsWith(".html") || url.endsWith(".htm")) {
                char lastChar = url.charAt(url.length() - 1);
                url = url.substring(0, url.length() - 1) + "%" + Integer.toHexString(lastChar);
            }
            String cmd = "rundll32 url.dll,FileProtocolHandler " + url;
            Process p = Runtime.getRuntime().exec(cmd);
        } else if (BrowserControl.isMacOS()) {
            String[] commandLine = new String[]{"netscape", url};
            Process process = Runtime.getRuntime().exec(commandLine);
        } else {
            String cmd = "netscape -remote openURL(" + url + ")";
            Process p = Runtime.getRuntime().exec(cmd);
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    cmd = "netscape " + url;
                    p = Runtime.getRuntime().exec(cmd);
                }
            }
            catch (InterruptedException x) {
                System.err.println("Error bringing up browser, cmd='" + cmd + "'");
                System.err.println("Caught: " + x);
                throw new InterruptedIOException(x.getMessage());
            }
        }
    }

    public static void ClearIEHistory() throws IOException {
        if (BrowserControl.isWindows()) {
            String cmd = "resources\\scone\\ClearIEHistory.exe";
            Process process = Runtime.getRuntime().exec(cmd);
        }
    }

    public static void ClearIECache() throws IOException {
        if (BrowserControl.isWindows()) {
            String cmd = "resources\\scone\\ClearIECache.exe";
            Process process = Runtime.getRuntime().exec(cmd);
        }
    }

    public static void StartIE(String url) throws IOException {
        if (BrowserControl.isWindows()) {
            String cmd = "resources\\scone\\StartIE.exe " + url;
            Process process = Runtime.getRuntime().exec(cmd);
        }
    }

    public static void displayMailer(String address) throws IOException {
        BrowserControl.displayURL("mailto:" + address);
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    public static boolean isMacOS() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Mac");
    }
}

