/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import scone.util.PersistentProperties;
import scone.util.PersistentPropertiesGui;
import scone.util.PluginEditDialog;
import scone.util.PluginListCellRenderer;
import scone.util.PluginRepository;
import scone.util.PluginRepositoryEntry;
import scone.util.RegisterDialog;

public class ConfigGui
extends JFrame {
    static final String fileName = "config/scone/plugins.xml";
    PluginRepository plugins = null;
    JList pluginList = null;
    DefaultListModel pluginListModel = null;
    PluginEditDialog dialog = null;
    RegisterDialog regDialog = null;

    public ConfigGui(PluginRepository plugins) {
        super("Configure Scone Properties");
        ImageIcon img = new ImageIcon("resources/scone/scone64.gif");
        this.setIconImage(img.getImage());
        this.plugins = plugins;
        this.createGui();
        this.dialog = new PluginEditDialog(this, "Configure Plugin", true);
        this.regDialog = new RegisterDialog(this, "Register New Plugin", true);
        this.addWindowListener(new SconeConfigWindowAdapter(this));
    }

    public void createGui() {
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.setBackground(Color.lightGray);
        this.pluginListModel = new DefaultListModel();
        this.pluginList = new JList(this.pluginListModel);
        this.pluginList.setBackground(new Color(232, 232, 232));
        Font displayFont = new Font("SansSerif", 1, 12);
        this.pluginList.setFont(displayFont);
        this.pluginList.setCellRenderer(new PluginListCellRenderer(this.plugins));
        Enumeration en = this.plugins.getEntries();
        while (en.hasMoreElements()) {
            PluginRepositoryEntry entry = (PluginRepositoryEntry)en.nextElement();
            String name = entry.getName();
            this.pluginListModel.addElement(name);
        }
        JScrollPane pluginListPane = new JScrollPane(this.pluginList);
        cp.add((Component)pluginListPane, "Center");
        this.pluginList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && ConfigGui.this.pluginList.getSelectedIndex() >= 0) {
                    PluginRepositoryEntry entry = ConfigGui.this.plugins.getEntryByNumber(ConfigGui.this.pluginList.getSelectedIndex());
                    ConfigGui.this.dialog.editPlugin(entry, ConfigGui.this.pluginListModel, ConfigGui.this.pluginList.getSelectedIndex());
                    ConfigGui.this.pluginList.clearSelection();
                }
            }
        });
        JPanel buttonContainer = new JPanel();
        buttonContainer.setLayout(new GridLayout(2, 3, 5, 5));
        JButton db = new JButton("Database");
        buttonContainer.add(db);
        db.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PersistentPropertiesGui((Frame)ConfigGui.this, new PersistentProperties("config/scone/db.xml"));
            }
        });
        JButton userTracking = new JButton("Access Tracking");
        buttonContainer.add(userTracking);
        userTracking.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PersistentPropertiesGui((Frame)ConfigGui.this, new PersistentProperties("config/scone/accesstracking.xml"));
            }
        });
        JButton robot = new JButton("Robot");
        buttonContainer.add(robot);
        robot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PersistentPropertiesGui((Frame)ConfigGui.this, new PersistentProperties("config/scone/robot.xml"));
            }
        });
        JButton register = new JButton("Register Plugin");
        buttonContainer.add(register);
        register.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ConfigGui.this.regDialog.show();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        ImageIcon cancelIcon = new ImageIcon("resources/scone/cancel.gif");
        JButton cancel = new JButton("      Cancel   ", cancelIcon);
        buttonContainer.add(cancel);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        ImageIcon exitIcon = new ImageIcon("resources/scone/exit.gif");
        JButton exit = new JButton("  Exit & Save", exitIcon);
        buttonContainer.add(exit);
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ConfigGui.this.plugins.store();
                    System.exit(0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        cp.add("South", buttonContainer);
        this.getRootPane().setDefaultButton(exit);
        this.setSize(480, 400);
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getHeight() / 2);
        this.setVisible(true);
        this.toFront();
    }

    public void register(String name) {
        PluginRepositoryEntry entry = this.plugins.register(name);
        if (entry != null) {
            this.pluginListModel.addElement(name);
        }
    }

    class SconeConfigWindowAdapter
    extends WindowAdapter {
        protected ConfigGui configFrame;

        public SconeConfigWindowAdapter(ConfigGui configFrame) {
            this.configFrame = configFrame;
        }

        public void windowClosing(WindowEvent e) {
            this.configFrame.dispose();
        }

        public void windowClosed(WindowEvent e) {
            try {
                this.configFrame.plugins.store();
                System.exit(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

