/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import com.google.soap.search.GoogleSearch;
import com.google.soap.search.GoogleSearchFault;
import com.google.soap.search.GoogleSearchResult;
import com.google.soap.search.GoogleSearchResultElement;
import java.util.Vector;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.util.ErrorLog;

public class Google {
    String key;

    public Google(String key) {
        this.key = key;
    }

    Vector getInfo(GoogleSearchResultElement[] results) {
        Vector<HtmlNode> nodes = new Vector<HtmlNode>();
        NetNode node = null;
        HtmlNode hNode = null;
        Object s = null;
        for (int i = 0; i < results.length; ++i) {
            try {
                node = NetNodeCache.get(results[i].getURL());
                hNode = HtmlNodeCache.check(node);
                if (hNode == null) {
                    hNode = HtmlNodeCache.get(node);
                    hNode.setBodyText(results[i].getSnippet());
                    hNode.setTitle(results[i].getTitle());
                }
                nodes.add(hNode);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return nodes;
    }

    public Vector getBackLinks(String url, int max) throws Exception {
        GoogleSearch search = new GoogleSearch();
        search.setKey(this.key);
        search.setQueryString("link:" + url);
        search.setMaxResults(max);
        return this.getInfo(search.doSearch().getResultElements());
    }

    public Vector getRelated(String url, int max) {
        GoogleSearch search = new GoogleSearch();
        try {
            search.setKey(this.key);
            search.setQueryString("related:" + url);
            search.setMaxResults(max);
            GoogleSearchResult results = search.doSearch();
            GoogleSearchResultElement[] resultElements = results.getResultElements();
            return this.getInfo(resultElements);
        }
        catch (GoogleSearchFault f) {
            System.out.println("scone.util.Google: Call to the Google Web APIs failed:");
            System.out.println(f.toString());
            ErrorLog.log(this, "scone.util.Google.getRelated()", "Call to Web API failed", (Exception)((Object)f));
            return null;
        }
    }
}

