/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LanguageAnalyzer {
    private Vector keys = new Vector();
    private Vector languages = new Vector();
    private IntHashtable keyCount = new IntHashtable();
    private IntHashtable langCount = new IntHashtable();
    private int maxLength = 0;

    public LanguageAnalyzer() {
        this.putLang("en", "the");
        this.putLang("en", "a");
        this.putLang("en", "and");
        this.putLang("en", "to");
        this.putLang("en", "I");
        this.putLang("en", "in");
        this.putLang("en", "is");
        this.putLang("en", "on");
        this.putLang("en", "you");
        this.putLang("en", "it");
        this.putLang("en", "of");
        this.putLang("en", "said");
        this.putLang("en", "can");
        this.putLang("en", "for");
        this.putLang("en", "my");
        this.putLang("en", "but");
        this.putLang("en", "all");
        this.putLang("en", "we");
        this.putLang("en", "are");
        this.putLang("en", "up");
        this.putLang("de", "ich");
        this.putLang("de", "er");
        this.putLang("de", "sie");
        this.putLang("de", "es");
        this.putLang("de", "der");
        this.putLang("de", "die");
        this.putLang("de", "das");
        this.putLang("de", "ein");
        this.putLang("de", "eine");
        this.putLang("de", "dieser");
        this.putLang("de", "haben");
        this.putLang("de", "hat");
        this.putLang("de", "sein");
        this.putLang("de", "sind");
        this.putLang("de", "ist");
        this.putLang("de", "werden");
        this.putLang("de", "wird");
        this.putLang("de", "eins");
        this.putLang("de", "zwei");
        this.putLang("de", "drei");
        this.putLang("de", "bis");
        this.putLang("de", "aber");
        this.putLang("de", "denn");
        this.putLang("de", "und");
        this.putLang("es", "la");
        this.putLang("es", "el");
        this.putLang("es", "un");
        this.putLang("es", "una");
        this.putLang("es", "y");
        this.putLang("es", "bien");
        this.putLang("es", "bueno");
        this.putLang("es", "con");
        this.putLang("es", "de");
        this.putLang("es", "del");
        this.putLang("es", "dos");
        this.putLang("es", "ella");
        this.putLang("es", "en");
        this.putLang("es", "esto");
        this.putLang("es", "hasta");
        this.putLang("es", "hoja");
        this.putLang("es", "mi");
        this.putLang("es", "mucho");
        this.putLang("es", "muy");
        this.putLang("es", "nada");
        this.putLang("es", "nuestro");
        this.putLang("es", "pues");
        this.putLang("es", "solo");
        this.putLang("es", "su");
        this.putLang("es", "vamos");
        this.putLang("es", "ver");
        this.putLang("es", "yo");
        this.putLang("fr", "la");
        this.putLang("fr", "le");
        this.putLang("fr", "un");
        this.putLang("fr", "une");
        this.putLang("fr", "\u00e0");
        this.putLang("fr", "on");
        this.putLang("fr", "bien");
        this.putLang("fr", "fort");
        this.putLang("fr", "le");
        this.putLang("fr", "les");
        this.putLang("fr", "faire");
        this.putLang("fr", "fait");
        this.putLang("fr", "prendre");
        this.putLang("fr", "prend");
        this.putLang("fr", "en");
        this.putLang("fr", "pas");
        this.putLang("fr", "je");
        this.putLang("fr", "tu");
        this.putLang("fr", "elle");
        this.putLang("fr", "il");
        this.putLang("fr", "soit");
        this.putLang("fr", "ca");
        this.putLang("fr", "est");
        this.putLang("fr", "elle");
        this.putLang("fr", "que");
    }

    public static void main(String[] args) {
        LanguageAnalyzer la = new LanguageAnalyzer();
        la.countWord("the");
        la.countWord("tarzen");
        la.countWord("hier");
        la.countWord("der");
        la.countWord("el");
        la.countWord("wolkenkratzer");
        la.countWord("is");
        la.countWord("aber");
        System.out.println(la.getLanguage());
    }

    public void putLang(String lang, String key) {
        key = " " + key.toLowerCase() + " ";
        int length = key.length();
        this.keys.addElement(key);
        this.languages.addElement(lang);
        this.keyCount.put(key, 0);
        this.langCount.put(lang, 0);
        if (this.maxLength < length) {
            this.maxLength = length;
        }
    }

    public void countWord(String word) {
        if (word.length() <= this.maxLength) {
            this.keyCount.inc(word.toLowerCase());
        }
    }

    public String getLanguage() {
        int i = 0;
        Object max = null;
        Object helperObj = null;
        for (int j = 0; j < this.keys.size(); ++j) {
            this.langCount.add(this.languages.elementAt(j), this.keyCount.getInt(this.keys.elementAt(j)));
        }
        Enumeration e = this.langCount.keys();
        while (e.hasMoreElements()) {
            helperObj = e.nextElement();
            int helper = this.langCount.getInt(helperObj);
            if (helper <= i || helper <= 5) continue;
            i = helper;
            max = helperObj;
        }
        if (max != null) {
            return max;
        }
        return "";
    }

    class IntHashtable
    extends Hashtable {
        IntHashtable() {
        }

        public int getInt(Object key) {
            if (this.get(key) != null) {
                return (Integer)this.get(key);
            }
            return 0;
        }

        public void inc(Object key) {
            this.add(key, 1);
        }

        public void put(Object key, int value) {
            this.put(key, new Integer(value));
        }

        public void add(Object key, int i) {
            if (this.get(key) != null) {
                this.put(key, this.getInt(key) + i);
            } else {
                this.put(key, i);
            }
        }
    }
}

