/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import scone.util.ErrorLog;

public class POCreator {
    String name;
    String tableName;
    Vector colNames;
    Hashtable colTypes;
    Hashtable colDefaults;
    Hashtable keyTypes;
    Hashtable refTables;
    Hashtable refCols;
    Hashtable colComments;
    boolean hasGeneratedKey = false;
    String genKeyName = "";
    static Vector NUMBERS = new Vector();
    static Vector STRINGS = new Vector();
    static Vector BLOBS = new Vector();
    static Vector DATES = new Vector();

    public static void main(String[] args) {
        POCreator POC = new POCreator(args[0]);
        POC.parseSqlSource();
        POC.transTypes();
        POC.printMe();
        POC.createTableRecordSource();
        POC.createCacheSource();
    }

    public void createCacheSource() {
        try {
            String r;
            String col;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.name + "Cache.java")));
            out.print("package scone.netobjects;\n\nimport scone.util.*;\nimport java.util.*;\n\n/**\n * caches the " + this.name + " objects\n" + " */\n\n" + "public class " + this.name + "Cache extends Observable implements TableRecordCacheInterface{\n\n" + "   protected static CacheTable cache;\n\n" + "   public static Object lock=new Object();\n\n" + "   protected static " + this.name + "Cache observable;\n\n" + "   public static void init(int timeTillCleanUp,int gcType){\n" + "      cache = new CacheTable(");
            if (this.hasGeneratedKey) {
                out.print("2");
            } else {
                out.print("1");
            }
            out.print(",timeTillCleanUp,gcType);\n      lock=new Object();\n   }\n\n");
            out.print("   /**\n");
            out.print("    * returns the " + this.name + " with the specified keys\n");
            out.print("    * This method will create such an object it it does not exist.\n");
            Enumeration e = this.colNames.elements();
            while (e.hasMoreElements()) {
                String col2 = (String)e.nextElement();
                if (!((String)this.keyTypes.get(col2)).equals("KEY")) continue;
                out.println("    * @param " + col2 + " " + this.colComments.get(col2));
            }
            out.print("    */\n");
            out.print("   public static " + this.name + " get(");
            boolean dummy = false;
            Enumeration e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print(", ");
                }
                if (this.refTables.get(col) != null) {
                    r = (String)this.refTables.get(col);
                    out.print(r + " " + col);
                } else {
                    out.print("String " + col);
                }
                dummy = true;
            }
            out.print("){\n      String key=getHashKey(");
            dummy = false;
            e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print(", ");
                }
                dummy = true;
                out.print(col);
            }
            out.print(");\n      " + this.name + " check=null;\n" + "      synchronized(lock){\n" + "         check=(" + this.name + ")cache.get(0,key);\n" + "         if(check==null){\n" + "            check=new " + this.name + "(");
            dummy = false;
            e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print(", ");
                }
                dummy = true;
                out.print(col);
            }
            out.print(");\n            cache.put(check);\n         }\n      }\n      return check;\n   }\n\n");
            out.print("   /**\n");
            out.print("    * returns the " + this.name + " with the specified keys if it exists, otherwise null\n");
            e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                out.println("    * @param " + col + " " + this.colComments.get(col));
            }
            out.print("    */\n");
            out.print("   public static " + this.name + " check(");
            dummy = false;
            e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print(", ");
                }
                if (this.refTables.get(col) != null) {
                    r = (String)this.refTables.get(col);
                    out.print(r + " " + col);
                } else {
                    out.print("String " + col);
                }
                dummy = true;
            }
            out.print("){\n      String key=getHashKey(");
            dummy = false;
            e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print(", ");
                }
                dummy = true;
                out.print(col);
            }
            out.print(");\n      " + this.name + " check=null;\n" + "      synchronized(lock){\n" + "         check=(" + this.name + ")cache.get(0,key);\n" + "         if(check==null){\n" + "            check=" + this.name + ".check(");
            dummy = false;
            e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print(", ");
                }
                dummy = true;
                out.print(col);
            }
            out.print(");\n            if(check!=null) cache.put(check);\n         }\n      }\n      return check;\n   }\n\n");
            if (this.hasGeneratedKey) {
                out.print("   /**\n");
                out.print("    * returns the " + this.name + " with the specified key if it exists, null otherwise\n");
                out.print("    * @param " + this.genKeyName + " " + this.colComments.get(this.genKeyName) + ";\n");
                out.print("    */\n");
                out.print("   public static " + this.name + " checkById(String " + this.genKeyName + "){\n" + "      String key=" + this.genKeyName + ";\n" + "      " + this.name + " check=null;\n" + "      synchronized(lock){\n" + "         check=(" + this.name + ")cache.get(1,key);\n" + "         if(check==null){\n" + "            check=" + this.name + ".checkById(" + this.genKeyName + ");\n" + "            if(check!=null) cache.put(check);\n" + "         }\n" + "      }\n" + "      return check;\n" + "   }\n\n");
            }
            out.print("   /**\n");
            out.print("    * returns a hashkey\n");
            e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                out.println("    * @param " + col + " " + this.colComments.get(col));
            }
            out.print("    * @return the hashkey\n");
            out.print("    */\n");
            out.print("   public static String getHashKey(");
            dummy = false;
            e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print(", ");
                }
                if (this.refTables.get(col) != null) {
                    r = (String)this.refTables.get(col);
                    out.print(r + " " + col);
                } else {
                    out.print("String " + col);
                }
                dummy = true;
            }
            out.print("){\n      return ");
            dummy = false;
            e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                col = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print("+\"\\n\"+");
                }
                dummy = true;
                if (this.refTables.get(col) != null) {
                    String refCol = (String)this.refCols.get(col);
                    refCol = refCol.substring(0, 1).toUpperCase() + refCol.substring(1);
                    out.print(col + ".get" + refCol + "()");
                    continue;
                }
                out.print(col);
            }
            out.print(";\n   }\n\n");
            out.print("   /**\n    * adds an Observer to the " + this.name + "Cache class.\n" + "    * <br>\n" + "    * Use this static method instead of addObserver() !\n" + "    * @param o the Observer\n" + "    */\n" + "   public static void putObserver(Observer o){\n" + "      observable.addObserver(o);\n" + "   }\n\n" + "   /**\n" + "    * removes an Observer from the AccessCache class.\n" + "    * <br>\n" + "    * Use this static method instead of deleteObserver() !\n" + "    * @param o the Observer\n" + "    */\n" + "   public static void removeObserver(Observer o){\n" + "      observable.deleteObserver(o);\n" + "   }\n\n" + "   //notify the observers\n" + "   protected static void broadcastEvent(AccessEvent e){\n" + "      observable.setChanged();\n" + "      observable.notifyObservers(e);\n" + "   }\n\n" + "   public static void clean(){\n" + "    cache.clean();\n" + "   }\n");
            out.print("}");
            out.close();
        }
        catch (Exception e) {
            ErrorLog.log(this, "createCacheSource()", "", e);
        }
    }

    public void printMe() {
        System.out.println("OBJECT NAME " + this.name);
        System.out.println("TABLE  NAME " + this.tableName);
        Enumeration e = this.colNames.elements();
        while (e.hasMoreElements()) {
            String col = (String)e.nextElement();
            System.out.print(col + " " + this.colTypes.get(col) + " DEFAULT ");
            if (((String)this.colTypes.get(col)).equals("STRING")) {
                System.out.print("'" + this.colDefaults.get(col) + "' ");
            } else {
                System.out.print(this.colDefaults.get(col) + " ");
            }
            if (this.keyTypes.get(col) == null) {
                System.out.print("FIELD");
            } else {
                System.out.print(this.keyTypes.get(col));
            }
            if (this.refTables.get(col) != null) {
                System.out.print(" REFERENCES " + this.refTables.get(col) + "." + this.refCols.get(col));
            }
            System.out.println();
        }
    }

    public POCreator(String name) {
        this.name = name;
        this.tableName = "";
        this.colNames = new Vector();
        this.colTypes = new Hashtable();
        this.colDefaults = new Hashtable();
        this.keyTypes = new Hashtable();
        this.refTables = new Hashtable();
        this.refCols = new Hashtable();
        this.colComments = new Hashtable();
    }

    public void parseSqlSource() {
        try {
            BufferedReader file = new BufferedReader(new InputStreamReader(new FileInputStream(this.name + ".sql")));
            String line = "";
            while ((line = file.readLine()) != null && (line.length() <= 0 || line.charAt(0) == '#')) {
            }
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                line = st.nextToken();
                if (line.equals("") || line.equals("(")) continue;
                this.tableName = line;
            }
            if (this.tableName.charAt(this.tableName.length() - 1) == '(') {
                this.tableName = this.tableName.substring(0, this.tableName.length() - 1);
            }
            while ((line = file.readLine()) != null) {
                String field = "";
                String type = "";
                String key = "";
                String refTable = "";
                String refCol = "";
                String dummy = "";
                String defaultValue = "";
                String comment = "";
                if (line.length() > 0 && line.charAt(0) != '#') {
                    st = new StringTokenizer(line);
                    if (st.hasMoreTokens()) {
                        field = st.nextToken();
                    }
                    if (field.equals("KEY")) {
                        st = new StringTokenizer(line.substring(line.indexOf("(") + 1, line.indexOf(")")), ",");
                        while (st.hasMoreTokens()) {
                            this.keyTypes.put(st.nextToken().trim(), "KEY");
                        }
                    } else if (!field.equals("INDEX")) {
                        if (line.indexOf("#") > 0) {
                            comment = line.substring(line.indexOf("#") + 1);
                        }
                        while (st.hasMoreTokens() && (type = st.nextToken()).length() == 0) {
                        }
                        block7: while (st.hasMoreTokens()) {
                            dummy = st.nextToken();
                            if (dummy.equalsIgnoreCase("AUTO_INCREMENT")) {
                                this.keyTypes.put(field, "GENERATED");
                                this.hasGeneratedKey = true;
                                this.genKeyName = field;
                            }
                            if (dummy.equalsIgnoreCase("DEFAULT")) {
                                if (st.hasMoreTokens()) {
                                    defaultValue = st.nextToken();
                                }
                                if (defaultValue.charAt(0) == '\'' || defaultValue.charAt(0) == '\"') {
                                    defaultValue = defaultValue.length() > 2 ? defaultValue.substring(1, defaultValue.length() - 2) : "";
                                }
                            }
                            if (!dummy.equalsIgnoreCase("REFERENCES")) continue;
                            if (st.hasMoreTokens()) {
                                refTable = st.nextToken();
                            }
                            while (st.hasMoreTokens()) {
                                refCol = st.nextToken();
                                if (refCol.equals("(")) continue;
                                if (refCol.charAt(0) == '(') {
                                    refCol = refCol.substring(1);
                                }
                                if (refCol.indexOf(")") > 0) {
                                    refCol = refCol.substring(0, refCol.indexOf(")"));
                                }
                                refCol.trim();
                                continue block7;
                            }
                        }
                        this.colNames.addElement(field);
                        this.colTypes.put(field, type);
                        this.colDefaults.put(field, defaultValue);
                        this.colComments.put(field, comment);
                        if (this.keyTypes.get(field) == null) {
                            this.keyTypes.put(field, "FIELD");
                        }
                        if (refTable.length() > 0) {
                            this.refTables.put(field, refTable);
                            this.refCols.put(field, refCol);
                        }
                    }
                }
                System.out.println("found a new field:\n" + field + " " + type + " DEFAULT " + defaultValue + " REFERENCES " + refTable + " " + refCol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createTableRecordSource() {
        try {
            String refCol;
            String r;
            String col;
            String col2;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.name + ".java")));
            out.println("package scone.netobjects;\n\nimport scone.proxy.*;\nimport java.util.*;\nimport adc.parser.*;\n\n/**\n");
            out.println(" */\npublic class " + this.name + " extends TableRecord{\n" + "   protected static DBTableAdapter dbTable;\n\n");
            Enumeration e = this.colNames.elements();
            while (e.hasMoreElements()) {
                col2 = (String)e.nextElement();
                if (this.refTables.get(col2) == null) continue;
                out.println("   " + this.refTables.get(col2) + " " + col2 + ";");
            }
            out.println("\n   //set sql meta-data\n   static{\n      dbTable=new DBTableAdapter(\"" + this.name + "\"," + this.colNames.size() + ");\n");
            e = this.colNames.elements();
            while (e.hasMoreElements()) {
                col2 = (String)e.nextElement();
                out.println("      dbTable.addField(\"" + col2 + "\", dbTable." + this.colTypes.get(col2) + ",\"" + this.colDefaults.get(col2) + "\",dbTable." + this.keyTypes.get(col2) + ");");
            }
            out.println("   }\n\n");
            e = this.colNames.elements();
            while (e.hasMoreElements()) {
                col2 = (String)e.nextElement();
                if (this.refTables.get(col2) != null) {
                    out.println("   /**\n    * gets " + this.colComments.get(col2) + "\n" + "    * @return " + this.colComments.get(col2) + "\n" + "    */\n" + "   public " + this.refTables.get(col2) + " get" + col2.substring(0, 1).toUpperCase() + col2.substring(1) + "(){return " + col2 + ";}\n");
                    continue;
                }
                out.println("   /**\n    * gets " + this.colComments.get(col2) + "\n" + "    * @return " + this.colComments.get(col2) + "\n" + "    */\n" + "   public String get" + col2.substring(0, 1).toUpperCase() + col2.substring(1) + "(){" + "return (String)fieldValues.get(\"" + col2 + "\");}\n");
                if (!((String)this.keyTypes.get(col2)).equals("FIELD")) continue;
                out.println("   /**\n    * sets " + this.colComments.get(col2) + "\n" + "    * @param value " + this.colComments.get(col2) + "\n" + "    */\n" + "   public void set" + col2.substring(0, 1).toUpperCase() + col2.substring(1) + "(String value){" + "fieldValues.put(\"" + col2 + "\",value);}\n");
            }
            out.print("   /**\n");
            out.print("    * creates a new " + this.name + " with the specified keys\n");
            Enumeration e2 = this.colNames.elements();
            while (e2.hasMoreElements()) {
                String col3 = (String)e2.nextElement();
                if (!((String)this.keyTypes.get(col3)).equals("KEY")) continue;
                out.println("    * @param " + col3 + " " + this.colComments.get(col3));
            }
            out.print("    */\n");
            out.print("   public " + this.name + "(");
            boolean dummy = false;
            Enumeration e3 = this.colNames.elements();
            while (e3.hasMoreElements()) {
                col = (String)e3.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print(", ");
                }
                if (this.refTables.get(col) != null) {
                    r = (String)this.refTables.get(col);
                    out.print(r + " " + col);
                } else {
                    out.print("String " + col);
                }
                dummy = true;
            }
            out.print("){\n      dbTable.init(this);\n");
            e3 = this.colNames.elements();
            while (e3.hasMoreElements()) {
                col = (String)e3.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY") || this.refTables.get(col) == null) continue;
                out.println("      this." + col + " = " + col + ";");
            }
            e3 = this.colNames.elements();
            while (e3.hasMoreElements()) {
                col = (String)e3.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (this.refTables.get(col) != null) {
                    refCol = (String)this.refCols.get(col);
                    refCol = refCol.substring(0, 1).toUpperCase() + refCol.substring(1);
                    out.print("      fieldValues.put(\"" + col + "\"," + col + ".get" + refCol + "());\n");
                    continue;
                }
                out.print("      fieldValues.put(\"" + col + "\"," + col + ");\n");
            }
            out.println("      dbTable.dbInit(this);\n   }\n");
            out.println("   private " + this.name + "(){}\n\n" + "   /** \n" + "    * returns " + this.name + " if it exists in the database, null otherwise.");
            e3 = this.colNames.elements();
            while (e3.hasMoreElements()) {
                col = (String)e3.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                out.println("    * @param " + col + " " + this.colComments.get(col));
            }
            out.println("    * @return the specified " + this.name + " or null if it does not exists in the database.\n" + "    */\n");
            out.print("   public static " + this.name + " check(");
            dummy = false;
            e3 = this.colNames.elements();
            while (e3.hasMoreElements()) {
                col = (String)e3.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print(", ");
                }
                if (this.refTables.get(col) != null) {
                    r = (String)this.refTables.get(col);
                    out.print(r + " " + col);
                } else {
                    out.print("String " + col);
                }
                dummy = true;
            }
            out.print("){\n      " + this.name + " check=new " + this.name + "();\n" + "      check.dbTable.init(check);\n");
            e3 = this.colNames.elements();
            while (e3.hasMoreElements()) {
                col = (String)e3.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY") || this.refTables.get(col) == null) continue;
                out.println("      check." + col + " = " + col + ";");
            }
            e3 = this.colNames.elements();
            while (e3.hasMoreElements()) {
                col = (String)e3.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (this.refTables.get(col) != null) {
                    refCol = (String)this.refCols.get(col);
                    refCol = refCol.substring(0, 1).toUpperCase() + refCol.substring(1);
                    out.print("      check.fieldValues.put(\"" + col + "\"," + col + ".get" + refCol + "());\n");
                    continue;
                }
                out.print("      check.fieldValues.put(\"" + col + "\"," + col + ");\n");
            }
            out.println("      check.dbTable.dbInit(check);\n      if(check.hasRecordInDB)\n         return check;\n      else\n         return null;\n   }\n");
            if (this.hasGeneratedKey) {
                out.println("   /** \n    * returns " + this.name + " if it exists in the database, null otherwise.\n" + "    * @param " + this.genKeyName + " " + this.colComments.get(this.genKeyName) + "\n" + "    * @return the specified " + this.name + " or null if it does not exists in the database.\n" + "    */\n" + "   public static " + this.name + " checkById(String " + this.genKeyName + "){\n" + "      " + this.name + " check=new " + this.name + "();\n" + "      check.dbTable.init(check);\n" + "      check.fieldValues.put(\"" + this.genKeyName + "\"," + this.genKeyName + ");\n" + "      check.dbTable.dbCheck(check);\n" + "      if(check.hasRecordInDB){");
                e3 = this.colNames.elements();
                while (e3.hasMoreElements()) {
                    col = (String)e3.nextElement();
                    if (!((String)this.keyTypes.get(col)).equals("KEY") || this.refTables.get(col) == null) continue;
                    out.println("         check." + col + " = " + this.refTables.get(col) + "Cache.getById((String)check.fieldValues.get(\"" + col + "\"));");
                }
                out.print("         return check;\n      }\n      return null;\n   }\n\n");
            }
            out.print("   public Object getKey(int keyNo){\n      switch(keyNo){\n         case 0: return ");
            dummy = false;
            e3 = this.colNames.elements();
            while (e3.hasMoreElements()) {
                col = (String)e3.nextElement();
                if (!((String)this.keyTypes.get(col)).equals("KEY")) continue;
                if (dummy) {
                    out.print("+\"\\n\"+");
                }
                out.print("fieldValues.get(\"" + col + "\")");
                dummy = true;
            }
            out.print(";\n");
            if (this.hasGeneratedKey) {
                out.print("         case 1: return fieldValues.get(\"" + this.genKeyName + "\");\n");
            }
            out.print("         default: return \"\";\n      }\n   }\n\n");
            out.print("   public void store(){\n      dbTable.updateDB(this);\n   }\n}");
            out.close();
        }
        catch (Exception ex) {
            ErrorLog.log(this, "createTableRecordSource()", "", ex);
        }
    }

    public void transTypes() {
        Enumeration e = this.colNames.elements();
        while (e.hasMoreElements()) {
            String col = (String)e.nextElement();
            this.colTypes.put(col, this.getType((String)this.colTypes.get(col)));
        }
    }

    public String getType(String sqlType) {
        sqlType = sqlType.toUpperCase();
        Enumeration e = NUMBERS.elements();
        while (e.hasMoreElements()) {
            if (!sqlType.startsWith((String)e.nextElement())) continue;
            return "NUMBER";
        }
        e = STRINGS.elements();
        while (e.hasMoreElements()) {
            if (!sqlType.startsWith((String)e.nextElement())) continue;
            return "STRING";
        }
        e = BLOBS.elements();
        while (e.hasMoreElements()) {
            if (!sqlType.startsWith((String)e.nextElement())) continue;
            return "BLOB";
        }
        e = DATES.elements();
        while (e.hasMoreElements()) {
            if (!sqlType.startsWith((String)e.nextElement())) continue;
            return "DATE";
        }
        return "UNKNOWN";
    }

    static {
        NUMBERS.addElement("TINYINT");
        NUMBERS.addElement("SMALLINT");
        NUMBERS.addElement("MEDIUMINT");
        NUMBERS.addElement("INT");
        NUMBERS.addElement("INTEGER");
        NUMBERS.addElement("BIGINT");
        NUMBERS.addElement("REAL");
        NUMBERS.addElement("DOUBLE");
        NUMBERS.addElement("FLOAT");
        NUMBERS.addElement("DECIMAL");
        NUMBERS.addElement("NUMERIC");
        STRINGS.addElement("CHAR");
        STRINGS.addElement("VARCHAR");
        STRINGS.addElement("TINYTEXT");
        STRINGS.addElement("TEXT");
        STRINGS.addElement("MEDIUMTEXT");
        STRINGS.addElement("LONGTEXT");
        BLOBS.addElement("TINYBLOB");
        BLOBS.addElement("BLOB");
        BLOBS.addElement("MEDIUMBLOB");
        BLOBS.addElement("LONGBLOB");
        DATES.addElement("DATE");
        DATES.addElement("TIME");
        DATES.addElement("TIMESTAMP");
        DATES.addElement("DATETIME");
    }
}

