/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import scone.util.DOMWriter;
import scone.util.ErrorLog;
import scone.util.NodeEnumeration;
import scone.util.XMLHelper;

public class PersistentProperties {
    private Document dom = null;
    private String fileName = null;
    private Hashtable properties = new Hashtable();
    private Vector propertiesOrder = new Vector();

    public PersistentProperties(String fileName) {
        this.fileName = fileName;
        try {
            this.dom = XMLHelper.parseReader(new FileReader(fileName));
            NodeEnumeration nodes = new NodeEnumeration(this.dom.getFirstChild(), "property");
            Element el = null;
            Property prop = null;
            while (nodes.hasMoreNodes()) {
                try {
                    el = (Element)nodes.nextNode();
                    prop = new Property(el);
                    this.properties.put(prop.getName(), prop);
                    this.propertiesOrder.add(prop.getName());
                }
                catch (Exception exc) {
                    ErrorLog.log(this, "<init>", "", exc);
                }
            }
        }
        catch (IOException ioe) {
            ErrorLog.log(this, "<init>", "Could not read " + fileName, ioe);
            System.out.println("The properties file " + fileName + " could not be found.\nPlease create one and try again!");
            this.dom = new DocumentImpl();
            this.dom.appendChild(this.dom.createElement("properties"));
        }
        catch (Exception ex) {
            ErrorLog.log(this, "<init>", "Error occurred while reading " + fileName, ex);
        }
    }

    public Enumeration getKeys() {
        return this.propertiesOrder.elements();
    }

    public String get(String name) {
        if (this.properties.get(name) != null) {
            return ((Property)this.properties.get(name)).getValue();
        }
        return null;
    }

    protected Vector getValues(String name) {
        if (this.properties.get(name) != null) {
            return ((Property)this.properties.get(name)).getValues();
        }
        return null;
    }

    protected String getType(String name) {
        if (this.properties.get(name) != null) {
            return ((Property)this.properties.get(name)).getType();
        }
        return null;
    }

    public void set(String name, String value) {
        if (this.properties.get(name) != null) {
            ((Property)this.properties.get(name)).setValue(value);
        } else {
            Element node = this.dom.createElement("property");
            node.setAttribute("type", "text");
            node.setAttribute("name", name);
            node.setAttribute("value", value);
            this.dom.getFirstChild().appendChild(node);
            this.properties.put(name, new Property(node));
        }
    }

    public void store() {
        try {
            DOMWriter writer = new DOMWriter(new FileWriter(this.fileName), false);
            writer.print(this.dom);
        }
        catch (Exception exc) {
            ErrorLog.log(this, "store()", "Could not store " + this.fileName, exc);
        }
    }

    public String getName() {
        return this.fileName;
    }

    class Property {
        Element element = null;

        Property(Element element) {
            this.element = element;
        }

        String getName() {
            return this.element.getAttribute("name");
        }

        String getValue() {
            return this.element.getAttribute("value");
        }

        String getType() {
            return this.element.getAttribute("type");
        }

        Vector getValues() {
            Vector<String> vec = new Vector<String>();
            Object value = null;
            NodeEnumeration nodes = new NodeEnumeration(this.element, "value");
            while (nodes.hasMoreNodes()) {
                try {
                    vec.addElement(nodes.nextNode().getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return vec;
        }

        void setValue(String value) {
            this.element.setAttribute("value", value);
        }
    }
}

