/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import scone.util.PersistentProperties;
import scone.util.PersistentPropertiesGui;
import scone.util.PluginRepositoryEntry;

class PluginEditDialog
extends JDialog {
    protected PluginRepositoryEntry entry = null;
    protected int listPos = -1;
    protected DefaultListModel listModel = null;
    protected JLabel pluginName = new JLabel("pluginName", 0);
    protected JButton disable = new JButton(" disable ");

    public PluginEditDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add("North", this.pluginName);
        JPanel buttonPanel = new JPanel();
        cp.add("Center", buttonPanel);
        JButton remove = new JButton(" Remove Plugin ");
        JButton config = new JButton(" Configure Plugin ");
        JButton done = new JButton(" Exit ");
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.disable);
        buttonPanel.add(config);
        buttonPanel.add(remove);
        buttonPanel.add(done);
        this.getRootPane().setDefaultButton(done);
        this.setModal(true);
        this.pack();
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getHeight() / 2);
        this.disable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!PluginEditDialog.this.entry.isEnabled()) {
                        PluginEditDialog.this.entry.enable();
                    } else {
                        PluginEditDialog.this.entry.disable();
                    }
                    PluginEditDialog.this.hide();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        config.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (PluginEditDialog.this.entry.getPlugin() == null) {
                        new PersistentPropertiesGui((Dialog)PluginEditDialog.this, new PersistentProperties("config/properties/" + PluginEditDialog.this.entry.getName() + ".xml"));
                    } else {
                        PluginEditDialog.this.entry.getPlugin().displayConfigGUI(PluginEditDialog.this);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PluginEditDialog.this.entry.remove();
                    PluginEditDialog.this.listModel.removeElementAt(PluginEditDialog.this.listPos);
                    PluginEditDialog.this.hide();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PluginEditDialog.this.hide();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void editPlugin(PluginRepositoryEntry entry, DefaultListModel listModel, int listPos) {
        this.entry = entry;
        this.listModel = listModel;
        this.listPos = listPos;
        this.pluginName.setText(entry.getName());
        this.pluginName.setForeground(new Color(0, 30, 60));
        this.pluginName.setFont(new Font(null, 1, 16));
        if (entry.isEnabled()) {
            this.disable.setLabel(" Disable Plugin ");
            this.disable.setBackground(new Color(202, 182, 182));
        } else {
            this.disable.setLabel(" Enable Plugin ");
            this.disable.setBackground(new Color(182, 202, 182));
        }
        this.pack();
        this.show();
    }
}

