/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import scone.util.DOMWriter;
import scone.util.ErrorLog;
import scone.util.NodeEnumeration;
import scone.util.PluginRepositoryEntry;
import scone.util.XMLHelper;

public class PluginRepository {
    private Document dom = null;
    private static final String configFileName = "config/scone/plugins.xml";
    private Vector entries = new Vector();
    private int requirements = 0;

    public PluginRepository() {
        try {
            this.dom = XMLHelper.parseReader(new FileReader(configFileName));
            NodeEnumeration nodes = new NodeEnumeration(this.dom.getFirstChild(), "plugin");
            Element el = null;
            PluginRepositoryEntry entry = null;
            while (nodes.hasMoreNodes()) {
                try {
                    el = (Element)nodes.nextNode();
                    entry = new PluginRepositoryEntry(el);
                    this.entries.addElement(entry);
                    this.requirements |= entry.getRequirements();
                }
                catch (Exception exc) {
                    ErrorLog.log(this, "<init>", "", exc);
                }
            }
        }
        catch (Exception ex) {
            ErrorLog.log("", "PluginRepository <init>", "Could not read config/scone/plugins.xml", ex);
            System.out.println("Could not read config/scone/plugins.xml");
            System.exit(0);
        }
    }

    public void terminate() {
        Enumeration en = this.getEntries();
        while (en.hasMoreElements()) {
            try {
                ((PluginRepositoryEntry)en.nextElement()).terminate();
            }
            catch (Exception exception) {}
        }
    }

    public PluginRepositoryEntry getEntryByName(String name) {
        Enumeration en = this.getEntries();
        while (en.hasMoreElements()) {
            PluginRepositoryEntry entry = (PluginRepositoryEntry)en.nextElement();
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public PluginRepositoryEntry getEntryByNumber(int pos) {
        return (PluginRepositoryEntry)this.entries.elementAt(pos);
    }

    public PluginRepositoryEntry register(String name) {
        try {
            if (this.getEntryByName(name) != null) {
                throw new RuntimeException("The plugin " + name + " has already been registered!");
            }
            Class.forName(name).newInstance();
            PluginRepositoryEntry entry = this.getEntryByName(name);
            if (entry != null) {
                return entry;
            }
            Element node = this.dom.createElement("plugin");
            node.setAttribute("class", name);
            node.setAttribute("enabled", "yes");
            this.dom.getFirstChild().appendChild(node);
            entry = new PluginRepositoryEntry(node);
            this.entries.addElement(entry);
            this.requirements |= entry.getRequirements();
            return entry;
        }
        catch (ClassNotFoundException cnfe) {
            ErrorLog.log(this, "register()", "Class not found: " + name, cnfe);
        }
        catch (Exception e) {
            ErrorLog.log(this, "register()", "", e);
        }
        return null;
    }

    public void store() {
        try {
            DOMWriter writer = new DOMWriter(new FileWriter(configFileName), false);
            writer.print(this.dom);
        }
        catch (Exception exc) {
            ErrorLog.log(this, "store()", "Could not store config/scone/plugins.xml", exc);
        }
    }

    public Enumeration getEntries() {
        return this.entries.elements();
    }

    public int getRequirements() {
        return this.requirements;
    }
}

