/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import org.w3c.dom.Element;
import scone.Plugin;
import scone.util.ErrorLog;

public class PluginRepositoryEntry {
    Plugin plugin = null;
    Element element = null;
    boolean enabled = false;

    PluginRepositoryEntry(Element element) {
        this.element = element;
        if (element.getAttribute("enabled").equals("yes")) {
            this.instantiatePlugin();
        }
    }

    void instantiatePlugin() {
        try {
            this.plugin = (Plugin)Class.forName(this.element.getAttribute("class")).newInstance();
            this.enabled = true;
        }
        catch (ClassCastException e) {
            String p = "";
            p = this.element.getAttribute("class");
            System.out.println("Error!\nThis is no Scone-Plugin: " + p);
            ErrorLog.log(this, "<init>", "could not cast plugin " + p, e);
        }
        catch (Exception e) {
            String p = "";
            if (this.element != null && (p = this.element.getAttribute("class")) == null) {
                p = "no class!";
            }
            ErrorLog.log(this, "<init>", "could not instanciate plugin " + p, e);
        }
    }

    public void remove() {
        this.disable();
        this.element.getParentNode().removeChild(this.element);
    }

    public void terminate() {
        this.plugin.terminate();
    }

    public void disable() {
        if (this.enabled) {
            if (this.plugin != null) {
                this.plugin.disable();
            }
            this.element.setAttribute("enabled", "no");
        }
        this.enabled = false;
    }

    public void enable() {
        if (!this.enabled) {
            if (this.plugin != null) {
                this.plugin.enable();
            }
            this.element.setAttribute("enabled", "yes");
        }
        this.enabled = true;
    }

    public int getRequirements() {
        if (this.plugin != null) {
            return this.plugin.getRequirements();
        }
        return 0;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.element.getAttribute("class");
    }
}

