/*
 * Decompiled with CFR 0.152.
 */
package scone.util;

import java.util.Stack;
import scone.util.PoolThread;

public class ThreadPool {
    Stack idleThreads = new Stack();
    boolean isClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Runnable runnable) {
        if (this.isClosed) {
            return;
        }
        if (!this.idleThreads.empty()) {
            PoolThread pt = (PoolThread)this.idleThreads.pop();
            pt.setRunnable(runnable);
            PoolThread poolThread = pt;
            synchronized (poolThread) {
                pt.notify();
            }
        } else {
            PoolThread pt = new PoolThread(this);
            pt.setRunnable(runnable);
            pt.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        while (!this.idleThreads.empty()) {
            PoolThread pt;
            PoolThread poolThread = pt = (PoolThread)this.idleThreads.pop();
            synchronized (poolThread) {
                pt.notify();
            }
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void reportIdle(PoolThread pt) {
        this.idleThreads.push(pt);
    }
}

