/*
 * Decompiled with CFR 0.152.
 */
package scone.util.logreader;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SconeReader {
    public static char[] aufbau = new char[]{'h', 'i', 'a', 'd', 'm', 'u', 'p', 's', 'b', 'f'};
    public static String baseUrl = "http://vsys-www.informatik.uni-hamburg.de";
    protected BufferedReader in;
    private boolean eof = false;
    private int lineNumber = 0;
    private static boolean sconeDebug = true;

    protected void readLineIntoContainer(Hashtable datacontainer) {
        ++this.lineNumber;
        System.out.println("-> Parsing line " + this.lineNumber);
        String line = null;
        try {
            line = this.in.readLine();
            if (line == null || line.length() == 0) {
                this.eof = true;
                return;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        if (sconeDebug) {
            System.out.println(line);
        }
        StringTokenizer st = new StringTokenizer(line, " ");
        String[] token = new String[30];
        int i = 0;
        while (st.hasMoreElements()) {
            token[i] = st.nextToken();
            ++i;
        }
        int j = 0;
        block16: for (i = 0; i < aufbau.length; ++i) {
            switch (aufbau[i]) {
                case 'h': {
                    datacontainer.put("host", token[j]);
                    if (sconeDebug) {
                        System.out.println("host: " + token[j]);
                    }
                    ++j;
                    continue block16;
                }
                case 'i': {
                    datacontainer.put("ident", token[j]);
                    if (sconeDebug) {
                        System.out.println("ident: " + token[j]);
                    }
                    ++j;
                    continue block16;
                }
                case 'a': {
                    datacontainer.put("authuser", token[j]);
                    if (sconeDebug) {
                        System.out.println("authuser: " + token[j]);
                    }
                    ++j;
                    continue block16;
                }
                case 'd': {
                    String date = token[j] + " " + token[j + 1];
                    date = date.substring(1, date.length() - 1);
                    datacontainer.put("date", date);
                    if (sconeDebug) {
                        System.out.println("date: " + date);
                    }
                    j += 2;
                    continue block16;
                }
                case 'm': {
                    datacontainer.put("method", token[j].substring(1));
                    if (sconeDebug) {
                        System.out.println("method: " + token[j].substring(1));
                    }
                    ++j;
                    continue block16;
                }
                case 'u': {
                    String url = token[j];
                    if (!url.startsWith("http:")) {
                        url = baseUrl + url;
                    }
                    datacontainer.put("uri", url);
                    if (sconeDebug) {
                        System.out.println("uri: " + url);
                    }
                    ++j;
                    continue block16;
                }
                case 'p': {
                    datacontainer.put("protocol", token[j].substring(0, token[j].length() - 1));
                    if (sconeDebug) {
                        System.out.println("protocol: " + token[j].substring(0, token[j].length() - 1));
                    }
                    ++j;
                    continue block16;
                }
                case 'r': {
                    String request = token[j] + " " + token[j + 1] + " " + token[j + 2];
                    datacontainer.put("request", request);
                    if (sconeDebug) {
                        System.out.println("request: " + request);
                    }
                    j += 3;
                    continue block16;
                }
                case 's': {
                    datacontainer.put("status", token[j]);
                    if (sconeDebug) {
                        System.out.println("status: " + token[j]);
                    }
                    ++j;
                    continue block16;
                }
                case 'b': {
                    datacontainer.put("bytes", token[j]);
                    if (sconeDebug) {
                        System.out.println("bytes: " + token[j]);
                    }
                    ++j;
                    continue block16;
                }
                case 'f': {
                    datacontainer.put("referrer", token[j].substring(1, token[j].length() - 1));
                    if (sconeDebug) {
                        System.out.println("referrer: " + token[j].substring(1, token[j].length() - 1));
                    }
                    ++j;
                    continue block16;
                }
                default: {
                    if (!sconeDebug) continue block16;
                    System.out.println("Unknown Parameter!");
                }
            }
        }
    }

    void tokenToAufbauElementsKonverter(String line) {
    }

    public SconeReader(String filename) {
        try {
            this.in = new BufferedReader(new FileReader(filename));
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }

    public boolean isEof() {
        return this.eof;
    }
}

