/*
 * Decompiled with CFR 0.152.
 */
package scone.util.logreader;

import java.util.Date;
import java.util.Hashtable;
import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.netobjects.User;
import scone.netobjects.UserCache;
import scone.util.logreader.SconeDateFormat;

public class SconeWriter {
    public SconeWriter() {
        DBTableAdapter.init();
        NetNodeCache.init(120000, 0);
        AccessCache.init(300000, 0);
        UserCache.init(600000, 0);
    }

    protected void close() {
        NetNodeCache.clean();
        UserCache.clean();
        AccessCache.clean();
    }

    protected void writeElements(Hashtable dataContainer) {
        String userName;
        String nodeNodeId = "0";
        String referrerNodeId = "0";
        String userId = "0";
        NetNode node = NetNodeCache.get((String)dataContainer.get("uri"));
        node.setSize((String)dataContainer.get("bytes"));
        node.access();
        nodeNodeId = node.getNodeId();
        if (((String)dataContainer.get("referrer")).startsWith("http://")) {
            NetNode referrer = NetNodeCache.get((String)dataContainer.get("referrer"));
            referrer.access();
            referrerNodeId = referrer.getNodeId();
        }
        if ((userName = (String)dataContainer.get("host")).length() > 16) {
            userName = userName.substring(userName.length() - 16);
        }
        User user = UserCache.get(userName);
        userId = user.getUserId();
        String timeString = (String)dataContainer.get("date");
        Date time = SconeDateFormat.convert(timeString);
        Access a = AccessCache.get(userId, nodeNodeId, time.getTime(), "");
        a.setReferrerNodeId(referrerNodeId);
    }
}

