/*
 * Decompiled with CFR 0.152.
 */
package scone.util.tokenstream;

import adc.parser.HtmlStreamTokenizer;
import scone.util.tokenstream.Token;

public class HtmlTextToken
implements Token {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    protected String whiteSpaces;
    protected String text;
    protected String unescapedText;

    public HtmlTextToken(String text, StringBuffer whiteSpaces) {
        this.text = text;
        this.unescapedText = HtmlStreamTokenizer.unescape((String)text);
        this.whiteSpaces = new String(whiteSpaces);
    }

    public HtmlTextToken(String text) {
        this(text, new StringBuffer(""));
    }

    public Token getClone() {
        return new HtmlTextToken(this.text, new StringBuffer(this.whiteSpaces));
    }

    public String getText() {
        return this.text;
    }

    public String getUnescapedText() {
        return this.unescapedText;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void appendText(String text) {
        this.text = this.text + text;
    }

    public String toString() {
        return this.whiteSpaces + this.text;
    }

    public String getWhiteSpaces() {
        return this.whiteSpaces;
    }

    public void setWhiteSpaces(String whiteSpaces) {
        this.whiteSpaces = whiteSpaces;
    }
}

