/*
 * Decompiled with CFR 0.152.
 */
package scone.util.tokenstream;

import adc.parser.HtmlStreamTokenizer;
import adc.parser.HtmlTag;
import java.io.Reader;
import scone.util.tokenstream.HtmlCommentToken;
import scone.util.tokenstream.HtmlScriptToken;
import scone.util.tokenstream.HtmlStyleToken;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.HtmlTextToken;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.Tokenizer;

public class HtmlTokenizer
implements Tokenizer {
    HtmlStreamTokenizer tokenizer = null;

    public void assign(Reader r) {
        this.tokenizer = new HtmlStreamTokenizer(r);
    }

    public Token nextToken() {
        try {
            if (this.tokenizer.nextToken() == -1) {
                return null;
            }
            switch (this.tokenizer.getTokenType()) {
                case -3: {
                    HtmlTag tag = new HtmlTag();
                    HtmlStreamTokenizer.parseTag((StringBuffer)this.tokenizer.getStringValue(), (HtmlTag)tag);
                    if (tag.getTagString() == null) {
                        System.out.print("uh-oh, tag is empty: '");
                        System.out.print(this.tokenizer.getStringValue() + "' - Type: ");
                        System.out.println(tag.getTagType());
                        return new HtmlTextToken(" < >");
                    }
                    return new HtmlTagToken(tag, this.tokenizer.getWhiteSpace());
                }
                case -2: {
                    return new HtmlTextToken(this.tokenizer.getStringValue().toString(), this.tokenizer.getWhiteSpace());
                }
                case -4: {
                    return new HtmlCommentToken(this.tokenizer.getStringValue().toString(), this.tokenizer.getWhiteSpace());
                }
                case -5: {
                    HtmlTag script = new HtmlTag();
                    String scriptString = this.tokenizer.getStringValue().toString();
                    String tagString = scriptString.substring(scriptString.indexOf("<") + 1, scriptString.indexOf(">"));
                    HtmlStreamTokenizer.parseTag((StringBuffer)new StringBuffer(tagString), (HtmlTag)script);
                    scriptString = scriptString.substring(scriptString.indexOf(">") + 1, scriptString.lastIndexOf("<"));
                    return new HtmlScriptToken(script, scriptString, this.tokenizer.getWhiteSpace());
                }
                case -6: {
                    HtmlTag style = new HtmlTag();
                    String styleString = this.tokenizer.getStringValue().toString();
                    String tagString = styleString.substring(styleString.indexOf("<") + 1, styleString.indexOf(">"));
                    HtmlStreamTokenizer.parseTag((StringBuffer)new StringBuffer(tagString), (HtmlTag)style);
                    styleString = styleString.substring(styleString.indexOf(">") + 1, styleString.lastIndexOf("<"));
                    return new HtmlStyleToken(style, styleString, this.tokenizer.getWhiteSpace());
                }
            }
            return new HtmlTextToken(this.tokenizer.getStringValue().toString(), this.tokenizer.getWhiteSpace());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }
}

