/*
 * Decompiled with CFR 0.152.
 */
package scone.util.tokenstream;

import com.ibm.wbi.AbortEvent;
import com.ibm.wbi.AbortIOException;
import com.ibm.wbi.MarkPreservedException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Vector;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenBufferClosedException;
import scone.util.tokenstream.TokenBufferIndexOutOfBoundsException;

public class TokenBuffer {
    private Vector subscriptions = new Vector();
    private CircularTokenStore data;
    private long totalWritten = 0L;
    private boolean done = false;
    private boolean doneReading = false;
    private AbortEvent abortEvent = null;
    private long lowWaterMark = 0L;
    private boolean marked = false;
    private long lowestMark = 0L;
    private static long usage = 0L;
    private static long maxUsage = 0L;
    private static boolean started = false;
    int dummycounter = 0;

    private static synchronized void adjustUsage(long adj) {
        if ((usage += adj) > maxUsage) {
            maxUsage = usage;
        }
    }

    private static synchronized long getUsage() {
        return usage;
    }

    private static synchronized long maxUsage() {
        long rc = maxUsage;
        maxUsage = usage;
        return rc;
    }

    public TokenBuffer(int capacity) {
        this.data = new CircularTokenStore(capacity);
        TokenBuffer.adjustUsage(capacity);
    }

    public TokenBuffer(Token[] source) {
        this.data = new CircularTokenStore(source);
        this.totalWritten = source.length;
    }

    public void finalize() {
        TokenBuffer.adjustUsage(-this.data.capacity());
    }

    public synchronized Object subscribe() {
        if (this.lowWaterMark > 0L) {
            throw new TokenBufferIndexOutOfBoundsException();
        }
        Subscription s = new Subscription();
        this.subscriptions.addElement(s);
        return s;
    }

    public synchronized Object subscribe(Object other) {
        Subscription old = (Subscription)other;
        Subscription s = new Subscription();
        s.offset = old.offset;
        this.subscriptions.addElement(s);
        return s;
    }

    public synchronized void unsubscribe(Object subscription) {
        this.subscriptions.removeElement(subscription);
        this.checkMarks();
        this.checkLowWaterMark();
    }

    public synchronized void mark(Object subscription, int readlimit) {
        Subscription s = (Subscription)subscription;
        s.marked = true;
        s.mark = s.offset;
        s.readlimit = readlimit;
        if (readlimit == -1) {
            s.unlimited = true;
        }
        this.checkMarks();
        this.notifyAll();
    }

    public synchronized void reset(Object subscription) throws IOException {
        Subscription s = (Subscription)subscription;
        if (!s.marked) {
            throw new IOException("reset() called on unmarked stream");
        }
        s.offset = s.mark;
        s.marked = false;
        this.checkMarks();
    }

    public synchronized void preserveMark(Object subscription) throws IOException {
        Subscription s = (Subscription)subscription;
        if (!s.marked) {
            throw new IOException("preserveMark() called on unmarked stream");
        }
        s.preserveMark = true;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized long getMark(Object subscription) throws IOException {
        Subscription s = (Subscription)subscription;
        if (!s.marked) {
            throw new IOException("getMark() called on unmarked stream");
        }
        return s.mark;
    }

    public synchronized void unmark(Object subscription) {
        Subscription s = (Subscription)subscription;
        s.marked = false;
        s.mark = 0L;
        s.readlimit = 0;
        s.unlimited = false;
        s.preserveMark = false;
        this.checkMarks();
    }

    private synchronized void checkMarks() {
        this.lowestMark = Long.MAX_VALUE;
        this.marked = false;
        Enumeration e = this.subscriptions.elements();
        while (e.hasMoreElements()) {
            Subscription sub = (Subscription)e.nextElement();
            if (!sub.marked) continue;
            this.marked = true;
            if (sub.mark >= this.lowestMark) continue;
            this.lowestMark = sub.mark;
        }
        this.checkLowWaterMark();
    }

    private synchronized void unmarkLowestMark() {
        long tmpLowestMark = Long.MAX_VALUE;
        Subscription tmpLowestMarker = null;
        Enumeration s = this.subscriptions.elements();
        while (s.hasMoreElements()) {
            Subscription sub = (Subscription)s.nextElement();
            if (!sub.marked || sub.mark >= tmpLowestMark) continue;
            tmpLowestMark = sub.mark;
            tmpLowestMarker = sub;
        }
        if (tmpLowestMarker != null) {
            this.unmark(tmpLowestMarker);
        }
    }

    private synchronized void checkLowWaterMark() {
        long oldLowWaterMark = this.lowWaterMark;
        this.lowWaterMark = this.marked ? this.lowestMark : Long.MAX_VALUE;
        Enumeration e = this.subscriptions.elements();
        while (e.hasMoreElements()) {
            Subscription sub = (Subscription)e.nextElement();
            if (sub.offset >= this.lowWaterMark) continue;
            this.lowWaterMark = sub.offset;
        }
        int discard = (int)(this.lowWaterMark - oldLowWaterMark);
        if (discard > 0) {
            this.data.discardTokens(discard);
            this.notifyAll();
        }
    }

    public synchronized int read(Token[] buf, int offset, int size, Object context, long timeout, boolean peek) throws AbortIOException, InterruptedIOException, MarkPreservedException {
        if (context == null) {
            throw new NullPointerException();
        }
        Subscription s = (Subscription)context;
        long startWait = System.currentTimeMillis();
        long remainingWait = timeout;
        while (s.offset >= this.totalWritten && !this.isDone() && !this.isAborted()) {
            try {
                if (timeout == 0L) {
                    this.wait();
                    continue;
                }
                this.wait(remainingWait);
                remainingWait = timeout - (System.currentTimeMillis() - startWait);
                if (remainingWait >= 1L) continue;
                break;
            }
            catch (InterruptedException e) {
            }
        }
        if (this.isAborted()) {
            throw new AbortIOException(this.abortEvent);
        }
        int available = Math.min((int)(this.totalWritten - s.offset), size);
        if (available > 0) {
            this.data.peekTokens((int)(this.totalWritten - s.offset), buf, offset, available, this.mustClone());
            if (!peek) {
                if (s.marked && !s.unlimited && s.preserveMark && available > s.readlimit) {
                    if (s.readlimit > 0) {
                        available = s.readlimit;
                    } else {
                        throw new MarkPreservedException("Read would exceed readlimit");
                    }
                }
                s.offset += (long)available;
                if (s.marked && !s.unlimited) {
                    s.readlimit -= available;
                    if (s.readlimit < 0) {
                        this.unmark(s);
                    }
                }
                this.checkLowWaterMark();
            }
            return available;
        }
        if (this.isDone()) {
            return -1;
        }
        throw new InterruptedIOException();
    }

    private void ensureSpace(int size) {
        int oldCapacity = this.data.capacity();
        this.data.ensureCapacity(size + this.data.length());
        int diff = this.data.capacity() - oldCapacity;
        if (diff != 0) {
            TokenBuffer.adjustUsage(diff);
        }
    }

    private boolean getSpaceIfMarked(int size) {
        boolean ensured = false;
        while (this.marked && !ensured) {
            try {
                this.ensureSpace(size);
                ensured = true;
            }
            catch (OutOfMemoryError e) {
                this.unmarkLowestMark();
            }
        }
        return true;
    }

    public synchronized int write(Token[] buf, int offset, int size) throws TokenBufferClosedException, AbortIOException {
        if (this.isDone()) {
            throw new TokenBufferClosedException();
        }
        while (!(!this.getSpaceIfMarked(size) || this.data.space() != 0 || this.isAborted() || this.isDoneReading() && this.subscriptions.size() == 0)) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (this.isAborted()) {
            throw new AbortIOException(this.abortEvent);
        }
        if (this.isDoneReading() && this.subscriptions.size() == 0) {
            return size;
        }
        int written = Math.min(this.data.space(), size);
        this.data.appendTokens(buf, offset, written);
        this.totalWritten += (long)written;
        this.notifyAll();
        return written;
    }

    public synchronized void done() {
        if (!this.done) {
            this.done = true;
            this.notifyAll();
        }
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized void doneReading() {
        if (!this.doneReading) {
            this.doneReading = true;
            this.notifyAll();
        }
    }

    public synchronized boolean isDoneReading() {
        return this.doneReading;
    }

    public synchronized int available(Object context) {
        Subscription s = (Subscription)context;
        return (int)(this.totalWritten - s.offset);
    }

    public synchronized void handleAbort(AbortEvent ae) {
        this.abortEvent = ae;
        this.notifyAll();
    }

    public synchronized boolean isAborted() {
        return this.abortEvent != null;
    }

    public synchronized AbortEvent getAbortEvent() {
        return this.abortEvent;
    }

    public long getOffset(Object context) {
        Subscription s = (Subscription)context;
        return s.offset;
    }

    private boolean mustClone() {
        return this.marked || this.subscriptions.size() > 1;
    }

    public class CircularTokenStore {
        private Token[] data = null;
        private boolean empty = true;
        private int first = 0;
        private int next = 0;

        public CircularTokenStore(int capacity) {
            this.data = new Token[capacity];
        }

        public CircularTokenStore(Token[] source) {
            this.data = source;
            this.empty = false;
            this.first = 0;
            this.next = source.length;
        }

        public void appendTokens(Token[] src, int offset, int length) {
            int firstCopy = Math.min(this.data.length - this.next, length);
            System.arraycopy(src, offset, this.data, this.next, firstCopy);
            if (firstCopy < length) {
                System.arraycopy(src, offset + firstCopy, this.data, 0, length - firstCopy);
            }
            this.next = (this.next + length) % this.data.length;
            this.empty = false;
        }

        public void discardTokens(int num) {
            this.first = (this.first + num) % this.data.length;
            if (this.first == this.next) {
                this.first = 0;
                this.next = 0;
                this.empty = true;
            }
        }

        public void peekTokens(int backwardsOffset, Token[] dest, int destOffset, int length, boolean mustClone) {
            int srcOffset = this.next - backwardsOffset;
            if (srcOffset < 0) {
                srcOffset += this.data.length;
            }
            this.copy(srcOffset, dest, destOffset, length, mustClone);
        }

        public int length() {
            if (this.empty) {
                return 0;
            }
            if (this.first < this.next) {
                return this.next - this.first;
            }
            return this.data.length - this.first - this.next;
        }

        public int space() {
            if (!this.empty && this.next == this.first) {
                return 0;
            }
            if (this.first <= this.next) {
                return this.data.length - (this.next - this.first);
            }
            return this.first - this.next;
        }

        public int capacity() {
            return this.data.length;
        }

        public void ensureCapacity(int c) {
            int newCapacity;
            if (c < this.data.length) {
                return;
            }
            for (newCapacity = this.data.length; newCapacity < c; newCapacity *= 2) {
            }
            Token[] newData = new Token[newCapacity];
            int oldLength = this.length();
            this.copy(this.first, newData, 0, oldLength, false);
            this.data = newData;
            this.first = 0;
            this.next = oldLength;
        }

        private void copy(int srcOffset, Token[] dest, int destOffset, int length, boolean mustClone) {
            int firstCopy = Math.min(this.data.length - srcOffset, length);
            if (mustClone) {
                this.cloneCopy(this.data, srcOffset, dest, destOffset, firstCopy);
                if (firstCopy < length) {
                    this.cloneCopy(this.data, 0, dest, destOffset + firstCopy, length - firstCopy);
                }
            } else {
                System.arraycopy(this.data, srcOffset, dest, destOffset, firstCopy);
                if (firstCopy < length) {
                    System.arraycopy(this.data, 0, dest, destOffset + firstCopy, length - firstCopy);
                }
            }
        }

        private void cloneCopy(Token[] src, int srcPos, Token[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos++] = src[srcPos++].getClone();
            }
        }
    }

    class Subscription {
        public long offset = 0L;
        public boolean marked = false;
        public long mark = 0L;
        public int readlimit = 0;
        public boolean unlimited = false;
        public boolean preserveMark = false;

        Subscription() {
        }
    }
}

