/*
 * Decompiled with CFR 0.152.
 */
package scone.util.tokenstream;

import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.protocol.http.DocumentInfo;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStreamBufferImpl;
import scone.util.tokenstream.TokenInputStreamTokenizerImpl;
import scone.util.tokenstream.TokenOutputStream;

public abstract class TokenInputStream {
    public static synchronized TokenInputStream create(RequestEvent e, String tokenizer) throws Exception {
        if (e.getMegObjectType() == Class.forName("scone.util.tokenstream.TokenOutputStream")) {
            return new TokenInputStreamBufferImpl((TokenOutputStream)e.getMegObject());
        }
        ((DocumentInfo)e.getRequestInfo()).getHttpResponseHeader().remove("content-length");
        return new TokenInputStreamTokenizerImpl((Reader)e.getMegReader(), tokenizer);
    }

    public static synchronized TokenInputStream create(RequestEvent e) throws Exception {
        if (e.getMegObjectType() == Class.forName("scone.util.tokenstream.TokenOutputStream")) {
            try {
                return new TokenInputStreamBufferImpl((TokenOutputStream)e.getMegObject());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        ((DocumentInfo)e.getRequestInfo()).getHttpResponseHeader().remove("content-length");
        try {
            if (((DocumentInfo)e.getRequestInfo()).getHttpResponseHeader().get("content-type").toString().toLowerCase().indexOf("utf-8") >= 0) {
                return new TokenInputStreamTokenizerImpl((Reader)e.getMegReader("iso-8859-1"));
            }
            return new TokenInputStreamTokenizerImpl((Reader)e.getMegReader());
        }
        catch (UnsupportedEncodingException ex) {
            System.out.print("Illegal Character Set: ");
            System.out.println(((DocumentInfo)e.getRequestInfo()).getHttpResponseHeader().get("content-type"));
            return new TokenInputStreamTokenizerImpl((Reader)e.getMegReader("iso-8859-1"));
        }
    }

    public abstract Token read() throws IOException;

    public abstract int read(Token[] var1, int var2, int var3) throws IOException;

    public abstract int read(Token[] var1) throws IOException;

    public abstract void close() throws IOException;

    public abstract boolean isClosed();

    public abstract boolean markSupported();

    public abstract void mark(int var1) throws IOException;

    public abstract void reset() throws IOException;

    public abstract Hashtable getMetaInfo();
}

