/*
 * Decompiled with CFR 0.152.
 */
package scone.util.tokenstream;

import java.io.IOException;
import java.util.Hashtable;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenBuffer;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;

public class TokenInputStreamBufferImpl
extends TokenInputStream {
    private static final String COPYRIGHT = " (C) Copyright IBM Corp. 1999, 2000. All Rights Reserved. ";
    private TokenBuffer buffer = null;
    private Object bufferContext = null;
    private boolean closed = false;
    private long timeout = 0L;
    private boolean untouched = true;
    private Hashtable metaInfo = null;

    public TokenInputStreamBufferImpl(TokenOutputStream out) {
        this.buffer = out.getTokenBuffer();
        this.metaInfo = out.getMetaInfo();
        this.bufferContext = out.getBufferContext();
    }

    public Token read() throws IOException {
        this.checkClosed();
        Token[] b = new Token[1];
        int rc = this.buffer.read(b, 0, 1, this.bufferContext, this.timeout, false);
        this.untouched = false;
        if (rc < 0) {
            return null;
        }
        return b[0];
    }

    public int read(Token[] buf, int offset, int length) throws IOException {
        this.checkClosed();
        int rc = this.buffer.read(buf, offset, length, this.bufferContext, this.timeout, false);
        this.untouched = false;
        return rc;
    }

    public int read(Token[] buf) throws IOException {
        this.checkClosed();
        int rc = this.buffer.read(buf, 0, buf.length, this.bufferContext, this.timeout, false);
        this.untouched = false;
        return rc;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.buffer.unsubscribe(this.bufferContext);
            this.bufferContext = null;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void mark(int readlimit) {
        this.buffer.mark(this.bufferContext, readlimit);
    }

    public void reset() throws IOException {
        this.checkClosed();
        this.buffer.reset(this.bufferContext);
    }

    public boolean markSupported() {
        return true;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("TokenInputStream is closed to read.");
        }
    }

    public Hashtable getMetaInfo() {
        return this.metaInfo;
    }
}

