/*
 * Decompiled with CFR 0.152.
 */
package scone.util.tokenstream;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import scone.util.tokenstream.HtmlTokenizer;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.Tokenizer;

public class TokenInputStreamTokenizerImpl
extends TokenInputStream {
    private static final String COPYRIGHT = " (C) Copyright IBM Corp. 1999, 2000. All Rights Reserved. ";
    private Reader reader = null;
    private Tokenizer tokenizer = null;
    private boolean closed = false;
    private Hashtable metaInfo = new Hashtable();

    public TokenInputStreamTokenizerImpl(Reader reader) {
        try {
            this.reader = reader;
            this.tokenizer = new HtmlTokenizer();
            this.tokenizer.assign(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TokenInputStreamTokenizerImpl(Reader reader, String tokenizer) {
        try {
            this.reader = reader;
            this.tokenizer = (Tokenizer)Class.forName(tokenizer).newInstance();
            this.tokenizer.assign(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Token read() throws IOException {
        this.checkClosed();
        return this.tokenizer.nextToken();
    }

    public int read(Token[] buf, int offset, int length) throws IOException {
        int i;
        this.checkClosed();
        int end = offset + length;
        Token t = null;
        for (i = offset; i < end && (t = this.read()) != null; ++i) {
            buf[i] = t;
        }
        if (t == null && i == offset) {
            return -1;
        }
        return i - offset;
    }

    public int read(Token[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.reader.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean markSupported() {
        return this.reader.markSupported();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.reader.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("MegObjectInputStream is closed to read.");
        }
    }

    public Hashtable getMetaInfo() {
        return this.metaInfo;
    }
}

