/*
 * Decompiled with CFR 0.152.
 */
package scone.util.tokenstream;

import com.ibm.wbi.MegObject;
import com.ibm.wbi.NotCharDataException;
import com.ibm.wbi.RequestEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenBuffer;
import scone.util.tokenstream.TokenBufferClosedException;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenInputStreamBufferImpl;

public class TokenOutputStream
implements MegObject {
    private static final String COPYRIGHT = " (C) Copyright IBM Corp. 1999, 2000. All Rights Reserved. ";
    private TokenBuffer buffer = null;
    private Object bufferContext = null;
    private boolean closed = false;
    private long timeout = 0L;
    private Hashtable metaInfo = null;

    public TokenOutputStream() {
        this.buffer = new TokenBuffer(256);
        this.bufferContext = this.buffer.subscribe();
    }

    TokenOutputStream(TokenBuffer buffer, long timeout) {
        this.buffer = buffer;
        this.timeout = timeout;
        this.bufferContext = buffer.subscribe();
        buffer.mark(this.bufferContext, -1);
    }

    public static synchronized TokenOutputStream create(RequestEvent e) throws Exception {
        TokenOutputStream out = new TokenOutputStream();
        e.putMegObject((MegObject)out);
        return out;
    }

    public InputStream getInputStream() {
        return new TokenStreamer(this);
    }

    public Reader getReader() throws UnsupportedEncodingException, NotCharDataException {
        return null;
    }

    public Reader getReader(String encoding) throws UnsupportedEncodingException, NotCharDataException {
        return this.getReader();
    }

    public MegObject getClone() {
        return new TokenOutputStream(this.buffer, this.timeout);
    }

    public void write(Token[] buf, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("TokenOutputStream is closed to write.");
        }
        try {
            if (length > 0) {
                for (int written = 0; written < length; written += this.buffer.write(buf, offset + written, length - written)) {
                }
            }
        }
        catch (TokenBufferClosedException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(Token token) throws IOException {
        Token[] tArray = new Token[]{token};
        this.write(tArray, 0, 1);
    }

    public void write(Token[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.buffer.done();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void flush() throws IOException {
    }

    TokenBuffer getTokenBuffer() {
        return this.buffer;
    }

    protected Object getBufferContext() {
        return this.bufferContext;
    }

    public Hashtable getMetaInfo() {
        return this.metaInfo;
    }

    protected void setMetaInfo(Hashtable metaInfo) {
        this.metaInfo = metaInfo;
    }

    class TokenStreamer
    extends InputStream {
        TokenInputStream in = null;
        StringBuffer buffer = new StringBuffer();
        int pos = 0;

        public TokenStreamer(TokenOutputStream out) {
            this.in = new TokenInputStreamBufferImpl(out);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            Token token = null;
            while (this.buffer.length() - this.pos == 0) {
                this.pos = 0;
                token = this.in.read();
                if (token == null) {
                    return -1;
                }
                this.buffer = new StringBuffer(token.toString());
            }
            if (len > this.buffer.length() - this.pos) {
                len = this.buffer.length() - this.pos;
            }
            for (int i = 0; i < len; ++i) {
                b[off + i] = (byte)this.buffer.charAt(this.pos + i);
            }
            this.pos += len;
            return len;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int l = this.read(b, 0, 1);
            if (l < 0) {
                return l;
            }
            int bret = b[0];
            if (bret < 0) {
                bret += 256;
            }
            return bret;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

