/*
 * Decompiled with CFR 0.152.
 */
package webchains.sessionlogger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;
import scone.Plugin;
import scone.util.AlertBox;
import webchains.elements.WebObject;
import webchains.elements.WebObjectVisit;
import webchains.sessionlogger.LoggerSconePlugin;
import webchains.util.DateUtils;
import webchains.util.DayIntPair;
import webchains.util.DayLongPair;

public class LogFileWriter {
    public static String userEmail_ = null;
    public static String userFirstName_ = null;
    public static String userLastName_ = null;
    public static String userName_ = null;
    public static long firstDateOfRunning_ = 0L;
    protected static Plugin loggerPlugin_;
    static final String FILE_DIR = "log";
    static String LOGGING_PROTOCOL_FILE;
    static final String LOGGING_GLOBALVAR_FILE = "webchainsLogFileGlobals.csv";
    protected File logFile_;
    protected static File globalsFile_;
    protected static BufferedReader logReader_;
    protected static BufferedReader globalsReader_;
    protected static PrintStream logStream_;
    protected static PrintStream globalsStream_;
    private static String lastStringThatWasPrintedToLog_;
    protected static String versionNumber_;
    public static long totalSecondsUnnormalizMsieUsage_;
    public static long totalSecondsNormalizedMsieUsage_;
    public static int totalNumberOfVisitsMsie_;
    public static int totalNumberOfVisits_;
    public static Vector dailySecondsUnnormalizMsieUsage_;
    public static Vector dailySecondsNormalizedMsieUsage_;
    public static Vector dailyNumberOfVisitsMsie_;
    public static Vector dailyNumberOfVisits_;
    public static String rem1_;
    public static String rem2_;
    public static String rem3_;
    public static String rem4_;
    public static String rem5_;
    public static String rem6_;
    public static String rem7_;
    public static String rem8_;
    public static String rem9_;
    public static String rem10_;
    public static String rem11_;
    private static long runTimeInMillisSinceLastWriteMsie_;

    public LogFileWriter(Plugin loggerPlugin) {
        loggerPlugin_ = loggerPlugin;
        this.init();
    }

    protected void init() {
        this.initLogFiles();
        this.initWriters();
        this.initReaders();
        this.readGobals();
    }

    void initLogFiles() {
        File dir = new File(FILE_DIR);
        if (!dir.exists()) {
            dir.mkdir();
        }
        String fileName = FILE_DIR + File.separator + LOGGING_GLOBALVAR_FILE;
        globalsFile_ = new File(fileName);
        fileName = FILE_DIR + File.separator + LOGGING_PROTOCOL_FILE;
        this.logFile_ = new File(fileName);
    }

    public void initWriters() {
        try {
            if (this.logFile_.exists()) {
                logStream_ = new PrintStream(new FileOutputStream(this.logFile_.getAbsolutePath(), true));
            } else {
                this.logFile_.createNewFile();
                logStream_ = new PrintStream(new FileOutputStream(this.logFile_.getAbsolutePath()));
            }
            logStream_.println(this.getHeaderString());
            logStream_.println(WebObjectVisit.getColumnTitles());
            try {
                if (!globalsFile_.exists()) {
                    globalsFile_.createNewFile();
                    globalsStream_ = new PrintStream(new FileOutputStream(globalsFile_.getAbsolutePath()));
                    this.writeGobalsForFirstTime();
                    globalsStream_.flush();
                    globalsStream_.close();
                }
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("Could not create OutputStream!");
            e.printStackTrace();
        }
    }

    public void initReaders() {
        try {
            globalsReader_ = new BufferedReader(new FileReader(globalsFile_));
            logReader_ = new BufferedReader(new FileReader(this.logFile_));
        }
        catch (Exception e) {
            System.out.println("Could not create InputStream!");
            e.printStackTrace();
        }
    }

    public void writeGobalsForFirstTime() {
        Vector<Object> temp = new Vector<Object>();
        temp.add(new DayLongPair(DateUtils.getSecondsAsLong(), 0L));
        dailySecondsUnnormalizMsieUsage_ = temp;
        temp = new Vector();
        temp.add(new DayLongPair(DateUtils.getSecondsAsLong(), 0L));
        dailySecondsNormalizedMsieUsage_ = temp;
        temp = new Vector();
        temp.add(new DayIntPair(DateUtils.getSecondsAsLong(), 0));
        dailyNumberOfVisitsMsie_ = temp;
        temp = new Vector();
        temp.add(new DayIntPair(DateUtils.getSecondsAsLong(), 0));
        dailyNumberOfVisits_ = temp;
        firstDateOfRunning_ = DateUtils.getSecondsAsLong();
        String newline = "\n";
        String empty = "";
        String s = "userEmail_,\"" + loggerPlugin_.getProperties().get("USER_EMAIL") + "\"" + newline + "userName_," + "\"" + loggerPlugin_.getProperties().get("USER_NAME") + "\"" + newline + newline + "firstDateOfRunning_," + "\"" + firstDateOfRunning_ + "\"," + DateUtils.getRealDateAndTimeFromSecslong(firstDateOfRunning_) + newline + newline + "totalSecondsUnnormalizMsieUsage_," + "\"0\"" + newline + "totalSecondsNormalizedMsieUsage_," + "\"0\"" + newline + newline + "totalNumberOfVisitsMsie_," + "\"0\"" + newline + "totalNumberOfVisits_," + "\"0\"" + newline + newline + LogFileWriter.getDailyEntries() + "REM ." + rem1_ + newline + "REM ." + rem2_ + newline + "REM ." + rem3_ + newline + "REM ." + rem4_ + newline + "REM ." + rem5_ + newline + "REM ." + rem6_ + newline + "REM ." + rem7_ + newline + "REM ." + rem8_ + newline + "REM ." + rem9_ + newline + "REM ." + rem10_ + newline + "REM ." + rem11_;
        try {
            globalsStream_.println(LogFileWriter.getHeaderString());
            globalsStream_.print(s);
        }
        catch (Exception e) {
            System.out.println("oops! Could not write current globals!");
            e.printStackTrace();
        }
    }

    private static String getDailyEntries() {
        Object item;
        String newline = "\n";
        String empty = "";
        String s = "";
        Iterator iter = dailySecondsUnnormalizMsieUsage_.iterator();
        s = s + newline;
        while (iter.hasNext()) {
            item = (DayLongPair)iter.next();
            s = s + "dailySecondsUnnormalizMsieUsage_,\"" + ((DayLongPair)item).getDateSeconds() + "\", " + DateUtils.getRealDateAndTimeFromSecslong(((DayLongPair)item).getDateSeconds()) + ", *" + ((DayLongPair)item).getHowMany() + "*, " + DateUtils.getVirtualDate1970FromSecslong(((DayLongPair)item).getHowMany()) + newline;
        }
        iter = dailySecondsNormalizedMsieUsage_.iterator();
        s = s + newline;
        while (iter.hasNext()) {
            item = (DayLongPair)iter.next();
            s = s + "dailySecondsNormalizedMsieUsage_,\"" + ((DayLongPair)item).getDateSeconds() + "\", " + DateUtils.getRealDateAndTimeFromSecslong(((DayLongPair)item).getDateSeconds()) + ", *" + ((DayLongPair)item).getHowMany() + "*, " + DateUtils.getVirtualDate1970FromSecslong(((DayLongPair)item).getHowMany()) + newline;
        }
        iter = dailyNumberOfVisitsMsie_.iterator();
        s = s + newline;
        while (iter.hasNext()) {
            item = (DayIntPair)iter.next();
            s = s + "dailyNumberOfVisitsMsie_,\"" + ((DayIntPair)item).getDateSeconds() + "\", " + DateUtils.getRealDateAndTimeFromSecslong(((DayIntPair)item).getDateSeconds()) + ", *" + ((DayIntPair)item).getHowMany() + "*" + newline;
        }
        iter = dailyNumberOfVisits_.iterator();
        s = s + newline;
        while (iter.hasNext()) {
            item = (DayIntPair)iter.next();
            s = s + "dailyNumberOfVisits_,\"" + ((DayIntPair)item).getDateSeconds() + "\", " + DateUtils.getRealDateAndTimeFromSecslong(((DayIntPair)item).getDateSeconds()) + ", *" + ((DayIntPair)item).getHowMany() + "*" + newline;
        }
        s = s + newline;
        return s;
    }

    public static void writeGlobals() {
        String newline = "\n";
        String empty = "";
        long useTimeInMillisSinceLastWriteMsie = LoggerSconePlugin.getUseTimeMeasureTool().getUseTimeInMillisSinceLastWrite();
        runTimeInMillisSinceLastWriteMsie_ = DateUtils.getSecondsAsLong() - LoggerSconePlugin.getLastWriteTime();
        totalSecondsUnnormalizMsieUsage_ += runTimeInMillisSinceLastWriteMsie_;
        totalSecondsNormalizedMsieUsage_ += useTimeInMillisSinceLastWriteMsie;
        totalNumberOfVisitsMsie_ += LoggerSconePlugin.visitsSinceLastWriteMsie_;
        if (dailySecondsUnnormalizMsieUsage_.size() > 0) {
            ((DayLongPair)dailySecondsUnnormalizMsieUsage_.get(dailySecondsUnnormalizMsieUsage_.size() - 1)).addToHowMany(runTimeInMillisSinceLastWriteMsie_);
            ((DayLongPair)dailySecondsNormalizedMsieUsage_.get(dailySecondsNormalizedMsieUsage_.size() - 1)).addToHowMany(useTimeInMillisSinceLastWriteMsie);
            ((DayIntPair)dailyNumberOfVisitsMsie_.get(dailyNumberOfVisitsMsie_.size() - 1)).addToHowMany(LoggerSconePlugin.visitsSinceLastWriteMsie_);
            totalNumberOfVisits_ += LoggerSconePlugin.visitsSinceLastWrite_;
            ((DayIntPair)dailyNumberOfVisits_.get(dailyNumberOfVisits_.size() - 1)).addToHowMany(LoggerSconePlugin.visitsSinceLastWrite_);
        }
        LogFileWriter.resetAccumulatorsAfterWriting();
        String s = "userEmail_,\"" + loggerPlugin_.getProperties().get("USER_EMAIL") + "\"" + newline + "userName_," + "\"" + loggerPlugin_.getProperties().get("USER_NAME") + "\"" + newline + newline + "firstDateOfRunning_," + "\"" + firstDateOfRunning_ + "\"," + DateUtils.getRealDateAndTimeFromSecslong(firstDateOfRunning_) + newline + newline + "totalSecondsUnnormalizMsieUsage_," + "\"" + totalSecondsUnnormalizMsieUsage_ + "\"" + "," + DateUtils.getVirtualDate1970FromSecslong(totalSecondsUnnormalizMsieUsage_) + newline + "totalSecondsNormalizedMsieUsage_," + "\"" + totalSecondsNormalizedMsieUsage_ + "\"" + "," + DateUtils.getVirtualDate1970FromSecslong(totalSecondsNormalizedMsieUsage_) + newline + newline + "totalNumberOfVisitsMsie_," + "\"" + totalNumberOfVisitsMsie_ + "\"" + newline + "totalNumberOfVisits_," + "\"" + totalNumberOfVisits_ + "\"" + newline + newline + LogFileWriter.getDailyEntries() + "REM ." + rem1_ + newline + "REM ." + rem2_ + newline + "REM ." + rem3_ + newline + "REM ." + rem4_ + newline + "REM ." + rem5_ + newline + "REM ." + rem6_ + newline + "REM ." + rem7_ + newline + "REM ." + rem8_ + newline + "REM ." + rem9_ + newline + "REM ." + rem10_ + newline + "REM ." + rem11_;
        try {
            globalsStream_ = new PrintStream(new FileOutputStream(globalsFile_));
            globalsStream_.println(LogFileWriter.getHeaderString());
            globalsStream_.print(s);
            globalsStream_.flush();
            globalsStream_.close();
            LoggerSconePlugin.setLastWriteTimeNow();
        }
        catch (Exception e) {
            System.out.println("oops! Could not write current session!");
            e.printStackTrace();
        }
    }

    private static String getHeaderString() {
        String idel = LoggerSconePlugin.getItemDelimiter();
        return idel + idel + idel + idel + idel + idel + "NEW SYSTEM LAUNCH" + DateUtils.getRealDateAndTimeFromSecslong(DateUtils.getSecondsAsLong()) + idel + "Webchains LoggerSconePlugin Version " + LoggerSconePlugin.getLoggerVersion() + idel + "LogFileWriter Version " + versionNumber_;
    }

    private static void resetAccumulatorsAfterWriting() {
        runTimeInMillisSinceLastWriteMsie_ = 0L;
        LoggerSconePlugin.getUseTimeMeasureTool().resetUseTimeInMillisSinceLastWrite();
        LoggerSconePlugin.visitsSinceLastWriteMsie_ = 0;
        LoggerSconePlugin.visitsSinceLastWrite_ = 0;
    }

    public void readGobals() {
        if (this.isCompatible()) {
            String line = "";
            try {
                line = globalsReader_.readLine();
                userEmail_ = this.parseValue(line);
                line = globalsReader_.readLine();
                userName_ = this.parseValue(line);
                line = globalsReader_.readLine();
                line = globalsReader_.readLine();
                firstDateOfRunning_ = Long.parseLong(this.parseValue(line));
                line = globalsReader_.readLine();
                line = globalsReader_.readLine();
                totalSecondsUnnormalizMsieUsage_ = Long.parseLong(this.parseValue(line));
                line = globalsReader_.readLine();
                totalSecondsNormalizedMsieUsage_ = Long.parseLong(this.parseValue(line));
                line = globalsReader_.readLine();
                line = globalsReader_.readLine();
                totalNumberOfVisitsMsie_ = Integer.parseInt(this.parseValue(line));
                line = globalsReader_.readLine();
                totalNumberOfVisits_ = Integer.parseInt(this.parseValue(line));
                line = globalsReader_.readLine();
                DayLongPair tempDayLongPair = new DayLongPair(0L, 0L);
                DayIntPair tempDayIntPair = new DayIntPair(0L, 0);
                boolean stillDailyValuesAvailable = true;
                boolean atLeastOneDailyValueWasGiven = false;
                line = globalsReader_.readLine();
                line = globalsReader_.readLine();
                stillDailyValuesAvailable = true;
                while (stillDailyValuesAvailable) {
                    if (line.indexOf("dailySecondsUnnormalizMsieUsage_") != -1) {
                        tempDayLongPair = new DayLongPair(Long.parseLong(this.parseFirstValue(line)), Long.parseLong(this.parseSecondValue(line)));
                        dailySecondsUnnormalizMsieUsage_.add(tempDayLongPair);
                        atLeastOneDailyValueWasGiven = true;
                        line = globalsReader_.readLine();
                        continue;
                    }
                    stillDailyValuesAvailable = false;
                    if (!atLeastOneDailyValueWasGiven || DateUtils.getRealDateFromSecslong(tempDayLongPair.getDateSeconds()).equals(DateUtils.getDate())) continue;
                    tempDayLongPair = new DayLongPair(DateUtils.getSecondsAsLong(), 0L);
                    dailySecondsUnnormalizMsieUsage_.add(tempDayLongPair);
                }
                line = globalsReader_.readLine();
                stillDailyValuesAvailable = true;
                while (stillDailyValuesAvailable) {
                    if (line.indexOf("dailySecondsNormalizedMsieUsage_") != -1) {
                        tempDayLongPair = new DayLongPair(Long.parseLong(this.parseFirstValue(line)), Long.parseLong(this.parseSecondValue(line)));
                        dailySecondsNormalizedMsieUsage_.add(tempDayLongPair);
                        line = globalsReader_.readLine();
                        continue;
                    }
                    stillDailyValuesAvailable = false;
                    if (!atLeastOneDailyValueWasGiven || DateUtils.getRealDateFromSecslong(tempDayLongPair.getDateSeconds()).equals(DateUtils.getDate())) continue;
                    tempDayLongPair = new DayLongPair(DateUtils.getSecondsAsLong(), 0L);
                    dailySecondsNormalizedMsieUsage_.add(tempDayLongPair);
                }
                line = globalsReader_.readLine();
                stillDailyValuesAvailable = true;
                while (stillDailyValuesAvailable) {
                    if (line.indexOf("dailyNumberOfVisitsMsie_") != -1) {
                        tempDayIntPair = new DayIntPair(Long.parseLong(this.parseFirstValue(line)), Integer.parseInt(this.parseSecondValue(line)));
                        dailyNumberOfVisitsMsie_.add(tempDayIntPair);
                        line = globalsReader_.readLine();
                        continue;
                    }
                    stillDailyValuesAvailable = false;
                    if (!atLeastOneDailyValueWasGiven || DateUtils.getRealDateFromSecslong(tempDayIntPair.getDateSeconds()).equals(DateUtils.getDate())) continue;
                    tempDayIntPair = new DayIntPair(DateUtils.getSecondsAsLong(), 0);
                    dailyNumberOfVisitsMsie_.add(tempDayIntPair);
                }
                line = globalsReader_.readLine();
                stillDailyValuesAvailable = true;
                while (stillDailyValuesAvailable) {
                    if (line.indexOf("dailyNumberOfVisits_") != -1) {
                        tempDayIntPair = new DayIntPair(Long.parseLong(this.parseFirstValue(line)), Integer.parseInt(this.parseSecondValue(line)));
                        dailyNumberOfVisits_.add(tempDayIntPair);
                        line = globalsReader_.readLine();
                        continue;
                    }
                    stillDailyValuesAvailable = false;
                    if (!atLeastOneDailyValueWasGiven || DateUtils.getRealDateFromSecslong(tempDayIntPair.getDateSeconds()).equals(DateUtils.getDate())) continue;
                    tempDayIntPair = new DayIntPair(DateUtils.getSecondsAsLong(), 0);
                    dailyNumberOfVisits_.add(tempDayIntPair);
                }
                line = globalsReader_.readLine();
                rem1_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem2_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem3_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem4_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem5_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem6_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem7_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem8_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem9_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem10_ = line.substring(5, line.length());
                line = globalsReader_.readLine();
                rem11_ = line.substring(5, line.length());
            }
            catch (IOException ex) {
                System.out.println("IOExc " + ex.toString());
            }
        } else {
            System.out.println(" ERROR reading log files: versions not compatible");
        }
    }

    protected String parseValue(String line) {
        if (line != null) {
            String value = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
            return value;
        }
        return "";
    }

    protected String parseFirstValue(String line) {
        if (line != null) {
            String value = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
            return value;
        }
        return "";
    }

    protected String parseSecondValue(String line) {
        if (line != null) {
            String value = line.substring(line.indexOf("*") + 1, line.lastIndexOf("*"));
            return value;
        }
        return "";
    }

    public void writeEntry(WebObjectVisit wov, String caller) {
        if (loggerPlugin_.getProperties().get("Save URL and titel of pages").equals("false")) {
            this.println(wov.toEncryptedString());
            if (loggerPlugin_.getProperties().get("debug").equals("true")) {
                System.out.println(" ");
                System.out.println(" WRITE from: " + caller);
                System.out.println(wov.toDecoratedString());
                System.out.println("");
                System.out.println("");
            }
        } else if (loggerPlugin_.getProperties().get("Save URL and titel of pages").equals("true")) {
            this.println(wov.toNonencryptedString());
            if (loggerPlugin_.getProperties().get("debug").equals("true")) {
                System.out.println(" debug = true");
                System.out.println(" WRITE from: " + caller);
                System.out.println(wov.toDecoratedString());
                System.out.println("");
                System.out.println("");
            }
        } else {
            System.out.println("!!!! please specify \"Save URL and titel of pages\" property either with \"true\" or \"false\"");
        }
        this.resetTimer();
    }

    public void writeLOADED_BY_HYPERLINK(WebObject w, boolean openedToNewWindow) {
        this.println("MU_LOADED_BY_HYPERLINK, " + w.isFramePage() + " isFramePage, " + openedToNewWindow + " openedToNewWindow");
        this.resetTimer();
    }

    public void writeLOADED_BY_URL_ENTRY_OR_URLPOPUP(WebObject w) {
        this.println("MU_LOADED_BY_URL_ENTRY_OR_URLPOPUP, " + w.isFramePage() + " isFramePage");
        this.resetTimer();
    }

    private void resetTimer() {
        LoggerSconePlugin.useTimeMeasureTool_.startOver();
    }

    private void println(String s) {
        lastStringThatWasPrintedToLog_ = s;
        logStream_.println(s);
    }

    public boolean isCompatible() {
        if (this.readHeader()) {
            System.out.println("reader found... ");
            System.out.print("          ");
            return true;
        }
        System.out.println("\nWebChains: Couldn't find a compatible reader");
        AlertBox a = new AlertBox(null, new String[]{"Error!", "WebChains: Logfile kann nicht geschrieben werden!"});
        return false;
    }

    protected boolean readHeader() {
        boolean fileOneCompatible = false;
        boolean fileTwoCompatible = false;
        try {
            fileOneCompatible = globalsReader_.readLine().endsWith(versionNumber_);
        }
        catch (Exception ex) {
            System.out.println("BivAutologger couldn't read headers");
        }
        return fileOneCompatible;
    }

    static {
        LOGGING_PROTOCOL_FILE = "webchainsLogFileProtocol.csv";
        logReader_ = null;
        globalsReader_ = null;
        logStream_ = null;
        globalsStream_ = null;
        lastStringThatWasPrintedToLog_ = "";
        versionNumber_ = "LogFileWriter v0.9";
        totalSecondsUnnormalizMsieUsage_ = 0L;
        totalSecondsNormalizedMsieUsage_ = 0L;
        totalNumberOfVisitsMsie_ = 0;
        totalNumberOfVisits_ = 0;
        dailySecondsUnnormalizMsieUsage_ = new Vector();
        dailySecondsNormalizedMsieUsage_ = new Vector();
        dailyNumberOfVisitsMsie_ = new Vector();
        dailyNumberOfVisits_ = new Vector();
        rem1_ = "";
        rem2_ = "";
        rem3_ = "";
        rem4_ = "";
        rem5_ = "";
        rem6_ = "";
        rem7_ = "";
        rem8_ = "";
        rem9_ = "";
        rem10_ = "";
        rem11_ = "";
        runTimeInMillisSinceLastWriteMsie_ = 0L;
    }
}

