/*
 * Decompiled with CFR 0.152.
 */
package webchains.sessionlogger;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.SwingUtilities;
import scone.Plugin;
import scone.accesstracking.AppletConnector;
import scone.accesstracking.FrameAccess;
import scone.accesstracking2.AccessTracking;
import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import webchains.elements.FrameCapsule;
import webchains.elements.WebObject;
import webchains.elements.WebObjectVisit;
import webchains.sessionlogger.LogFileWriter;
import webchains.util.DateUtils;
import webchains.util.FrameTimer;
import webchains.util.UseTimeMeasureTool;

public class LoggerSconePlugin
extends Plugin
implements Observer {
    private static String loggerVersion_ = "0.1";
    private static long lastFrameLoadedMillis_ = 0L;
    protected static LogFileWriter logFileWriter_;
    public static UseTimeMeasureTool useTimeMeasureTool_;
    public static int visitsSinceLastWriteBiOn_;
    public static int visitsSinceLastWriteBiOf_;
    public static int visitsSinceLastWriteMsie_;
    public static int visitsSinceLastWrite_;
    private static long lastWriteTime_;
    private Hashtable activeWebObjectVisits_ = new Hashtable();
    private Hashtable frameCapsules_ = new Hashtable();
    private Hashtable frameTimers_ = new Hashtable();
    private static Hashtable openWindows_;
    public static final int ACCESSEVENT_1_IMMEDIATE_RESPONSE = 1;
    public static final int ACCESSEVENT_2_ACTION_IS_KNOWN = 2;
    public static final int ACCESSEVENT_3_STAYTIME_RETRIEVED = 3;
    private boolean debug_ = false;
    protected static String itemdelimiter_;
    private static Hashtable statusTable;

    public LoggerSconePlugin() {
        itemdelimiter_ = this.getProperties().get("ITEMDELIMITER");
        this.debug_ = this.getProperties().get("debug").equals("true");
    }

    public static String getItemDelimiter() {
        return itemdelimiter_;
    }

    public int getRequirements() {
        return 0x2100201;
    }

    public void init() {
        useTimeMeasureTool_ = new UseTimeMeasureTool(this);
        logFileWriter_ = new LogFileWriter(this);
        AccessCache.putObserver(this);
        LoggerSconePlugin.setLastWriteTimeNow();
    }

    public static String getLoggerVersion() {
        return loggerVersion_;
    }

    public static LogFileWriter getLogFileWriter() {
        return logFileWriter_;
    }

    public void update(Observable o, Object arg) {
        if (o instanceof AccessCache) {
            AccessEvent e = (AccessEvent)arg;
            if (e.getNode() == null) {
                if (DBTableAdapter.useDb()) {
                    // empty if block
                }
            } else {
                HtmlNode hNode = HtmlNodeCache.check(e.getNode());
                if ((e.getAccess().getAction() & 0x8000000) > 0) {
                    if (this.debug_) {
                        System.out.println("");
                    }
                    if (this.debug_) {
                        System.out.print("new Firefox Event: " + e.getAccess().getEvent());
                    }
                    WebObject wo = new WebObject(e.getNode());
                    WebObjectVisit wov = new WebObjectVisit(wo, this);
                    wov.setUser(e.getUser().getUserName());
                    wov.setEventType("Firefox");
                    wov.setLoadMethod(e.getAccess().getEvent());
                    wov.setStayDuration("");
                    wov.setWindowID(LoggerSconePlugin.getWindowIDString(e));
                    if (e.getNode().getSUri().getHexHashCodeofHost() != null) {
                        wo.setHashDomain(e.getNode().getSUri().getHexHashCodeofHost());
                        wo.setHashURL(e.getNode().getSUri().getHexHashCode());
                    } else {
                        wo.setHashDomain("");
                        wo.setHashURL("");
                    }
                    logFileWriter_.writeEntry(wov, "firef calls");
                } else {
                    WebObjectVisit tempwov;
                    if (!e.getAccess().getShown()) {
                        e.getAccess().setShown(true);
                        if (this.debug_) {
                            System.out.println("");
                        }
                        if (this.debug_) {
                            System.out.println("Sc Evnt: START ");
                        }
                        String username = "";
                        boolean isFramePage = false;
                        username = e.getUser() != null && !e.getUser().getUserId().equals("0") && !e.getUser().getUserName().equals("") ? e.getUser().getUserName() : e.getAccess().getUserId();
                        if (hNode != null) {
                            String windowIDString = "unknown window ID";
                            isFramePage = !e.getAccess().getParentFrameName().equals("");
                        } else {
                            if (this.debug_) {
                                System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXX PDF hier Type   : " + e.getNode().getMimeType());
                            }
                            if (this.debug_) {
                                System.out.println("");
                            }
                        }
                        WebObject wo = null;
                        WebObjectVisit wov = null;
                        if (!isFramePage) {
                            if (hNode != null) {
                                // empty if block
                            }
                            wo = new WebObject(e.getNode());
                            wov = new WebObjectVisit(wo, this);
                            this.fillWoWovWithParams(wo, wov, e, username);
                            this.activeWebObjectVisits_.put(LoggerSconePlugin.getWindowIDString(e), wov);
                            this.addWindowIDIfNotYetPresent(e);
                            this.increaseAndWriteVisits();
                        } else {
                            String parent = e.getAccess().getParentFrameName();
                            FrameCapsule fcexistent = (FrameCapsule)this.frameCapsules_.get(parent);
                            if (fcexistent == null) {
                                String refererURL = e.getAccess().getReferrerNode().toString();
                                String refererFILE = new String(refererURL);
                                if (refererFILE.endsWith("/")) {
                                    refererFILE = refererFILE.substring(0, refererFILE.length() - 1);
                                }
                                if ((refererFILE = refererFILE.substring(refererFILE.lastIndexOf("/") + 1, refererFILE.length())).endsWith(".html")) {
                                    refererFILE = refererFILE.substring(0, refererFILE.length() - 5);
                                } else if (refererFILE.endsWith(".htm")) {
                                    refererFILE = refererFILE.substring(0, refererFILE.length() - 4);
                                }
                                wo = new WebObject(refererURL, refererURL, refererFILE);
                                wov = new WebObjectVisit(wo, this);
                                this.fillWoWovWithParams(wo, wov, e, username);
                                FrameCapsule fc = new FrameCapsule(parent, wo);
                                fc.put(e.getAccess().getFrameName());
                                this.frameCapsules_.put(parent, fc);
                                if (this.frameTimers_.get(parent) != null) {
                                    this.frameTimers_.remove(parent);
                                }
                                FrameTimer ft = new FrameTimer(parent, this.frameCapsules_);
                                this.frameTimers_.put(parent, ft);
                                this.activeWebObjectVisits_.put(LoggerSconePlugin.getWindowIDString(e), wov);
                                this.addWindowIDIfNotYetPresent(e);
                                this.increaseAndWriteVisits();
                            } else {
                                fcexistent.put(e.getAccess().getFrameName());
                                FrameTimer ft = (FrameTimer)this.frameTimers_.get(parent);
                                if (ft != null) {
                                    ft.startOver();
                                    System.out.println("TTT ft startover zu: " + parent);
                                } else {
                                    System.out.println("TTT ft FEHLT zu: " + parent);
                                }
                            }
                        }
                        if (!e.getAccess().getReferrerNodeId().equals("")) {
                            NetNode referrer = NetNodeCache.getById(e.getAccess().getReferrerNodeId());
                            String refString = "";
                            refString = referrer == null ? e.getAccess().getReferrerNodeId() : referrer.toString();
                            if (wov != null) {
                                wov.setReferer(refString);
                            }
                        }
                        String actionString = "";
                        if ((e.getAccess().getAction() & 1) > 0) {
                            actionString = actionString + " link";
                        }
                        if ((e.getAccess().getAction() & 2) > 0) {
                            actionString = actionString + " #fragment";
                        }
                        if ((e.getAccess().getAction() & 8) > 0) {
                            actionString = actionString + " submit";
                        }
                        if ((e.getAccess().getAction() & 0x10) > 0) {
                            actionString = actionString + " reloaded";
                        }
                        if ((e.getAccess().getAction() & 0x20) > 0) {
                            actionString = actionString + " back";
                        }
                        if ((e.getAccess().getAction() & 0x40) > 0) {
                            actionString = actionString + " next";
                        }
                        if ((e.getAccess().getAction() & 0x100) > 0) {
                            actionString = actionString + " new window";
                        }
                        if ((e.getAccess().getAction() & 0x4000) > 0) {
                            actionString = actionString + " new frame";
                        }
                        if ((e.getAccess().getAction() & 0x8000) > 0) {
                            actionString = e.getAccess().getParentFrameName().equals("") ? actionString + " typed URL or Bookmark" : actionString + " frame load";
                        }
                        System.out.println(actionString);
                        if (wov != null) {
                            wov.setLoadMethod(actionString);
                            if (e.getAccess().getPost() != null && !e.getAccess().getPost().equals("")) {
                                wov.setPostPart(e.getAccess().getPost());
                            }
                            if (e.getAccess().getQuery() != null && !e.getAccess().getQuery().equals("")) {
                                wov.setGetPart(e.getAccess().getQuery());
                            }
                        }
                    }
                    if (e.getAccess().getLoadTime() != 0L && (e.getAccess().getStayTime() == 0L || AccessTracking.props.get("Create extra event after page is loaded").equals("false"))) {
                        if (this.debug_) {
                            System.out.println("");
                        }
                        if (this.debug_) {
                            System.out.print("new Scone Event: #2 Event load time ");
                        }
                        if (e.getAccess().getParentFrameName() != null && e.getAccess().getParentFrameName().equals("")) {
                            tempwov = (WebObjectVisit)this.activeWebObjectVisits_.get(LoggerSconePlugin.getWindowIDString(e));
                            if (tempwov != null) {
                                tempwov.setLoadDuration(Long.toString(e.getAccess().getLoadTime()));
                                if (hNode != null) {
                                    tempwov.setFingerprint(hNode.getFingerprint());
                                }
                            }
                        }
                    }
                    if (e.getAccess().getStayTime() != 0L) {
                        if (this.debug_) {
                            System.out.println("");
                        }
                        if (this.debug_) {
                            System.out.println("Sc Evnt: STAY Event ");
                        }
                        if (e.getAccess().getParentFrameName().equals("")) {
                            tempwov = (WebObjectVisit)this.activeWebObjectVisits_.get(LoggerSconePlugin.getWindowIDString(e));
                            if (tempwov != null) {
                                this.activeWebObjectVisits_.remove(LoggerSconePlugin.getWindowIDString(e));
                                if (this.debug_) {
                                    System.out.println(" RRR : remove " + LoggerSconePlugin.getWindowIDString(e));
                                }
                                tempwov.setStayDuration(Long.toString(e.getAccess().getStayTime()));
                                if (hNode != null) {
                                    tempwov.getWebObject().setNumOfOutgoingLinks(Integer.parseInt(hNode.getNumberOfLinks()));
                                    tempwov.getWebObject().setNumOfOutgoingExternalLinks(Integer.parseInt(hNode.getNumberOfExternalLinks()));
                                    tempwov.getWebObject().setNumOfParagraphs(Integer.parseInt(hNode.getNumberOfParagraphs()));
                                    tempwov.getWebObject().setNumOfWords(Integer.parseInt(hNode.getNumberOfWords()));
                                    if (hNode != null) {
                                        tempwov.getWebObject().setTitle(hNode.getTitle());
                                    } else {
                                        tempwov.getWebObject().setTitle(hNode.getFile());
                                    }
                                }
                                logFileWriter_.writeEntry(tempwov, "kind #3: stay / NO frame");
                                this.launchWindowClosedTestTimer(e);
                            }
                        } else {
                            tempwov = (WebObjectVisit)this.activeWebObjectVisits_.get(LoggerSconePlugin.getWindowIDString(e));
                            if (tempwov != null) {
                                this.activeWebObjectVisits_.remove(LoggerSconePlugin.getWindowIDString(e));
                                this.frameCapsules_.remove(e.getAccess().getParentFrameName());
                                tempwov.setStayDuration(Long.toString(e.getAccess().getStayTime()));
                                if (!tempwov.getWebObject().getOriginalURL().equals(":")) {
                                    logFileWriter_.writeEntry(tempwov, "kind #3: stay / F R A M E");
                                    this.launchWindowClosedTestTimer(e);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void saveUnsavedVisitsInThisWindowIfExistent(AccessEvent e) {
        String windowID = LoggerSconePlugin.getWindowIDString(e);
        WebObjectVisit tempwov = (WebObjectVisit)this.activeWebObjectVisits_.get(windowID);
        if (tempwov != null) {
            this.activeWebObjectVisits_.remove(windowID);
            logFileWriter_.writeEntry(tempwov, "#1, #2, or #3 event - saveUnsavedV - es gab keinen stay vorher");
            this.launchWindowClosedTestTimer(e);
        }
    }

    protected void increaseAndWriteVisits() {
        ++visitsSinceLastWriteMsie_;
        ++visitsSinceLastWrite_;
        useTimeMeasureTool_.startOver();
    }

    public static String getWindowIDString(AccessEvent e) {
        String windowIDString = "";
        windowIDString = !e.getAccess().getParentFrameName().equals("") ? e.getAccess().getParentFrameName() : e.getAccess().getFrameName();
        return windowIDString;
    }

    public static long getLastWriteTime() {
        return lastWriteTime_;
    }

    public static void setLastWriteTimeNow() {
        lastWriteTime_ = DateUtils.getSecondsAsLong();
    }

    protected void addWindowIDIfNotYetPresent(AccessEvent e) {
        String windowIDString = LoggerSconePlugin.getWindowIDString(e);
        if (!openWindows_.containsKey(windowIDString)) {
            openWindows_.put(windowIDString, e.getAccess());
        }
    }

    protected static String getOpenWindowsAsString() {
        Access a;
        Enumeration win = openWindows_.elements();
        String allWindowsString = "";
        if (win.hasMoreElements()) {
            a = (Access)win.nextElement();
            allWindowsString = a.getFrameName();
        }
        while (win.hasMoreElements()) {
            a = (Access)win.nextElement();
            allWindowsString = allWindowsString + ", " + a.getFrameName();
        }
        return allWindowsString;
    }

    protected void launchWindowClosedTestTimer(AccessEvent e) {
        final String windowIDString = LoggerSconePlugin.getWindowIDString(e);
        final AccessEvent etest = e;
        try {
            Thread.sleep(15000L);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FrameAccess fa = FrameAccess.getInstance();
                    Set openWindows = fa.getSetOfContents();
                    Iterator iter = openWindows.iterator();
                    boolean found = false;
                    while (iter.hasNext()) {
                        String entry = (String)iter.next();
                        AppletConnector ac = FrameAccess.getInstance().get(entry);
                        if (ac == null) {
                            System.out.println("  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ac == NULL! remove ");
                            LoggerSconePlugin.removeWindowIDIfPresent(entry);
                        } else if (!ac.testIsAppletExistent()) {
                            System.out.println("  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ac.test == FALSE! remove ");
                            LoggerSconePlugin.removeWindowIDIfPresent(entry);
                        }
                        if (entry.indexOf(windowIDString) == -1) continue;
                        found = true;
                    }
                    if (!found) {
                        LoggerSconePlugin.removeWindowIDIfPresent(LoggerSconePlugin.getWindowIDString(etest));
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            System.out.println("InterruptedException " + ex.toString());
        }
    }

    protected static void removeWindowIDIfPresent(String windowIDString) {
        if (openWindows_.containsKey(windowIDString)) {
            openWindows_.remove(windowIDString);
        }
    }

    private static int determineKindOfAccessEvent(AccessEvent e) {
        int returnvalue = -1;
        returnvalue = e.getAccess().getAction() == 0 ? 1 : (e.getAccess().getStayTime() == 0L ? 2 : (e.getAccess().getStayTime() != 0L ? 3 : 110));
        return returnvalue;
    }

    public static UseTimeMeasureTool getUseTimeMeasureTool() {
        return useTimeMeasureTool_;
    }

    private String getEventType(AccessEvent e) {
        String retstr = "unknown event type";
        if ((e.getAccess().getAction() & 0x8000000) > 0) {
            retstr = "firefox";
        }
        if ((e.getAccess().getAction() & 0x10000000) > 0) {
            retstr = "ms_explorer";
        }
        if ((e.getAccess().getAction() & 0x20000000) > 0) {
            retstr = "gecko";
        }
        return retstr;
    }

    private String getLinkType(AccessEvent e) {
        String retstr = "";
        if (e.getAccess().getLinkType() != 0) {
            if ((e.getAccess().getLinkType() & 1) > 0) {
                retstr = retstr + "sameDocument ";
            }
            if ((e.getAccess().getLinkType() & 2) > 0) {
                retstr = retstr + "fragment ";
            }
            if ((e.getAccess().getLinkType() & 4) > 0) {
                retstr = retstr + "query ";
            }
            if ((e.getAccess().getLinkType() & 0x40) > 0) {
                retstr = retstr + "external ";
            }
            if ((e.getAccess().getLinkType() & 0x80) > 0) {
                retstr = retstr + "internal ";
            }
            if ((e.getAccess().getLinkType() & 0x400) > 0) {
                retstr = retstr + "fromHome ";
            }
            if ((e.getAccess().getLinkType() & 0x800) > 0) {
                retstr = retstr + "toHome ";
            }
            if ((e.getAccess().getLinkType() & 0x4000) > 0) {
                retstr = retstr + "down ";
            }
            if ((e.getAccess().getLinkType() & 0x8000) > 0) {
                retstr = retstr + "up ";
            }
            if ((e.getAccess().getLinkType() & 0x100000) > 0) {
                retstr = retstr + "sameCluster ";
            }
            if ((e.getAccess().getLinkType() & 0x200000) > 0) {
                retstr = retstr + "fromIndex ";
            }
            if ((e.getAccess().getLinkType() & 0x400000) > 0) {
                retstr = retstr + "toIndex ";
            }
            if ((e.getAccess().getLinkType() & 0x1000000) > 0) {
                retstr = retstr + "noHTTP ";
            }
            if ((e.getAccess().getLinkType() & 0x2000000) > 0) {
                retstr = retstr + "noHTML ";
            }
        }
        return retstr;
    }

    private void fillWoWovWithParams(WebObject wo, WebObjectVisit wov, AccessEvent e, String username) {
        if (e.getNode().getSUri().getHexHashCodeofHost() != null) {
            wo.setHashDomain(e.getNode().getSUri().getHexHashCodeofHost());
            wo.setHashURL(e.getNode().getSUri().getHexHashCode());
        } else {
            wo.setHashDomain("");
            wo.setHashURL("");
        }
        wov.setUser(username);
        wov.setClickPos(e.getAccess().getLinkPos());
        wov.setWindowSize(e.getAccess().getLastWindowSize());
        if (!e.getAccess().getLinkAnchor().equals("")) {
            wov.setAnchorText(e.getAccess().getLinkAnchor());
        } else {
            wov.setAnchorText(" ");
        }
        wov.setEventType(this.getEventType(e));
        wov.setLinkType(this.getLinkType(e));
        wov.setHistorySteps(e.getAccess().getStepsInHistory() + " ");
        if ((e.getAccess().getAction() & 0x40000000) > 0) {
            wov.setUncertainty("1");
        } else {
            wov.setUncertainty(" ");
        }
        wov.setWindowID(LoggerSconePlugin.getWindowIDString(e));
    }

    static {
        visitsSinceLastWriteBiOn_ = 0;
        visitsSinceLastWriteBiOf_ = 0;
        visitsSinceLastWriteMsie_ = 0;
        visitsSinceLastWrite_ = 0;
        lastWriteTime_ = DateUtils.getSecondsAsLong();
        openWindows_ = new Hashtable();
        itemdelimiter_ = "";
        statusTable = new Hashtable();
        statusTable.put(new String(""), new String(""));
        statusTable.put(new String("-1"), new String(""));
        statusTable.put(new String("100"), new String("Continue"));
        statusTable.put(new String("101"), new String("Switching Protocols"));
        statusTable.put(new String("200"), new String("OK"));
        statusTable.put(new String("201"), new String("Created"));
        statusTable.put(new String("202"), new String("Accepted"));
        statusTable.put(new String("203"), new String("Non-Authoritative Information"));
        statusTable.put(new String("204"), new String("No Content"));
        statusTable.put(new String("205"), new String("Reset Content"));
        statusTable.put(new String("206"), new String("Partial Content"));
        statusTable.put(new String("300"), new String("Multiple Choices"));
        statusTable.put(new String("301"), new String("Moved Permanently"));
        statusTable.put(new String("302"), new String("Moved Temporarily"));
        statusTable.put(new String("303"), new String("See Other"));
        statusTable.put(new String("304"), new String("Not Modified (Document unchanged since last request)"));
        statusTable.put(new String("305"), new String("Use Proxy"));
        statusTable.put(new String("400"), new String("Bad Request (Server name unknown)"));
        statusTable.put(new String("401"), new String("Unauthorized (Password required)"));
        statusTable.put(new String("402"), new String("Payment Required"));
        statusTable.put(new String("403"), new String("Forbidden (Access to document denied)"));
        statusTable.put(new String("404"), new String("Not Found (Document was deleted)"));
        statusTable.put(new String("405"), new String("Method Not Allowed"));
        statusTable.put(new String("406"), new String("None Acceptable"));
        statusTable.put(new String("407"), new String("Proxy Authentication Required"));
        statusTable.put(new String("408"), new String("Request Timeout (Server doesn't repond / server down)"));
        statusTable.put(new String("409"), new String("Conflict"));
        statusTable.put(new String("410"), new String("Gone"));
        statusTable.put(new String("411"), new String("Length Required"));
        statusTable.put(new String("412"), new String("Precondition Failed"));
        statusTable.put(new String("413"), new String("Request Entity Too Large"));
        statusTable.put(new String("414"), new String("Request URI Too Large"));
        statusTable.put(new String("415"), new String("Unsupported Media Type"));
        statusTable.put(new String("500"), new String("Internal Server Error"));
        statusTable.put(new String("501"), new String("Not Implemented"));
        statusTable.put(new String("502"), new String("Bad Gateway"));
        statusTable.put(new String("503"), new String("Service Unavailable"));
        statusTable.put(new String("504"), new String("Gateway Timeout"));
        statusTable.put(new String("505"), new String("HTTP Version Not Supported (Maybe try other browser)"));
    }
}

