/*
 * Decompiled with CFR 0.152.
 */
package webchains.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    protected static SimpleDateFormat onlyDayDateFormat_ = new SimpleDateFormat("d MMM yyyy");
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static SimpleDateFormat outFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getDate() {
        return DateUtils.getFormattedString(DEFAULT_DATE_PATTERN);
    }

    public static String getDate(long millisecs) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        Date controlDate = new Date();
        controlDate.setTime(millisecs);
        String retstr = DateUtils.toWeekday(controlDate.getDay()) + " " + simpleFormat.format(controlDate);
        return retstr;
    }

    public static String getVirtualDate1970FromSecslong(long millisecs) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_PATTERN);
        simpleFormat.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        Date controlDate = new Date();
        controlDate.setTime(millisecs);
        String retstr = simpleFormat.format(controlDate);
        return retstr;
    }

    public static String getRealDateAndTimeFromSecslong(long millisecs) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
        Date controlDate = new Date();
        controlDate.setTime(millisecs);
        String retstr = DateUtils.toWeekday(controlDate.getDay()) + "  " + simpleFormat.format(controlDate);
        return retstr;
    }

    public static String getRealTimeFromSecslong(long millisecs) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_TIME_PATTERN);
        Date controlDate = new Date();
        controlDate.setTime(millisecs);
        String retstr = simpleFormat.format(controlDate);
        return retstr;
    }

    public static String getRealDateFromSecslong(long millisecs) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        Date controlDate = new Date();
        controlDate.setTime(millisecs);
        String retstr = simpleFormat.format(controlDate);
        return retstr;
    }

    private static String toWeekday(int day) {
        String retstr = "";
        switch (day) {
            case 0: {
                retstr = "Sun";
                break;
            }
            case 1: {
                retstr = "Mon";
                break;
            }
            case 2: {
                retstr = "Tue";
                break;
            }
            case 3: {
                retstr = "Wed";
                break;
            }
            case 4: {
                retstr = "Thu";
                break;
            }
            case 5: {
                retstr = "Fri";
                break;
            }
            case 6: {
                retstr = "Sat";
                break;
            }
            default: {
                retstr = "unknown_weekday";
            }
        }
        return retstr;
    }

    public static String getSeconds() {
        return Long.toString(System.currentTimeMillis());
    }

    public static long getSecondsAsLong() {
        return System.currentTimeMillis();
    }

    public static String getTime() {
        return DateUtils.getFormattedString(DEFAULT_TIME_PATTERN);
    }

    public static String getDate(String datePattern) {
        return DateUtils.getFormattedString(datePattern);
    }

    public static String getTime(String timePattern) {
        return DateUtils.getFormattedString(timePattern);
    }

    private static String getFormattedString(String pattern) {
        outFormat.applyPattern(pattern);
        outFormat.setTimeZone(TimeZone.getTimeZone("GMT+02:00"));
        Date date = new Date(System.currentTimeMillis());
        String s = outFormat.format(date);
        return s;
    }

    public static void main(String[] args) {
    }

    public static String getHoursBySecsOfTheDay(long millisecs) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat("H:mm:ss");
        simpleFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date controlDate = new Date();
        controlDate.setTime(millisecs);
        String retstr = simpleFormat.format(controlDate);
        return retstr;
    }

    public static long getSecsBetweenTwoDates(Date begin, Date end) {
        return end.getTime() - begin.getTime();
    }
}

