/*
 * Decompiled with CFR 0.152.
 */
package webchains.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;

public class ErrorLog {
    private static PrintStream out = null;
    protected static boolean catchesErr = false;

    public static void setOutputStream(OutputStream out) {
        ErrorLog.out = new PrintStream(out);
    }

    public static void catchErr() {
        System.setErr(out);
        catchesErr = true;
    }

    public static void releaseErr() {
        System.setErr(System.out);
        catchesErr = false;
    }

    public static void standardInit() {
        try {
            out = new PrintStream(new FileOutputStream("log/webchains/errors.log"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void print(Object o) {
        try {
            out.print(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void println(Object o) {
        try {
            out.println(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Object obj, String method, String msg, Exception e) {
        String date = new Date().toString();
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println("------Exception-------------------------------------");
            out.println("time:    " + date);
            out.println("class:   " + obj.getClass().getName());
            out.println("object:  " + obj.toString());
            out.println("method:  " + method);
            out.println("message:\n" + msg + "\n");
            if (catchesErr) {
                e.printStackTrace();
            } else {
                e.printStackTrace(out);
            }
            out.println("----------------------------------------------------\n");
        }
    }

    static {
        ErrorLog.standardInit();
    }
}

