/*
 * Decompiled with CFR 0.152.
 */
package webchains.util;

import java.io.FileReader;
import java.io.Reader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLHelper {
    public static void main(String[] args) throws Exception {
        Document dom = XMLHelper.parseReader(new FileReader("test.xml"));
        XMLHelper.printNodeStructure(dom, "");
    }

    public static Document parseReader(Reader reader) throws Exception {
        DOMParser parser = new DOMParser();
        parser.parse(new InputSource(reader));
        return parser.getDocument();
    }

    public static void printNodeStructure(Node node, String indent) {
        if (node == null) {
            return;
        }
        indent = indent + "   ";
        NodeList children = node.getChildNodes();
        for (int iChild = 0; iChild < children.getLength(); ++iChild) {
            XMLHelper.printNodeStructure(children.item(iChild), indent);
        }
    }

    public static Node getAttribute(String name, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.item(i).getNodeName().equals(name)) continue;
            return attributes.item(i);
        }
        return null;
    }

    public static Node getChild(String name, Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return null;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equals(name)) continue;
            return children.item(i);
        }
        return null;
    }
}

