#include <Guiddef.h>
#include <ShlGuid.h>
#include <wininet.h>

//
// Delete all files in the Temporary Internet Files folder
// 

BOOL DelTempFiles() 
{
  BOOL bResult = FALSE;
  BOOL bDone = FALSE;
  LPINTERNET_CACHE_ENTRY_INFO lpCacheEntry = NULL;  
  
  DWORD  dwTrySize, dwEntrySize = 4096; // start buffer size    
  HANDLE hCacheDir = NULL;    
  DWORD  dwError = ERROR_INSUFFICIENT_BUFFER;
  
  do 
  {                               
	switch (dwError)
	{
	  // bigger buffer needed
	case ERROR_INSUFFICIENT_BUFFER: 
	  delete [] lpCacheEntry;            
	  lpCacheEntry = (LPINTERNET_CACHE_ENTRY_INFO) new char[dwEntrySize];
	  lpCacheEntry->dwStructSize = dwEntrySize;
	  dwTrySize = dwEntrySize;
	  BOOL bSuccess;
	  if (hCacheDir == NULL)                
		
		bSuccess = (hCacheDir 
		= FindFirstUrlCacheEntry(NULL, lpCacheEntry,
		&dwTrySize)) != NULL;
	  else
		bSuccess = FindNextUrlCacheEntry(hCacheDir, lpCacheEntry, &dwTrySize);
	  
	  if (bSuccess)
		dwError = ERROR_SUCCESS;    
	  else
	  {
		dwError = GetLastError();
		dwEntrySize = dwTrySize; // use new size returned
	  }
	  break;
	  
	  // we are done
	case ERROR_NO_MORE_ITEMS:
	  bDone = TRUE;
	  bResult = TRUE;                
	  break;
	  
	  // we have got an entry
	case ERROR_SUCCESS:                       
	  
	  // don't delete cookie entry
	  if (!(lpCacheEntry->CacheEntryType & COOKIE_CACHE_ENTRY))                
		
		DeleteUrlCacheEntry(lpCacheEntry->lpszSourceUrlName);
	  
	  // get ready for next entry
	  dwTrySize = dwEntrySize;
	  if (FindNextUrlCacheEntry(hCacheDir, lpCacheEntry, &dwTrySize))
		dwError = ERROR_SUCCESS;          
	  
	  else
	  {
		dwError = GetLastError();
		dwEntrySize = dwTrySize; // use new size returned
	  }                    
	  break;
	  
	  // unknown error
	default:
	  bDone = TRUE;                
	  break;
	}
	
	if (bDone)
	{   
	  delete [] lpCacheEntry; 
	  if (hCacheDir)
		FindCloseUrlCache(hCacheDir);         
	  
	}
  } while (!bDone);
  return bResult;
}

void main() {
  DelTempFiles();
}