#include <Guiddef.h>
#include <ShlGuid.h>
#include <UrlHist.h>

// Delete all items in History folder
HRESULT ClearHistory() 
{
    IUrlHistoryStg2* pUrlHistoryStg2 = NULL;
    CoInitialize(NULL);

    HRESULT hr = CoCreateInstance(CLSID_CUrlHistory, NULL, CLSCTX_INPROC_SERVER, 
        IID_IUrlHistoryStg2, reinterpret_cast<void**>(&pUrlHistoryStg2)); 

    if (SUCCEEDED(hr))
    {         
        hr = pUrlHistoryStg2->ClearHistory(); 
        pUrlHistoryStg2->Release();
    }

    CoUninitialize();

    return hr;
}

HRESULT main() {
  return ClearHistory();
}

/*
 Getting IE History items

--------------------------------------------------------------------------------
You can use IUrlHistoryStg2 interface. There is a brief description step by step: 
(1) #include directives 
#include <shlguid.h> // needed for CLSID_CUrlHistory 
#include <urlhist.h> // needed for IUrlHistoryStg2 and IID_IUrlHistoryStg2 
#include "comdef.h" 

(2) objects and variables 
IUrlHistoryStg2* pHistory; // IE History interface 
IEnumSTATURL* pEnumUrls; // enumerated URLs 
STATURL StatUrl[1]; // structure containing information about URLs 
HRESULT hr; 
ULONG ulFetched; 
int iCount; // number of enumerated URLs 
_bstr_t bstrUrl; 
_bstr_t bstrTitle; 
COleDateTime odtExpires; 
COleDateTime odtLastUpdated; 
COleDateTime odtLastVisited; 

(3) IE History interface preparing and releasing 
CoInitialize(NULL); 
hr = CoCreateInstance(CLSID_CUrlHistory, NULL, CLSCTX_INPROC_SERVER, 
IID_IUrlHistoryStg2, reinterpret_cast<void**>(&pHistory)); 
if (SUCCEEDED(hr)) 
{ // IE History interface is at one's disposal 
// ... see point (4) or (6) ... 

pHistory->Release(); // release our reference 
} 
CoUninitialize(); 

(4) getting list of enumerated URLs 
hr = pHistory->EnumUrls(&pEnumUrls); 
if (SUCCEEDED(hr)) 
{ // list of enumerated URLs is at one's disposal 
// ... see point (5) ... 

pEnumUrls->Release(); 
} 

(5) reading information about all the enumerated URLs 
while ((hr = pEnumUrls->Next(1, StatUrl, &ulFetched)) == S_OK) 
{ 
iCount++; 
if (StatUrl[0].pwcsUrl != NULL) 
{ 
bstrUrl = StatUrl[0].pwcsUrl; 
} 
if (StatUrl[0].pwcsTitle != NULL) 
{ 
bstrTitle = StatUrl[0].pwcsTitle; 
} 
odtExpires = StatUrl[0].ftExpires; 
odtLastUpdated = StatUrl[0].ftLastUpdated; 
odtLastVisited = StatUrl[0].ftLastVisited; 
// use the following code to obtaining CString values from COleDateTime values: 
//CString csExpires = odtExpires.Format("%d.%m.%y"); 
//CString csLastUpdated = odtLastUpdated.Format("%d.%m.%y"); 
//Cstring csLastVisited = odtLastVisited.Format("%d.%m.%y"); 
 
} 

(6) deleting URL(s) from IE History list 

// deleting one URL: 
// Note: bstrUrl must contain an URL which should be deleted 
hr = pHistory->DeleteUrl(bstrUrl, 0); 

// deleting whole IE History list: 
hr = pHistory->ClearHistory(); 
*/