package com.ibm.wbi.protocol.http.beans;

import java.io.*;
import java.net.SocketException;

public class FileGeneratorHelper
{

    public FileGeneratorHelper(String s)
    {
        filename = s;
        file = new File(filename);
    }

    public FileGeneratorHelper(File file1)
    {
        file = file1;
        filename = file1.getAbsolutePath();
    }

    public FileGeneratorHelper(FileGeneratorHelper filegeneratorhelper, String s)
    {
        if(!filegeneratorhelper.isDirectory())
        {
            filename = "";
            file = new File(filename);
        } else
        {
            file = new File(filegeneratorhelper.file, s);
            filename = file.getAbsolutePath();
        }
    }

    public boolean exists()
    {
        return file.exists();
    }

    public long length()
    {
        return file.length();
    }

    public boolean isDirectory()
    {
        return file.isDirectory();
    }

    public File getFile()
    {
        return file;
    }

    public void writeData(OutputStream outputstream)
    {
        try
        {
            FileInputStream fileinputstream = new FileInputStream(file);
            byte abyte0[] = new byte[1024];
            int i;
            while((i = fileinputstream.read(abyte0)) != -1) 
                outputstream.write(abyte0, 0, i);
            fileinputstream.close();
            outputstream.close();
        }
        catch(SocketException socketexception)
        {
            ;
//            System.err.println("FileGeneratorHelper::writeData -- SocketException while copying file");
//            System.err.println("Client closed socket too recently.");
//            socketexception.printStackTrace();
        }
        catch(IOException ioexception)
        {
            System.err.println("FileGeneratorHelper::writeData -- IOException while copying file");
            ioexception.printStackTrace();
        }
    }

    public static final String COPYRIGHT = " (C) Copyright IBM Corp. 1999, 2000. All Rights Reserved. ";
    String filename;
    File file;
}