// JavaScript code for Linktool of HyperScou2.

// Identify Browser
var isNS4 = (document.layers) ? 1 : 0;
var isIE4 = (document.all) ? 1 : 0;
// Are CSS enabled?
//var style = ((isNS4 && document.testCSS) || isIE4) ? 1 : 0;
var style = (isNS4 || isIE4) ? 1 : 0;

// Parameters
var hs_openDelay     = 800;   // ms delay before opening popup
var hs_reOpenTimeout = 500;   // ms re-open within this time.
var hs_showDelay     = 200;   // mouse hold still for 200ms before showing popup.

// Timers for delayed opening and immediate reopening of popups
var hs_openTimer   = null;    // Wait before opening popups...
var hs_readyToShow = false;
var hs_showTimer   = null;    // No mousemovement before display of popup
var hs_popup       = null;    // Id of link for popup.
var hs_visible     = false;   // Is popup visible?

// This function is called, if a mouse is moved over a link
// it will activate a popup after an appropriate time.
function hs_activate(e,id)
{
//    _logMessage("link touched: "+id);  // Only for use with evaluator!!!
	if (!style) return;
	hs_popup = id;
	if (isNS4) document.captureEvents(Event.MOUSEMOVE);
	document.onmousemove = hs_checkMouseMove;
	if (!hs_openTimer && hs_readyToShow==false) // Is there no timer any more? -> No ReOpen
   {	// No: New timer, set to true after long time...
      hs_openTimer = setTimeout("hs_readyToShow=true",hs_openDelay); // Set timer.
   }
   else
	{ clearTimeout(hs_openTimer); hs_openTimer=null; }
	if (isIE4)  hs_checkMouseMove(e);  // NS: this event has sometimes false screenX and screenY coordinates
}

// this function checks if the mouse was not moved for some ms if it is over a link.
function hs_checkMouseMove(e)
{
   if (!hs_popup) return;       // Popup id available? (Just to be sure!)
   if (hs_visible) return;      // Popup already visible.
	var left = (isNS4) ? e.screenX : event.screenX;
	var top  = (isNS4) ? e.screenY : event.screenY;
   var delay = hs_showDelay;  // No reopen: wait long
   if (!hs_readyToShow) delay=hs_openDelay;  // reopen: short.
	if (hs_showTimer)    // if mouse was moved, start waiting again...
		{ clearTimeout(hs_showTimer); hs_showTimer=null; }
   // Mouse has to be unmoved for "delay" ms before showing popus
   hs_showTimer = setTimeout("hs_showPopup("+left+", "+top+")",delay);
}

// finally show the popup
function hs_showPopup(left,top)
{
//    _logMessage("popup displayed: "+hs_popup);  // Only for use with evaluator!!!
  	document.applets["displayapplet"].display(hs_popup+"",left,top,screen.width,screen.height);
	hs_visible		= true;	// popup is visible!
	if (hs_openTimer) { clearTimeout(hs_openTimer); hs_openTimer=null; }
	hs_readyToShow=true;
}

// Make the layer disapper, after the mouse leaves a link.
function hs_deactivate()
{
	if (!style) return;	// CSS enabled?
	if (hs_showTimer)    // stop showing popup...
		{ clearTimeout(hs_showTimer); hs_showTimer=null; }
  	document.displayapplet.hide();  // hide all popups...
//    _logMessage("popup hidden");  // Only for use with evaluator!!!
   // Delete showtimer: Do not open other popup
	hs_popup = null;
   
	if (isNS4) document.releaseEvents(Event.MOUSEMOVE);
	document.onmousemove=null;
   // delete old opentimer
	if (hs_openTimer) { clearTimeout(hs_openTimer); hs_openTimer=null; }
   // New opentimer
   if (hs_visible)    hs_openTimer = setTimeout("hs_readyToShow=false",hs_reOpenTimeout); 
	hs_visible		= false;
}
