package evaluator.departureexperiment;


import java.awt.Dimension;

import javax.swing.Box;

import evaluator.util.ContentGeneratorInterface;
import evaluator.util.EvaluatorFrame;
import evaluator.util.ExperimentController;
import evaluator.util.OptionsBox;
import evaluator.util.StartButton;
import evaluator.util.StopButton;
import evaluator.util.TaskGroup;
import evaluator.util.TaskPanel;
import evaluator.util.TextEntryBox;


/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @version 1.0
 */

public class ContentGeneratorForDepartureExperiment1 implements ContentGeneratorInterface {
    private EvaluatorFrame _evaluatorFrame;
    private scone.Plugin         _plugin;

    public ContentGeneratorForDepartureExperiment1() {
        _evaluatorFrame = null;
        _plugin = null;
    }
  
    public void init(EvaluatorFrame evaluatorFrame, scone.Plugin plugin) {
        _evaluatorFrame = evaluatorFrame;
        _plugin = plugin;
    }

    public void generate(ExperimentController experiment) {
        long subjectNumber = experiment.getSubjectNumber();
        TaskPanel panel;
        TaskGroup taskGroup;

        StartButton  start;
        StopButton   stop; 
        TextEntryBox teb;

        // ===================================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        panel.addBoldText("<html><font size=+2>Willkommen bei unserer Studie zur Visualisierung von Links!</font>");
        panel.addText(" ");
        panel.addText("Wir mchten verschiedene Arten fr die Visualisierungen von Links daraufhin testen, wie gut sie benutzbar sind.");
        panel.addText("Zunchst wird in einer kleinen Einfhrung die erste von drei Varianten vorgestellt:");
        panel.addText(" ");
        panel.addText("Die Links werden mit farbigem Hintergrund dargestellt.");
        panel.addText(" ");
        panel.addText("Um einen kleinen Eindruck vom Ablauf der Studie zu erhalten, gibt es gleich eine Einfhrungsaufgabe.");
        panel.addText(" ");
        panel.addBoldText("Vorgehen");
        panel.addText("1. Jede Aufgabe wird mit dem Start-Knopf unten gestartet.");
        panel.addText("    Daraufhin wird der Webbrowser erscheinen und eine Webseite laden.");
        panel.addText("    Von dieser Seite aus soll nun eine Antwort auf die hier gestellte Frage gefunden werden.");
        panel.addText(" ");
        panel.addText("2. Wenn Du das Gefhl hast, die Antwort gefunden zu haben, wechsele zurck zu diesem Tool.");
        panel.addText("    Dafr klicke am unterne Bildschirmrand auf das blau-orange \"E\" (E wie Evaluator).");
        panel.addText("    Achtung: Bitte schliee den Web-Browser nicht!");
        panel.addText(" ");
        panel.addText("3. Dann drcke den Stop-Knopf und gib die Antwort auf die Frage in den weien Kasten ein.");
        panel.addText(" ");
        panel.addText("4. Zur nchsten Aufgabe kommst Du mit dem Weiter-Knopf.");
        panel.addText(" ");
        panel.addBoldText("Los geht's mit der Einfhrungsaufgabe:");
        panel.addBoldText("Wer ist verantwortlich fr die Seiten des Fachbereiches Informatik?");
        panel.addText("Kleiner Tip: Solche Informationen findet man im \"Impressum\"");
        panel.addText(" ");
        panel.addItem(Box.createVerticalGlue());
        start = new StartButton(experiment,
                "http://www.informatik.uni-hamburg.de");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_FBI", "Wer ist verantworlich?");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);
        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
   
        panel = new TaskPanel();
    
        panel.addBoldText("Klasse! Das war es schon fast - so werden in Zukunft die einzelnen Aufgaben immer wieder aussehen.");
        panel.addText(" ");
        panel.addText("Nach der jeweiligen Aufgabe werden wir zwei kurze Fragen stellen, zum Beispiel:");
        panel.addText(" ");
        panel.addBoldText("1. Wie ist die Adresse des Fachbereiches Informatik?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
    
        panel.addItem(new OptionsBox("Q_FBIADRESSE", "Strae:", new String[] {"Vogt-Klln-Str. 30", "Konrad-Zuse-Str. 2", "Niendorfer Landweg 33", "wei nicht"}));
        panel.addText(" ");
        panel.addText("Wie sicher bist Du Dir Deiner Antwort?");
        panel.addItem(new OptionsBox("Q_FBIADRESSE+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addBoldText("Wer ist fr die technische Betreuung verantwortlich?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_FBIBETREUER", "E-Mail:", new String[] {"webmaster@informatik.uni-hamburg.de", "rz@informatik.uni-hamburg.de", "wwwmaint@informatik.uni-hamburg.de", "wei nicht"}));
        panel.addItem(new evaluator.util.OptionsBox("Q_FBIBETREUER+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addText(" ");
        panel.addBlueText("Diese Nach-Fragen sind nicht so wichtig, wie die korrekte und schnelle Beantwortung der zuerst gestellten");
        panel.addBlueText("Frage. Sie werden auch sehr unterschiedlich sein, deswegen bitte auf die gestellte Frage konzentrieren,");
        panel.addBlueText("nicht darauf, alle mglichen Informationen zu sammeln.");
        panel.addText(" ");
    
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
    
        experiment.addTaskGroup(taskGroup);

        // ===================================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lesen Sie die folgende Frage und beginnen die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Sie die Antwort gefunden haben, drcken Sie den Stop-Knopf.");
        panel.addBlueText("Dann tragen Sie bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Welche Interessensgebiete (areas of interest) hat einer der Organisatoren (co-chairs)");
        panel.addBoldText("des \"Workshops on Delivery Context\"?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://www.w3.org/2001/12/2002-03-05-di-workshop");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_W3CWS", "Bitte tragen Sie die Interessensgebiete hier stichwortartig ein..");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Sehr gut! Jetzt noch zwei kleine Fragen:");

        panel.addText(" ");
        panel.addBoldText("Von welcher Firma kam der Organisator zum World Wide Web Consortium?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_W3CCOMP", "Firma:", new String[] {"Matsushita", "Mitsubishi", "Sony", "wei nicht"}));
        panel.addItem(new evaluator.util.OptionsBox("Q_W3CCOMP+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welche Nationalitt hatte der andere Organisator vermutlich?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_W3CNATION", "Nationalitt:", new String[] {"amerikanisch", "italienisch", "japanisch", "wei nicht"}));
        panel.addItem(new evaluator.util.OptionsBox("Q_W3CNATION+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // ===================================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Finden Sie heraus, warum laut Nielsen Alternativen zu Anzeigen im Web gefunden werden mssen.");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://www.useit.com/alertbox/9709a.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_NIELSEN1", "Warum mssen Alternativen zu Anzeigen im Web gefunden werden?");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Super! Jetzt noch zwei kleine Fragen:");

        panel.addText(" ");
        panel.addBoldText("Aus welchem Jahr stammt der Artikel von Nielsen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_NIELYEAR", "Jahr:", new String[] {"1997", "1999", "2001", "wei nicht"}));
        panel.addItem(new evaluator.util.OptionsBox("Q_NIELYEAR+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Als welche Art von Medium characterisiert Nielsen das Fernsehen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_NIELWORD", "Charakterisierung:", new String[] {"Cold", "Emotional", "Consumer-dominated", "wei nicht"}));
        panel.addItem(new evaluator.util.OptionsBox("Q_NIELWORD+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        /*
         panel.addText(" ");
         panel.addBoldText("Warum ist laut Nielsen das Telephon eine bessere Metapher?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_NIELREAS", "Grund", new String[] {"der Benutzer \"ruft an\"", "...", ""}));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         */    
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // ===================================================================================


        // ===================================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Ein Freund hat Ihnen begesitert von dem Bestseller des Physikers David Deutsch berichtet.");
        panel.addBoldText("Finden sie heraus, wieviel die deutsche Ausgabe des Buches kostet.");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://www.qubit.org/people/david/David.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_DEUTSCH", "Wieviel Euro kostet das Buch von David Deutsch?");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Spitze! Jetzt noch zwei kleine Fragen:");

        panel.addText(" ");
        panel.addBoldText("Wie Lautet der deutsche Titel?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_DEUTITEL", "", new String[] {"Die verborgene Einheit der Welt", "Die Physik der Welterkenntnis", "Der Weg zur Weltformel"}));
        panel.addItem(new evaluator.util.OptionsBox("Q_DEUTITEL+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Von welchem Verlag ist die Taschenbuch- (Paperback)-Ausgabe?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_DEUVERLAG", "", new String[] { "Spektrum Verlag", "Heyne", "DTV"}));
        panel.addItem(new evaluator.util.OptionsBox("Q_DEUVERLAG+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // ===================================================================================


        // ===================================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Sie wollen das Brettspiel GO erlernen und haben das schne Tutorium \"How to Teach Go\" im Web gefunden.");
        panel.addBoldText("Finden sie heraus in welchem Falle ein Stein in ein komplett mit feindlichen Steinen umgebenes freies Feld gelegt werden darf.");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://www.sentex.net/~mmcadams/teachgo/illegal.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_GO", "Wann darf man den eigenen Stein in das komplett eingeschlossene Feld legen?");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Zwei kleine Zusatzfragen:");

        panel.addText(" ");
        panel.addBoldText("Wie nennt man eine Menge von Steinen in Go, die sich \"berhren\"?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_GOGROUP", "", new String[] {"Block", "Gruppe", "Kastell"}));
        panel.addItem(new evaluator.util.OptionsBox("Q_GOGROUP+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wer ist der Autor der Tutoriums-Seiten?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_GOAUTOR", "", new String[] { "Marc Scott", "Owen O'Neil", "Mindy McAdams"}));
        panel.addItem(new evaluator.util.OptionsBox("Q_GOAUTOR+", "Sicherheit:", new String[] {"100%", "80%", "60%", "40%", "20%", "geraten"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        /*
         // ===================================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();

         panel.addBoldText("Vielen Dank fr die Teilnahme an unserer Studie!");
         panel.addText(" ");
         panel.addText("Wir mchten verschiedene Visualisierungen von Links daraufhin testen, wie gut sie benutzbar sind.");
         panel.addText("Zunchst wird in einer kleinen Einfhrung die erste von drei Varianten vorgestellt:");
         panel.addText(" ");
         panel.addText("Die Links werden unterstrichen und in farbiger Schrift dargestellt.");
         panel.addText(" ");
         panel.addText("Um einen kleinen Eindruck vom Ablauf der Studie zu erhalten, bitte die erste Aufgabe starten (mit");
         panel.addText("dem Knopf unten).");
         panel.addText(" ");
         panel.addText("Daraufhin wird der Webbrowser auf dem zweiten Bildschirm eine Webseite anzeigen. Diese Seite");
         panel.addText("soll nun benutzt werden, um eine Antwort auf die hier gestellte Frage zu finden:");
         panel.addText(" ");
         panel.addBoldText("Welche Adresse hat die Universitt Hamburg?");
         panel.addText(" ");
         panel.addText("Wenn Du das Gefhl hast, fertig zu sein, dann klicke den Stop-Knopf weiter unten.");
         panel.addText(" ");
         panel.addText("Dann gib die Antwort auf die Frage in den weissen Kasten ein und klicke schlielich den ");
         panel.addText("Weiter-Knopf, um die nchste Aufgabe zu beginnen.");
         panel.addItem(Box.createVerticalGlue());
         start = new StartButton(experiment,
         "http://www.uni-hamburg.de");
         stop  = new StopButton(experiment);
         teb   = new TextEntryBox("Q_UNIHH", "Welche Adresse hat die Universitt Hamburg?");
         start.setComponentToEnable(stop);
         stop.setComponentToEnable(teb);
         panel.addItems(start, stop);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(teb);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.NextButton(experiment));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         panel = new TaskPanel();
         panel.addBoldText("Congratulations!");
         panel.addBoldText("You are done with all the tasks.");
         panel.addBoldText(" ");
         panel.addBoldText("Next we would like to get some subjective");
         panel.addBoldText("impressions how you estimate both systems.");
         panel.addBoldText("After this we are done for today.");
         panel.addBoldText(" ");
         panel.addItem(Box.createVerticalGlue());
         panel.addItems(new evaluator.util.StartButton(experiment,
         "http://www.w3.org"),
         new evaluator.util.NextButton(experiment));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         panel = new TaskPanel();
         panel.addBoldText("Yahoo!");
         panel.addBoldText("You are done with all the tasks.");
         panel.addBoldText(" ");

         panel.addItem(new evaluator.util.LikertScale(5, "LIKE", "schn", "hlich"));

         panel.addBoldText("Next we would like to get some subjective");
         panel.addBoldText("impressions how you estimate both systems.");
         panel.addBoldText("After this we are done for today.");
         panel.addBoldText(" ");
         panel.addItem(Box.createVerticalGlue());
         start = new StartButton(experiment,
         "http://www.weinreichs.de");
         stop  = new StopButton(experiment);
         start.setComponentToEnable(stop);
         panel.addItems(start, stop);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.NextButton(experiment));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         */
        // ===================================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
        panel = new TaskPanel();

        panel.addBoldText("Das war alles! Vielen Dank fr die Teilnahme an unserem Experiment!");
        panel.addText(" ");
        panel.addText(" ");
        panel.addText("Wenn Du wissen mchtest, was aus Deiner Teilnahme fr Ergebnisse erzeugt wurden,");
        panel.addText("dann trage Deine Email hier ein, wir verschicken dann unsere Resultate.");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        teb = new TextEntryBox("Q_EMAIL", "Platz fr Deine Email-Adresse");
        teb.setEnabled(true);
        panel.addItem(teb);
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.QuitButton(experiment, "Fertig!"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);
    }
}
