package evaluator.departureexperiment;


import java.awt.Dimension;

import javax.swing.Box;

import evaluator.util.CertitudeScale;
import evaluator.util.ContentGeneratorInterface;
import evaluator.util.EvaluatorFrame;
import evaluator.util.ExperimentController;
import evaluator.util.OptionsBox;
import evaluator.util.StartButton;
import evaluator.util.StopButton;
import evaluator.util.TaskGroup;
import evaluator.util.TaskPanel;
import evaluator.util.TextEntryBox;


/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @version 2.0
 */

public class ContentGeneratorForDepartureExperiment2 implements ContentGeneratorInterface {
    private EvaluatorFrame _evaluatorFrame;
    private scone.Plugin   _plugin;

    public ContentGeneratorForDepartureExperiment2() {
        _evaluatorFrame = null;
        _plugin = null;
    }
  
    public void init(EvaluatorFrame evaluatorFrame, scone.Plugin plugin) {
        _evaluatorFrame = evaluatorFrame;
        _plugin = plugin;
    }

    public void generate(ExperimentController experiment) {
        long subjectNumber = experiment.getSubjectNumber();
        TaskPanel panel;
        TaskGroup taskGroup;

        StartButton  start;
        StopButton   stop; 
        TextEntryBox teb;

        // = EINFHRUNG ======================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        // set visualization:

        panel = new TaskPanel();

        panel.addBoldText("<html><font size=+2>Willkommen bei unserer Studie zur Visualisierung von Links!</font>");
        panel.addText(" ");
        panel.addText("Wir mchten verschiedene Arten fr die Visualisierungen von Links daraufhin testen, wie gut sie benutzbar sind.");
        panel.addText("Zunchst wird in einer kleinen Einfhrung die erste von drei Varianten vorgestellt:");
        panel.addText(" ");
        panel.addText("Die Links werden mit farbigem Hintergrund dargestellt.");
        panel.addText(" ");
        panel.addText("Um einen kleinen Eindruck vom Ablauf der Studie zu erhalten, gibt es gleich eine Einfhrungsaufgabe.");
        panel.addText(" ");
        panel.addBoldText("Vorgehen");
        panel.addText("1. Jede Aufgabe wird mit dem Start-Knopf unten gestartet.");
        panel.addText("    Daraufhin wird der Webbrowser erscheinen und eine Webseite laden.");
        panel.addText("    Von dieser Seite aus soll nun eine Antwort auf die hier gestellte Frage gefunden werden.");
        panel.addText(" ");
        panel.addText("2. Wenn Du das Gefhl hast, die Antwort gefunden zu haben, wechsele zurck zu diesem Tool.");
        // panel.addText("    Dafr klicke am unterne Bildschirmrand auf das blau-orange \"E\" (E wie Evaluator).");
        panel.addText("    Achtung: Bitte schliee den Web-Browser nicht!");
        panel.addText(" ");
        panel.addText("3. Dann drcke den Stop-Knopf und gib die Antwort auf die Frage in den weien Kasten ein.");
        panel.addText(" ");
        panel.addText("4. Zur nchsten Aufgabe kommst Du mit dem Weiter-Knopf.");
        panel.addText(" ");
        panel.addBoldText("Los geht's mit der Einfhrungsaufgabe:");
        panel.addBoldText("Wer ist verantwortlich fr die Seiten des Fachbereiches Informatik?");
        panel.addText("Kleiner Tip: Solche Informationen findet man im \"Impressum\"");
        panel.addText(" ");
        panel.addItem(Box.createVerticalGlue());
        start = new StartButton(experiment, "http://www.informatik.uni-hamburg.de");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_FBI", "Wer ist verantworlich?");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);
        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "normal"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
   
        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Klasse! Das war es schon fast - so werden in Zukunft die einzelnen Aufgaben immer wieder aussehen.");
        panel.addText(" ");
        panel.addText("Nach der jeweiligen Aufgabe werden wir vier kurze Fragen stellen, zum Beispiel:");
        panel.addText(" ");
        panel.addBoldText("Wie ist die Adresse des Fachbereiches Informatik?");
        panel.addItem(new OptionsBox("Q_FBIADRESSE", "Strae:", new String[] {"Vogt-Klln-Str. 30", "Konrad-Zuse-Str. 2", "Niendorfer Landweg 33", "wei nicht"}));
        panel.addItem(Box.createRigidArea(new Dimension(0, 10)));
        panel.addBlueText("Wie sicher bist Du Dir Deiner Antwort?");
        panel.addItem(new CertitudeScale("Q_FBIADRESSE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addBoldText("Wer ist fr die technische Betreuung verantwortlich?");
        panel.addItem(new evaluator.util.OptionsBox("Q_FBIBETREUER", "E-Mail:", new String[] {"webmaster@informatik.uni-hamburg.de", "rz@informatik.uni-hamburg.de", "wwwmaint@informatik.uni-hamburg.de", "wei nicht"}));
        panel.addItem(new CertitudeScale("Q_FBIBETREUER+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addText(" ");
        panel.addBoldText("Wann wurde die Homepage der Informatik zuletzt verndert?");
        panel.addItem(new evaluator.util.OptionsBox("Q_FBICHANGE", "nderung", new String[] {"16.7.2001", "4.12.2000", "1.2.2002", "wei nicht"}));
        panel.addItem(new CertitudeScale("Q_FBICHANGE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addText(" ");
        panel.addBoldText("Wie werden die Studierenden des Fachbereichs bezeichnet?");
        panel.addItem(new evaluator.util.OptionsBox("Q_FBISTUD", "Bezeichnung", new String[] {"Studentenschaft", "Fachschaft", "Burschenschaft", "wei nicht"}));
        panel.addItem(new CertitudeScale("Q_FBISTUD+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addText(" ");
        panel.addBlueText("Diese Nach-Fragen sind nicht so wichtig, wie die <html> <b>korrekte und schnelle</b> Beantwortung der zuerst gestellten");
        panel.addBlueText("Frage. Sie werden auch sehr unterschiedlich sein, deswegen bitte auf die gestellte Frage konzentrieren,");
        panel.addBlueText("nicht darauf, alle mglichen Informationen zu sammeln.");
        panel.addText(" ");
    
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
    
        experiment.addTaskGroup(taskGroup);

        // = TU Braunschweig =================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Finden Sie heraus, welches in Hamburg entwickelte Werkzeug an der TU Braunschweig in der Forschung im Bereich Stoffstromanalyse");
        panel.addBoldText("eingesetzt wird.");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/tubs/index.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_TUBS", "Welches Werkzeug wird eingesetzt?");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandBackground"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Sehr gut! Jetzt noch vier kleine Fragen:");

        panel.addText(" ");
        panel.addBoldText("Wie heisst eines der EU-Projekte, das an der TU angesiedelt ist?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_TUBSEUPROJ", "EU-Projekt:", new String[] {"PARITY", "VAMPIRE", "SOMAT", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_TUBSEUPROJ+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Die TU beschftigt sich seit wann mit Stoffstromanalysen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_TUBSSINCE", "Zeit:", new String[] {"seit langer Zeit", "seit 1997", "in jnster Zeit", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_TUBSSINCE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welche andere Stadt war an der Entwicklung des Werkzeugs beteiligt?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_TUBSCITY", "Zeit:", new String[] {"Hannover", "Heidelberg", "Mnster", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_TUBSCITY+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welche Autoren werden als Quelle fr die bersicht der verfgbaren Programme zitiert?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_TUBSAUTHOR", "Zeit:", new String[] {"SCHMIDT & WOHLFARTH", "SCHMIDT & HUSLEIN", "SCHMIDT & RADEK", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_TUBSAUTHOR+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "background"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // =Frage: Electronic Labyrinth ======================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Sie mchten mehr ber die Idee des Hypertextes erfahren und haben im Web das  \"Electronic Labyrinth of Hypertext\" entdeckt.");
        panel.addBoldText("Finden Sie heraus, wie das Konzept \"Pfad\" (bzw. Path) in diesem Kontext beschrieben wird.");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/laby1/a1a.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_LABY", "Was versteht man unter einem Pfad?");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
    
        panel = new TaskPanel();
    
        panel.addBoldText("Weiter so! Jetzt noch vier kleine Fragen:");

        panel.addText(" ");
        panel.addBoldText("Welchem System wird der Begriff des \"Webs\" zugesprochen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_LABYWEB", "System:", new String[] {"World Wide Web", "Intermedia", "Guide", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_LABYWEB+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wie wird der Zusammenhang zwischen Web und Pfad beschrieben?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_LABYWEBPATH", "Zusammenhang:", new String[] {"Ein Web besteht aus vielen Pfaden", "Die Konzepte sind unabhngig", "Die Konzepte sind vergleichbar", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_LABYWEBPATH+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welche Analogie fhrte zum Konzept der Pfade?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_LABYANALOG", "Analogie:", new String[] { "ffentliche Bcherhalle", "Menschliches Bewusstsein", "Computer-Netz", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_LABYANALOG+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wem wird das Konzept des Wanderpfades zugesprochen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_LABYTRAIL", "Person:", new String[] {"Vannevar Bush", "Ted Nelson", "Douglas Engelbart", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_LABYTRAIL+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandNormal"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // ===================================================================================


        // = Frage: SELFHTML =================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Sie mchten jetzt endlich HTML lernen um selbst im Web publizieren zu knnen.");
        panel.addBoldText("Wie wird sogenannter \"prformatierter Text\" in HTML dargestellt?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/selfhtml1/a2a.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_WASA", ":");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
    
        panel = new TaskPanel();
    
        panel.addBoldText("Genial! Bitte beantworten Sie noch die folgenden vier Fragen.");

        panel.addText(" ");
        panel.addBoldText("Worauf soll man beim Formatieren des Quelltextes von HTML-Dokumenten achten?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASAFAM", "Zu beachten", new String[] {"Einrcken / Formatieren",
            "Gross- / Kleinschreibung", "an den XHTML-Standard halten", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASAFAM+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Was sollte als Erstes erzeugt werden?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASAGESCHM", "Erstes Erzeugnis:", new String[] {"der Titel der Seite", "das Layout", "das Grundgerst", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASAGESCHM+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText("");
        panel.addBoldText("Was kann man innerhalb von PRE-formatiertem Text verwenden?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASAPFLANZ", "Verwendbar:", new String[] { "HTML-eigene Zeichen", "XML-Tags", "deutsche Sonderzeichen", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASAPFLANZ+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welches Beispiel wird fr die Verwendung von prformatiertem Text gegeben?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASALANG", "Wofr:", new String[] {"Programmlistings", "Zitate", "HTML-Quelltext", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASALANG+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = Frage: HEISE 2 ==================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Wie hie der vorsitzende Richter bei der Prozessniederlage gegen die amerikanische Musikindustrie?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise2/heise.denewstickerdatafr-10.02.02-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_KYRO2", "Name des Richters:");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
    
        panel = new TaskPanel();
    
        panel.addBoldText("Wow! Bitte beantworten Sie noch die folgenden vier Fragen.");

        panel.addText(" ");
        panel.addBoldText("Welche Person klagte gegen die Musikindustrie?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_KYROUMS", "Name", new String[] {"Todd Philips", "Edward Felten", "Richard Stallmann", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASAUMS+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Von welcher Organisation kam das Anwaltsteam des Klgers?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_KYROTUMS", "Bezeichnung:", new String[] {"EFF", "SGI", "OSI", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_KYROTUMS+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText("");
        panel.addBoldText("An welchem Bezirksgericht wurde der Fall entschieden?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASAPFLANZ", "Bezirksgericht:", new String[] {"Boston(Massachusetts)", "New York(New York)", "Trenton (New Jersey)", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASAPFLANZ+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welches Recht schrnkt die Musikindustrie der Klage nach ein?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASALANG", "Recht auf:", new String[] {"freie Entfaltung der Persnlichkeit", "freie Meinungsuerung", "Kopien fr den privaten Gebrauch", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASALANG+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = Frage: HEISE 3 ==================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Gegen welches Argument wehrt sich der Geschftfhrer von Microsoft Deutschland in einem offenen Brief?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise3/heise.denewstickerdatamw-09.02.02-005.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_KYRO2", "Argument:");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
    
        panel = new TaskPanel();
    
        panel.addBoldText("Jaa! Bitte beantworten Sie noch die folgenden vier Fragen.");

        panel.addText(" ");
        panel.addBoldText("In welcher Form hat der virtuelle Ortsverein der SPD protestiert?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_KYROUMS", "Form", new String[] {"Antrag auf Sondersitzung", "Email an der Bundestagsprsidenten", "Presseerklrung", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASAUMS+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wie werden die usserungen des Microsoft-Chefs bezeichnet?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_KYROTUMS", "Bezeichnung:", new String[] {"Bsartige Propaganda", "Infame Lgen", "Traurige Verschleierungsversuche", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_KYROTUMS+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText("");
        panel.addBoldText("In welcher Form wendeten sich Bundespolitiker gegen die Verwendung von MS-Produkten?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASAPFLANZ", "Form:", new String[] { "Bundestagsdebatte", "Petition", "Bericht des Sonderausschusses", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASAPFLANZ+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Der Streitpunkt ist die Umstellung welcher IT-Systeme?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASALANG", "Einsatzort:", new String[] {"im Bundestag", "in den Bundesbehrden", "im Aussenministerium", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASALANG+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = Frage: HEISE 4 ==================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Wie hiess die Grafikkarte, auf der zuletzt der Kyro II eingesetzt wurde?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise4/heise.denewstickerdataciw-08.02.02-001.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_KYRO2", "Die Grafikkarte hiess:");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
    
        panel = new TaskPanel();
    
        panel.addBoldText("Danke! Bitte beantworten Sie noch die folgenden vier Fragen.");

        panel.addText(" ");
        panel.addBoldText("Wie hoch war der Gesamtumsatz von STMicroelectronics?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_KYROUMS", "Umsatz", new String[] {"3,48 Milliarden $", "6,36 Milliarden $", "8,32 Milliarden $", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASAUMS+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wie hoch war der Umsatz des Teilunternehmens fr Grafikkarten?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_KYROTUMS", "Teilumsatz:", new String[] {"8 Millionen $", "10 Millionen $", "15 Millionen $", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_KYROTUMS+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText("");
        panel.addBoldText("Wie hiess der Hersteller der Kyro-II-Grafikkarte?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASAPFLANZ", "Hersteller:", new String[] { "Elsa", "Hercules/Guillemot", "Asus", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASAPFLANZ+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wie hiess der direkte Konkurrenzchipsatz?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_WASALANG", "Chipsatz:", new String[] {"GX", "MX/200", "MX/400", "weiss nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_WASALANG+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // ===================================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        panel.addBoldText("Der erste Teil ist beendet!");
        panel.addText(" ");
        panel.addText("Wir mchten gerne noch eine subjektive Einschtzung von Dir, um die Nutzbarkeit der verwendeten");
        panel.addText("Visualisierung besser einschtzen zu knnen.");
        panel.addText(" ");

        panel.addText(" ");
        panel.addBoldText("Wie beurteiltst Du die Sichtbarkeit der Links?");
        panel.addItem(new evaluator.util.LikertScale(5, "Q_VISIBILITY", "einfach zu erkennen", "schwer zu erkennen"));
        panel.addItem(new evaluator.util.LikertScale(5, "Q_CONFLICTING", "stren das Layout", "stren gar nicht"));
        panel.addItem(new evaluator.util.LikertScale(5, "Q_READABILITY", "gut zu lesen", "schlecht zu lesen"));
        panel.addItem(new evaluator.util.LikertScale(5, "Q_DISTURBING", "sehr ablenkend", "gar nicht ablenkend"));
    
        panel.addText(" ");
        panel.addBoldText("Wie zufrieden bist du mit der Darstellung der Links?");
        panel.addItem(new evaluator.util.LikertScale(5, "Q_USEDNESS", "nicht ungewohnt", "sehr ungewohnt"));
        panel.addItem(new evaluator.util.LikertScale(5, "Q_LIKABILITY", "angenehm", "unangenehm"));
        panel.addItem(new evaluator.util.LikertScale(5, "Q_EFFICIENCY", "praktisch", "unpraktisch"));
    
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);
    
        experiment.addTaskGroup(taskGroup);

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
        panel = new TaskPanel();

        panel.addBoldText("Das war alles! Vielen Dank fr die Teilnahme an unserem Experiment!");
        panel.addText(" ");
        panel.addText(" ");
        panel.addText("Wenn Du wissen mchtest, was aus Deiner Teilnahme fr Ergebnisse erzeugt wurden,");
        panel.addText("dann trage Deine Email hier ein, wir verschicken dann unsere Resultate.");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        teb = new TextEntryBox("Q_EMAIL", "Platz fr Deine Email-Adresse");
        teb.setEnabled(true);
        panel.addItem(teb);
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.QuitButton(experiment, "Fertig!"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);
    }
}
