package evaluator.departureexperiment;


import java.awt.Dimension;

import javax.swing.Box;

import evaluator.util.ContentGeneratorInterface;
import evaluator.util.EvaluatorFrame;
import evaluator.util.ExperimentController;
import evaluator.util.StartButton;
import evaluator.util.StopButton;
import evaluator.util.TaskGroup;
import evaluator.util.TaskPanel;
import evaluator.util.TextEntryBox;


/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @version 2.0
 */

public class ContentGeneratorForDepartureExperiment3 implements ContentGeneratorInterface {
    private EvaluatorFrame _evaluatorFrame;
    private scone.Plugin   _plugin;

    public ContentGeneratorForDepartureExperiment3() {
        _evaluatorFrame = null;
        _plugin = null;
    }
  
    public void init(EvaluatorFrame evaluatorFrame, scone.Plugin plugin) {
        _evaluatorFrame = evaluatorFrame;
        _plugin = plugin;
    }

    public void generate(ExperimentController experiment) {
        long subjectNumber = experiment.getSubjectNumber();
        TaskPanel panel;
        TaskGroup taskGroup;

        StartButton  start;
        StopButton   stop; 
        TextEntryBox teb;

        // = EINFHRUNG ======================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        // initialize Visualization (at generation time!)
        lookoflink.Plugin.setVisualization("onDemandNormal");
    
        panel.addBoldText("<html><font size=+2>Willkommen bei unserer Studie zur Visualisierung von Links!</font>");
        panel.addText(" ");
        panel.addText("Wir mchten verschiedene Arten fr die Visualisierungen von Links daraufhin testen, wie gut sie benutzbar sind.");
        panel.addText("Dazu werden wir verschiedene kleine Aufgaben stellen.");
        panel.addText(" ");
        panel.addText("Die Aufgaben finden in folgendem Szenario statt: Stell Dir vor, du hast gerade Zeit und mchtest");
        panel.addText("einmal nachforschen, was fr bewegende Dinge in den letzten Jahren geschehen sind. Dazu liest Du");
        panel.addText("im Archiv eines Nachrichtensenders einzelne Meldungen, die der Newsticker ausgespuckt hatte.");
        panel.addText(" ");
        panel.addText("Um heute abend beim Betriebsfest mit deinem angesammelten Wissen glnzen zu knnen, reichen Dir");
        panel.addText("jedoch diese Informationsschnipsel nicht, und dir kommt die von uns gestellte Frage in den Sinn.");
        panel.addText("Versuche deshalb, mglichst schnell und mglichst genau eine Antwort zu finden..");
        panel.addText(" ");
        panel.addText("Um einen kleinen Eindruck vom Ablauf der Studie zu erhalten, gibt es gleich eine Einfhrungsaufgabe.");
        panel.addText("Diese soll zum einen dazu dienen, dass Du dich mit dem Ablauf vertraut machen kannst, zum anderen");
        panel.addText("soll sie auch eine Besonderheit zeigen: Links, die erst erscheinen, wenn die [Strg]-Taste gedrckt");
        panel.addText("wird, bzw. wenn die Maus sich ber dem Link befindet.");
        panel.addText(" ");
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandBackground"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
   
        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        panel.addBoldText("Das Vorgehen ist fr jede Aufgabe gleich:");
        panel.addText("1. Jede Aufgabe wird mit dem Start-Knopf unten gestartet.");
        panel.addText("    Daraufhin wird der Webbrowser erscheinen und eine Webseite laden.");
        panel.addText("    Von dieser Seite aus soll nun eine Antwort auf die hier gestellte Frage gefunden werden.");
        panel.addText(" ");
        panel.addText("2. Wenn Du das Gefhl hast, die Antwort gefunden zu haben, wechsele zurck zu diesem Programm.");
        panel.addText("    Dafr kannst Du einfach die Maus auf den linken Bildschirm bewegen.");
        // panel.addText("    Dafr klicke am unterne Bildschirmrand auf das blau-orange \"E\" (E wie Evaluator).");
        panel.addText("    Achtung: Bitte schliee den Web-Browser nicht!");
        panel.addText(" ");
        panel.addText("3. Dann drcke den Stop-Knopf und gib die Antwort auf die Frage in den weien Kasten ein.");
        panel.addText(" ");
        panel.addText("4. Zur nchsten Aufgabe kommst Du mit dem Weiter-Knopf.");
        panel.addText(" ");
        panel.addText(" ");
        panel.addText("Mit dem Weiter-Knopf geht es jetzt mit der Einfhrungsaufgabe los...");
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
   
        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");
        panel.addItem(Box.createVerticalGlue());
        panel.addText("<html><b>HTML</b> war zur Drucklegung des Artikels gerade in welcher Version aktuell?");
        // panel.addText("<html>Der Standard fr <b>Vektorgrafik</b> trgt welchen Namen?");
        panel.addText(" ");
        panel.addItem(Box.createVerticalGlue());
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdatahb-13.07.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_HTML_VERSION", "Bitte trage die Versionsnummer hier ein..");
        // teb   = new TextEntryBox("Q_HTML_VERSION", "Bitte trage den Namen hier ein..");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);
        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = CDC BACKDOOR ====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addText("<html>Welches <b>Protokoll</b> wird von dem im Text beschriebenen trojanischen Pferd fr die Verbindung verwendet?");
        // panel.addText("<html><b>Cult of the Dead Cow</b> wurde in welchem Jahr gegrndet?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-05.08.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_CDCBACKDOOR_PROTOCOL", "Bitte trage den Namen des Protokolls hier ein...");
        // teb   = new TextEntryBox("Q_CDCBACKDOOR_YEAR", "Bitte trage das Jahr der Grndung hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = FBI FOIA ========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        // panel.addText("<html>Der im Text erwhnte <b>Zeppelin</b> trug welchen Namen?");
        panel.addText("<html>Die <b>Flucht aus Alcatraz</b> ist auf wie vielen Seiten dokumentiert?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdatafr-17.06.98-000.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_FBI_ZEPPELIN", "Bitte trage den Namen des Zeppelins hier ein...");
        teb = new TextEntryBox("Q_FBI_PAGES", "Bitte trage die Anzahl der Seiten hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = MS ACADEMIA =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        // panel.addText("<html>Die <b>Rume des Trgers</b> befinden sich wo?");
        panel.addText("<html>Die <b>Academic Cooperative</b> hat jetzt welchen neuen Namen?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-26.05.98-000.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_MSA_PLACE", "Bitte trage den Standort hier ein...");
        teb = new TextEntryBox("Q_MSA_NAME", "Bitte trage den Namen hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandBackground"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SUN LINUX =======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addText("<html>Was ist das <b>verkndete Ziel</b> von Linus Torvalds?");
        // panel.addText("<html><b>Redhat</b> gibt es in welcher aktuellen Version?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataju-27.05.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_SUN_TARGET", "Bitte trage das Ziel hier ein...");
        // teb   = new TextEntryBox("Q_SUN_VERSION", "Bitte trage die Version hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = PHONE STUDY =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        // panel.addText("<html>Die <b>Untersuchung</b> fand in welchem Land statt?");
        panel.addText("<html><b>GSM</b> krzt welchen Begriff ab?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataad-28.05.98-001.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_GSM_COUNTRY", "Bitte trage das Land hier ein...");
        teb = new TextEntryBox("Q_GSM_ABBREV", "Bitte trage den Begriff hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SPACE SHUTTLE ===================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addText("<html>Die <b>Datenbertragungsrate</b> zur Erde ist wie hoch??");
        // panel.addText("<html>Das <b>Space Shuttle</b> hatte wie viele Besatzungsmitglieder?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataje-28.05.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_GSM_COUNTRY", "Bitte trage die Rate hier ein...");
        // teb   = new TextEntryBox("Q_GSM_ABBREV", "Bitte trage die Anzahl hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "background"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = CDC BACKDOOR ====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        // panel.addText("<html>Welches <b>Protokoll</b> wird von dem im Text beschriebenen trojanischen Pferd fr die Verbindung verwendet?");
        panel.addText("<html><b>Cult of the Dead Cow</b> wurde in welchem Jahr gegrndet?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-05.08.98-000.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_CDCBACKDOOR_PROTOCOL", "Bitte trage den Namen des Protokolls hier ein...");
        teb = new TextEntryBox("Q_CDCBACKDOOR_YEAR", "Bitte trage das Jahr der Grndung hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = FBI FOIA ========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addText("<html>Der im Text erwhnte <b>Zeppelin</b> trug welchen Namen?");
        // panel.addText("<html>Die <b>Flucht aus Alcatraz</b> ist auf wie vielen Seiten dokumentiert?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdatafr-17.06.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_FBI_ZEPPELIN", "Bitte trage den Namen des Zeppelins hier ein...");
        // teb   = new TextEntryBox("Q_FBI_PAGES", "Bitte trage die Anzahl der Seiten hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = MS ACADEMIA =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addText("<html>Die <b>Rume des Trgers</b> befinden sich wo?");
        // panel.addText("<html>Die <b>Academic Coopertive</b> hat jetzt welchen neuen Namen?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-26.05.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_MSA_PLACE", "Bitte trage den Standort hier ein...");
        // teb   = new TextEntryBox("Q_MSA_NAME", "Bitte trage den Namen hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SUN LINUX =======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        // panel.addText("<html>Was ist das <b>verkndete Ziel</b> von Linus Torvalds?");
        panel.addText("<html><b>Redhat</b> gibt es in welcher aktuellen Version?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataju-27.05.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_SUN_TARGET", "Bitte trage das Ziel hier ein...");
        teb = new TextEntryBox("Q_SUN_VERSION", "Bitte trage die Version hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = PHONE STUDY =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addText("<html>Die <b>Untersuchung</b> fand in welchem Land statt?");
        // panel.addText("<html><b>GSM</b> krzt welchen Begriff ab?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataad-28.05.98-001.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_GSM_COUNTRY", "Bitte trage das Land hier ein...");
        // teb   = new TextEntryBox("Q_GSM_ABBREV", "Bitte trage den Begriff hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SPACE SHUTTLE ===================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        // panel.addText("<html>Die <b>Datenbertragungsrate</b> zur Erde ist wie hoch??");
        panel.addText("<html>Das <b>Space Shuttle</b> hatte wie viele Besatzungsmitglieder?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataje-28.05.98-000.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_GSM_COUNTRY", "Bitte trage die Rate hier ein...");
        teb = new TextEntryBox("Q_GSM_ABBREV", "Bitte trage die Anzahl hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT ================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addText("<html><h1>Zweiter Teil</h1>");
        panel.addBoldText("Noch ein Test.");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addText("Dieser Test luft etwas anders ab. Du sollst in diesem Test fr eine vorgegebene Zeit (ca. 30 Sekunden)");
        panel.addText("den Inhalt einer Webseite lesen. Sie wird danach automatisch verschwinden und Du sollst danach einige");
        panel.addText("Fragen zum Inhalt beantworten.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke den ,,Start''-Knopf und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        StartButtonWithTimeout startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/jk-13.02.02-001/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Ab wann kann man zuknftig die Spiegelartikel der kommenden Woche bereits online abrufen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGWANN", "Ab:", new String[] {"Samstag 10 Uhr", "Samstag 15 Uhr", "Sonntag 13 Uhr", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGWANN+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wie heit der Vorstand von SpiegelNet?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGNAME", "Name:", new String[] {"Carsten Tummler", "Thoms Gbler", "Marco Knossler", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGNAME+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welches Zahlsystem soll eingesetzt werden?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGELPAY", "System:", new String[] {"ePayment", "Allcash", "click&buy", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGELPAY+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welcher im Artikel genante Anbieter setzt auch auf kostenpflichtige Inhalte?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGELPROVIDER", "Anbieter:", new String[] {"Tomorrow Focus", "Stern Online", "Die Zeit", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGELPROVIDER+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "normal"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
 
        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT II =============================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addText("Auch dieser Test gibt eine Zeit von 30 Sekunden um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke den ,,Start''-Knopf und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/cgl-09.11.01-001/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Mit wem kann man die Korallen auf den Fijis ansehen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_KORALLEN", "Ab:", new String[] {"Jean Cousteau", "Franziska von Almsick", "Greg Louganis", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_KORALLEN+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Mit wem das Berliner Nachtleben unsicher machen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_NACHTLEBE", "Name:", new String[] {"Bruno Ganz", "Wim Wenders", "Ben Becker", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_NACHTLEBE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welcher Musikmacher kann auf Ihrer Privatfete spielen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_PRIVATFETE", "System:", new String[] {"Dr Motte", "Sven Vth", "L.U.P.O", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_PRIVATFETE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wo knnen sie nicht lange, aber gut mir Eingeborenen leben?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EINGEBORENE", "Anbieter:", new String[] {"Feuerland", "Peru", "Martinique", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EINGEBORENE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandBackground"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
 
        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT 3 ================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addText("Auch dieser Test gibt eine Zeit von 30 Sekunden um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/lab-07.11.01-001/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Fr welches Quartal progniostiezieren die Analysten wieder Gewinne fr Sun?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SUNWIN", "Ab:", new String[] {"erstes Quartal 2002", "zweites Quartal 2002", "drittes Quartal 2002", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SUNWIN+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Ab wann rechnet Sun laut Quartalsbericht wieder mit Gewinnen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SUNWIN2", "Nicht vor:", new String[] {"April 2002", "Juni 2002", "Oktober 2002", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SUNWIN2+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wieviel Megaherz haben die neuen Prozessoren?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SUNTAKT", "Takt:", new String[] {"900 MHz", "1200 MHz", "1900 MHz", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SUNTAKT+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wie heien die schnellsten Midframe-Server der Welt?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SUNNAME", "Name:", new String[] {"Sun Fire 4810", "Sun Fire 6800", "Sun Fire 6810", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SUNNAME+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandBackground"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = AUSLEITUNG ======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();

        panel.addBoldText("Das war alles! Vielen Dank fr die Teilnahme an unserem Experiment!");
        panel.addText(" ");
        panel.addText(" ");
        panel.addText("Wenn Du wissen mchtest, was aus Deiner Teilnahme fr Ergebnisse erzeugt wurden,");
        panel.addText("dann trage Deine Email hier ein, wir verschicken dann unsere Resultate.");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        teb = new TextEntryBox("Q_EMAIL", "Platz fr Deine Email-Adresse");
        teb.setEnabled(true);
        panel.addItem(teb);
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.QuitButton(experiment, "Fertig!"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);
    }
}
