package evaluator.departureexperiment;


import java.awt.Dimension;

import javax.swing.Box;

import evaluator.util.ContentGeneratorInterface;
import evaluator.util.EvaluatorFrame;
import evaluator.util.ExperimentController;
import evaluator.util.NextButton;
import evaluator.util.StartButton;
import evaluator.util.StopButton;
import evaluator.util.TaskGroup;
import evaluator.util.TaskPanel;
import evaluator.util.TextEntryBox;


/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @version 2.0
 */

public class ContentGeneratorForDepartureExperiment4 implements ContentGeneratorInterface {
    private EvaluatorFrame _evaluatorFrame;
    private scone.Plugin   _plugin;

    public ContentGeneratorForDepartureExperiment4() {
        _evaluatorFrame = null;
        _plugin = null;
    }
  
    public void init(EvaluatorFrame evaluatorFrame, scone.Plugin plugin) {
        _evaluatorFrame = evaluatorFrame;
        _plugin = plugin;
    }

    public void generate(ExperimentController experiment) {
        long subjectNumber = experiment.getSubjectNumber();
        TaskPanel panel;
        TaskGroup taskGroup;

        StartButton  start;
        StopButton   stop; 
        TextEntryBox teb;
        NextButton   next;

        // = EINFHRUNG ======================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        // initialize Visualization (at generation time!)
        lookoflink.Plugin.setVisualization("onDemandNormal");
    
        panel.addBoldText("<html><font color=black><font size=+2>Willkommen bei unserer Studie zur Visualisierung von Links!</font>");
        panel.addText(" ");
        panel.addText("Wir mchten verschiedene Arten fr die Visualisierungen von Links daraufhin testen, wie gut sie benutzbar sind.");
        panel.addText("Dazu werden wir verschiedene kleine Aufgaben stellen.");
        panel.addText(" ");
        panel.addText("Um einen kleinen Eindruck vom Ablauf der Studie zu erhalten, gibt es gleich eine Einfhrungsaufgabe.");
        panel.addText("Diese soll dazu dienen, dass Du dich mit dem Ablauf vertraut machen kannst.");
        panel.addText(" ");
        panel.addText("Zuvor soll jedoch eine Besonderheit vorgestellt werde: Links, die nur erscheinen, wenn dir Strg-Taste gedrckt");
        panel.addText("wird, bzw. wenn die Maus sich ber dem Link befindet.");
        panel.addText(" ");
        panel.addText("Um das einfach mal auszuprobieren, drcke den Start-Knopf und surfe ein wenig herum. Wenn Du genug hast, dann");
        panel.addText("wechsele zurck zu diesem Fenster und benutze den Weiter-Knopf, um fortzufahren.");
        panel.addText(" ");
        panel.addItem(Box.createVerticalGlue());
        start = new StartButton(experiment, "http://www.informatik.uni-hamburg.de");
        panel.addItem(start);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
   
        // -----------------------------------------------------------------------------------
        panel = new TaskPanel();

        panel.addBoldText("Das Vorgehen ist fr jede Aufgabe gleich:");
        panel.addText("1. Jede Aufgabe wird mit dem Start-Knopf unten gestartet.");
        panel.addText("    Daraufhin wird der Webbrowser erscheinen und eine Webseite laden.");
        panel.addText("    Von dieser Seite aus soll nun eine Antwort auf die hier gestellte Frage gefunden werden.");
        panel.addText(" ");
        panel.addText("2. Wenn Du das Gefhl hast, die Antwort gefunden zu haben, wechsele zurck zu diesem Programm.");
        // panel.addText("    Dafr kannst Du einfach die Maus auf den linken Bildschirm bewegen.");
        panel.addText("    Dafr klicke am unterne Bildschirmrand auf das blau-orange \"E\" (E wie Evaluator).");
        panel.addText("    Achtung: Bitte schliee den Web-Browser nicht!");
        panel.addText(" ");
        panel.addText("3. Dann drcke den Stop-Knopf und gib die Antwort auf die Frage in den weien Kasten ein.");
        panel.addText(" ");
        panel.addText("4. Zur nchsten Aufgabe kommst Du mit dem Weiter-Knopf.");
        panel.addText(" ");
        panel.addText(" ");
        panel.addBoldText("Die Aufgaben finden in folgendem Szenario statt:");
        panel.addText("Stell Dir vor, du hast gerade Zeit und mchtest einmal nachforschen, was fr bewegende Dinge ");
        panel.addText("in den letzten Jahren geschehen sind. Dazu liest Du im Archiv eines Nachrichtensenders ");
        panel.addText("einzelne Meldungen, die der Newsticker ausgespuckt hatte.");
        panel.addText(" ");
        panel.addText("Um heute abend beim Betriebsfest mit deinem angesammelten Wissen glnzen zu knnen, reichen Dir");
        panel.addText("jedoch diese Informationsschnipsel nicht, und dir kommt die von uns gestellte Frage in den Sinn.");
        panel.addText("Versuche deshalb, mglichst schnell und mglichst genau eine Antwort zu finden..");
        panel.addText(" ");
        panel.addText("Mit dem Weiter-Knopf geht es jetzt mit der Einfhrungsaufgabe los...");
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
   
        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Die HTML-Zukunft heit XML");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        panel.addText("<html><font color=black><b>HTML</b> wird in welcher Version erwhnt?");
        // panel.addText("<html><font color=black>Der Standard fr <b>Vektorgrafik</b> trgt welchen Namen?");
        panel.addItem(Box.createVerticalGlue());
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdatahb-13.07.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_HTML_VERSION", "Bitte trage die Versionsnummer hier ein..");
        next = new evaluator.util.NextButton(experiment);
        // teb   = new TextEntryBox("Q_HTML_VERSION", "Bitte trage den Namen hier ein..");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);
        // teb.setComponentToEnable(next);
        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(next);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = CDC BACKDOOR ====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Microsoft verharmlost Sicherheitsrisiko");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        panel.addText("<html><font color=black>Welches <b>Protokoll</b> wird von dem im Text beschriebenen trojanischen Pferd fr die Verbindung verwendet?");
        // panel.addText("<html><font color=black><b>Cult of the Dead Cow</b> wurde in welchem Jahr gegrndet?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-05.08.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_CDCBACKDOOR_PROTOCOL", "Bitte trage den Namen des Protokolls hier ein...");
        // teb   = new TextEntryBox("Q_CDCBACKDOOR_YEAR", "Bitte trage das Jahr der Grndung hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = FBI FOIA ========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("FBI macht Dokumente online zugnglich");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        // panel.addText("<html><font color=black>Der im Text erwhnte <b>Zeppelin</b> trug welchen Namen?");
        panel.addText("<html><font color=black>Die <b>Flucht aus Alcatraz</b> ist auf wie vielen Seiten dokumentiert?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdatafr-17.06.98-000.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_FBI_ZEPPELIN", "Bitte trage den Namen des Zeppelins hier ein...");
        teb = new TextEntryBox("Q_FBI_PAGES", "Bitte trage die Anzahl der Seiten hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = MS ACADEMIA =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Microsoft honoriert akademische Schleichwerbung");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        // panel.addText("<html><font color=black>Die <b>Rume des Trgers</b> befinden sich wo?");
        panel.addText("<html><font color=black>Die <b>Academic Cooperative</b> hat jetzt welchen neuen Namen?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-26.05.98-000.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_MSA_PLACE", "Bitte trage den Standort hier ein...");
        teb = new TextEntryBox("Q_MSA_NAME", "Bitte trage den Namen hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandBackground"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SUN LINUX =======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Sun untersttzt Linux");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        panel.addText("<html><font color=black>Was ist das <b>verkndete Ziel</b> von Linus Torvalds?");
        // panel.addText("<html><font color=black><b>Redhat</b> gibt es in welcher aktuellen Version?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataju-27.05.98-000.html");
        stop = new StopButton(experiment);
        next = new evaluator.util.NextButton(experiment);
        teb = new TextEntryBox("Q_SUN_TARGET", "Bitte trage das Ziel hier ein...");
        // teb   = new TextEntryBox("Q_SUN_VERSION", "Bitte trage die Version hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = PHONE STUDY =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Heie Ohren am Mobiltelefon");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        // panel.addText("<html><font color=black>Die <b>Untersuchung</b> fand in welchem Land statt?");
        panel.addText("<html><font color=black><b>GSM</b> krzt welchen Begriff ab?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataad-28.05.98-001.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_GSM_COUNTRY", "Bitte trage das Land hier ein...");
        teb = new TextEntryBox("Q_GSM_ABBREV", "Bitte trage den Begriff hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SPACE SHUTTLE ===================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Der schnellste Web-Server des Sonnensystems...");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        panel.addText("<html><font color=black>Die <b>Datenbertragungsrate</b> zur Erde ist wie hoch??");
        // panel.addText("<html><font color=black>Das <b>Space Shuttle</b> hatte wie viele Besatzungsmitglieder?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataje-28.05.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_GSM_COUNTRY", "Bitte trage die Rate hier ein...");
        // teb   = new TextEntryBox("Q_GSM_ABBREV", "Bitte trage die Anzahl hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "background"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = CDC BACKDOOR ====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Microsoft verharmlost Sicherheitsrisiko");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        // panel.addText("<html><font color=black>Welches <b>Protokoll</b> wird von dem im Text beschriebenen trojanischen Pferd fr die Verbindung verwendet?");
        panel.addText("<html><font color=black><b>Cult of the Dead Cow</b> wurde in welchem Jahr gegrndet?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-05.08.98-000.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_CDCBACKDOOR_PROTOCOL", "Bitte trage den Namen des Protokolls hier ein...");
        teb = new TextEntryBox("Q_CDCBACKDOOR_YEAR", "Bitte trage das Jahr der Grndung hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = FBI FOIA ========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("FBI macht Dokumente online zugnglich");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        panel.addText("<html><font color=black>Der im Text erwhnte <b>Zeppelin</b> trug welchen Namen?");
        // panel.addText("<html><font color=black>Die <b>Flucht aus Alcatraz</b> ist auf wie vielen Seiten dokumentiert?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdatafr-17.06.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_FBI_ZEPPELIN", "Bitte trage den Namen des Zeppelins hier ein...");
        // teb   = new TextEntryBox("Q_FBI_PAGES", "Bitte trage die Anzahl der Seiten hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = MS ACADEMIA =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Microsoft honoriert akademische Schleichwerbung");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        panel.addText("<html><font color=black>Die <b>Rume des Trgers</b> befinden sich wo?");
        // panel.addText("<html><font color=black>Die <b>Academic Coopertive</b> hat jetzt welchen neuen Namen?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-26.05.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_MSA_PLACE", "Bitte trage den Standort hier ein...");
        // teb   = new TextEntryBox("Q_MSA_NAME", "Bitte trage den Namen hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SUN LINUX =======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Sun untersttzt Linux");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        // panel.addText("<html><font color=black>Was ist das <b>verkndete Ziel</b> von Linus Torvalds?");
        panel.addText("<html><font color=black><b>Redhat</b> gibt es in welcher aktuellen Version?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataju-27.05.98-000.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_SUN_TARGET", "Bitte trage das Ziel hier ein...");
        teb = new TextEntryBox("Q_SUN_VERSION", "Bitte trage die Version hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = PHONE STUDY =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Heie Ohren am Mobiltelefon");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        panel.addText("<html><font color=black>Die <b>Untersuchung</b> fand in welchem Land statt?");
        // panel.addText("<html><font color=black><b>GSM</b> krzt welchen Begriff ab?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataad-28.05.98-001.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_GSM_COUNTRY", "Bitte trage das Land hier ein...");
        // teb   = new TextEntryBox("Q_GSM_ABBREV", "Bitte trage den Begriff hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SPACE SHUTTLE ===================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Der schnellste Web-Server des Sonnensystems...");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        // panel.addText("<html><font color=black>Die <b>Datenbertragungsrate</b> zur Erde ist wie hoch??");
        panel.addText("<html><font color=black>Das <b>Space Shuttle</b> hatte wie viele Besatzungsmitglieder?");
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataje-28.05.98-000.html");
        stop = new StopButton(experiment);
        // teb   = new TextEntryBox("Q_GSM_COUNTRY", "Bitte trage die Rate hier ein...");
        teb = new TextEntryBox("Q_GSM_ABBREV", "Bitte trage die Anzahl hier ein...");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = TESTS MIT TIMEOUT ================================================================
        // ------------------------------------------------------------------------------------
        // = TEST Spiegel online MIT TIMEOUT ================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addText("<html><font color=black><h1>Zweiter Teil</h1>");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addText("Dieser zweite Testabschnitt hat einen anderen Testablauf. Hier sollst Du fr eine vorgegebene Zeit (ca. 30 Sekunden)");
        panel.addText("den Inhalt einer Webseite lesen. Die Seite wird wird nach dieser Zeit automatisch verschwinden. Dann werden Dir vier");
        panel.addText("kurze Fragen zum Inhalt gestellt.");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addText("<html><font color=black>Um die Fragen beantworten zu knnen, solltest Du versuchen den Text zu <B>verstehen</B>. Wenn Du fragen nicht beantworten kannst,");
        panel.addText("<html><font color=black>macht das natrlich nichts. Sonst wre der Test ja zu leicht!");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addText("<html><h1><font color=black><i>Szenario");
        panel.addText("Du hast -- wie immer -- nur wenig Zeit und versuchst Dich mchlichst genau und schnell ber die neuesten Entwicklungen");
        panel.addText("und Tendenzen im Bereich der EDV zu informieren. Dafr liest Du einige Seiten eines Nachrichtendienstes.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke den ,,Start''-Knopf und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        StartButtonWithTimeout startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/jk-13.02.02-001/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");
        panel.addText("Bitte gib als erstes Deine Antwort an und sage dann, wie sicher Du Dir bist.");

        panel.addText(" ");
        panel.addBoldText("Ab wann kann man zuknftig die Spiegelartikel der kommenden Woche bereits online abrufen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGWANN", "Ab:", new String[] {"Samstag 10 Uhr", "Samstag 15 Uhr", "Sonntag 13 Uhr", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGWANN+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wie heit der Vorstand von SpiegelNet?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGNAME", "Name:", new String[] {"Carsten Tummler", "Thoms Gbler", "Marco Knossler", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGNAME+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welches Zahlsystem soll eingesetzt werden?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGELPAY", "System:", new String[] {"ePayment", "Allcash", "click&buy", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGELPAY+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welcher im Artikel genante Anbieter setzt auch auf kostenpflichtige Inhalte?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGELPROVIDER", "Anbieter:", new String[] {"Tomorrow Focus", "Stern Online", "Die Zeit", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGELPROVIDER+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "normal"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
 
        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT II =============================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke den ,,Start''-Knopf und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/cgl-09.11.01-001/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Mit wem kann man die Korallen auf den Fijis ansehen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_KORALLEN", "Name:", new String[] {"Jean Cousteau", "Franziska von Almsick", "Greg Louganis", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_KORALLEN+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Mit wem das Berliner Nachtleben unsicher machen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_NACHTLEBE", "Name:", new String[] {"Bruno Ganz", "Wim Wenders", "Ben Becker", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_NACHTLEBE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welcher Musikmacher kann auf Ihrer Privatfete spielen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_PRIVATFETE", "Name:", new String[] {"Dr Motte", "Sven Vth", "L.U.P.O", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_PRIVATFETE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wo knnen sie nicht lange, aber gut mir Eingeborenen leben?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EINGEBORENE", "Land:", new String[] {"Feuerland", "Peru", "Martinique", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EINGEBORENE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandBackground"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
 
        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT 3 ================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/lab-07.11.01-001/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Fr welches Quartal prognostizieren die Analysten wieder Gewinne fr Sun?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SUNWIN", "Ab:", new String[] {"erstes Quartal 2002", "zweites Quartal 2002", "drittes Quartal 2002", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SUNWIN+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Ab wann rechnet Sun laut Quartalsbericht wieder mit Gewinnen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SUNWIN2", "Nicht vor:", new String[] {"April 2002", "Juni 2002", "Oktober 2002", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SUNWIN2+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wieviel Megahertz haben die neuen Prozessoren?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SUNTAKT", "Takt:", new String[] {"900 MHz", "1200 MHz", "1900 MHz", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SUNTAKT+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wie heien die schnellsten Midframe-Server der Welt?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_SUNNAME", "Name:", new String[] {"Sun Fire 4810", "Sun Fire 6800", "Sun Fire 6810", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_SUNNAME+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "normal"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT MICROSOFT TV =====================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/anw-08.11.01-000/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Was mchte Charter Communications seinen Kunden zukommen lassen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_CCPROD", "Fr die Kunden:", new String[] {"Informationen bers Internet", "Video on Demand", "interaktive Kinofilme", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_CCPROD+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wann soll die Software von Microsoft eingesetzt werden?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_CCTIME", "Wann:", new String[] {"wird schon eingesetzt", "in naher Zukunft", "im nchsten Jahr", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_CCTIME+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welche Position nimmt Charter in der Rangliste der Kabelfernsehanbieter ein?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_CCRANK", "Rang:", new String[] {"3.", "4.", "5.", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_CCRAND+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wo hatte sich Microsoft eingekauft?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_CCMSBUY", "Firma:", new String[] {"AT&T", "Sprint", "CNN", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_CCMSBUY+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "background"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT KAFFEE ===========================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/sha-12.08.01-003/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Wie heisst die Kaffeemaschine?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_COFNAME", "Name:", new String[] {"Web Coffee Maker", "Coffeepot Cam", "The REAL Java", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_COFNAME+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Seit wann stand diese im Netz?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_COFDATE", "Seit:", new String[] {"1991", "1993", "1995", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_COFDATE+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("In welchem Raum stand sie?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_COFROOM", "Raum:", new String[] {"Trojan Room", "Coleridge Hall", "Blake Room", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_COFROOM+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welchen Titel verdient sich die \"Krups Pro Aroma\" damit eigentlich?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_COFTIT", "Titel:", new String[] {"meistgesehenste Kaffeemaschine", "grter Versteigerungsflop", "teuerste Kaffeemaschine", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_COFTIT+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "normal"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT BROKAT ===========================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/chk-24.08.01-000/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Wer bernimmt den Geschftsbereich \"mobiles Internet\"?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BROMOB", "Das Unternehmen:", new String[] {"Vodafone", "Eriksson", "eOne Global", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BROMOB+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wieviel kostet die Sparte \"Finanzanwendungen\"?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BROINFO", "Kosten:", new String[] {"10,4 Millionen EUR", "17,2 Millionen EUR", "21,3 Millionen EUR", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BROINFO+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wer aus dem Vorstand von Brokat wird in beiden Unternehmen im Vorstand sitzen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BROMANG", "Manager:", new String[] {"Michael Janen", "Wilfried Kster", "Thomas Dorant", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BROMANG+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welche Ambitionen sind vom Tisch?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BROAMB", "Ambitionen:", new String[] {"Ostasien-Ambitionen", "Amerika-Ambitionen", "Osteuropa-Ambitionen", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BROAMB+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "background"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT xxx ================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addBlueText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/bb-24.08.01-000/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Auf welcher Website findet man die empfohlenen Informationen zum Euro?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EURO1", "Name:", new String[] {"www.euro-wissen.de", "www.euro-online.de", "www.aktion-euro.de", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EURO1+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("In welcher Darstellungsweise wird Kindern altersgerecht der Euro nhergebracht?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EURO2", "Art:", new String[] {"Ein interaktives Fernsehgert", "Ein Online-Spiel", "Eine animierte Bildergeschichte", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EURO2+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welches Material wird Lehrern fr den Unterricht angeboten?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EURO3", "Material:", new String[] {"Wissenstests und Malvorlagen", "Kostenlose kindergerechte Broschren", "Bunte Euro-Poster", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EURO3+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welche staatliche Einrichtung hlt weiteres Informationsmaterial bereit?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EURO4", "Einrichtung", new String[] {"Bundeszentrale fr politische Bildung", "Bundesamt fr Finanzen", "Bundesministerium fr Bildung und Forschung", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EURO4+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandBackground"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT xxx ================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addBlueText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/pmz-24.08.01-000/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Wie heit der Konzern, der jetzt erstmals Lizenzen fr sein ,,Multimedia Messaging Protocol'' verkauft hat?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EPLUS1", "Name:", new String[] {"NTT DoCoMo", "KSS YoMaKo", "LKK KaDoCo", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EPLUS1+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Welche Nationalitt hat obiger Konzern?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EPLUS2", "Land:", new String[] {"Japanisch", "Amerikanisch", "Deutsch", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EPLUS2+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wie heit der erwhnte niederlndische Partner?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EPLUS3", "Name:", new String[] {"NFL Vodafone", "Vodacom NL", "KPN Mobile", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EPLUS3+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("An welchem Wochentag teilten die Unternehmen Ihren Lizenzvertrag der ffentlichkeit mit?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_EPLUS4", "Tag:", new String[] {"Montag", "Mittwoch", "Freitag", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_EPLUS4+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "onDemandNormal"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT xxx ================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addBlueText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/hps-14.07.00-000/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Welcher Konzern versucht das Softwarehaus zu bernehmen?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BAAN1", "Name:", new String[] {"Syscon", "Ivensys", "Conbit", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BAAN1+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wer opponiert gegen die bernahme?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BAAN2", "Gegner:", new String[] {"Der alte CEO", "Ein groer Anteilseigner", "Eine Gruppe von Anteilseignern", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BAAN2+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Durch wen wurde der Handel mit den Baan-Aktien ausgesetzt?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BAAN3", "Name:", new String[] {"Londoner Borsenaufsicht", "New Yorker Brsenaufsicht", "Amsterdamer Brsenaufsicht", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BAAN3+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Was erhofften sich Aktionre durch den Boykott der bernahme?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BAAN4", "Aktion:", new String[] {"Die Zerschlagung des Unternehmens", "Eine Angeobots-Aufbesserung", "Mehr Einfluss auf die Firmenpolitik", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BAAN4+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "normal"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = TEST MIT TIMEOUT xxx ================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBoldText("Nchster Test");
        panel.addItem(Box.createRigidArea(new Dimension(0, 40)));
        panel.addBlueText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
        panel.addItem(Box.createVerticalGlue());
        panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
        panel.addItem(Box.createVerticalGlue());
    
        startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/kz-13.07.00-001/");

        panel.addItem(startx);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();
    
        panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

        panel.addText(" ");
        panel.addBoldText("Wie heit die Konsortialbank, die sich aus dem Konsortium zurckzog?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BUYIT1", "Bank:", new String[] {"Deutsche Bank", "Sal. Oppenheim", "Commerzbank", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BUYIT1+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wer sprach vom ,,Supergau im Leben eines IPO-Kandidaten''?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BUYIT2", "Name:", new String[] {"Wallstreet Online", "Brse Online", "Financial Times", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BUYIT2+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Was macht der CEO Martin Cole fr die schlecht Lage verantwortlich?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BUYIT3", "Ursache:", new String[] {"Der niedrige Nemax", "Der niedrige DAX", "Das schlechte Marktumfeld", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BUYIT3+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addText(" ");
        panel.addBoldText("Wodurch sind Internet-Unternehen generell in Verruf geraten?");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.OptionsBox("Q_BUYIT4", "Durch:", new String[] {"Betrugsvorflle", "Todeslisten", "Hohe Verluste", "wei nicht"}));
        panel.addItem(new evaluator.util.CertitudeScale("Q_BUYIT4+"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.departureexperiment.MusicalNextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        experiment.addTaskGroup(taskGroup);

        // = AUSLEITUNG ======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();

        panel.addBoldText("Das war alles! Vielen Dank fr die Teilnahme an unserem Experiment!");
        panel.addText(" ");
        panel.addText(" ");
        panel.addText("Wenn Du wissen mchtest, was aus Deiner Teilnahme fr Ergebnisse erzeugt wurden,");
        panel.addText("dann trage Deine Email hier ein, wir verschicken dann unsere Resultate.");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        teb = new TextEntryBox("Q_EMAIL", "Platz fr Deine Email-Adresse");
        teb.setEnabled(true);
        panel.addItem(teb);
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.QuitButton(experiment, "Fertig!"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);
    }
}
