package evaluator.departureexperiment;


import java.awt.Dimension;

import javax.swing.Box;

import evaluator.util.ContentGeneratorInterface;
import evaluator.util.EvaluatorFrame;
import evaluator.util.ExperimentController;
import evaluator.util.NextButton;
import evaluator.util.StartButton;
import evaluator.util.StopButton;
import evaluator.util.TaskGroup;
import evaluator.util.TaskPanel;
import evaluator.util.TextEntryBox;


/**
 * <p>Title: ContentGeneratorForDepartureExperiment</p>
 * <p>Description: Experiment for the evaluation of Different Link visualtizations.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 5.0
 */

public class ContentGeneratorForDepartureExperiment6 implements ContentGeneratorInterface {
    private EvaluatorFrame _evaluatorFrame;
    private scone.Plugin   _plugin;

    public ContentGeneratorForDepartureExperiment6() {
        _evaluatorFrame = null;
        _plugin = null;
    }
  
    public void init(EvaluatorFrame evaluatorFrame, scone.Plugin plugin) {
        _evaluatorFrame = evaluatorFrame;
        _plugin = plugin;
    }

    public void generate(ExperimentController experiment) {
        long subjectNumber = experiment.getSubjectNumber();

        System.out.println("Subject: " + subjectNumber);
        TaskPanel panel;
        TaskGroup taskGroup;

        StartButton  start;
        StopButton   stop; 
        TextEntryBox teb;
        NextButton   next;

        /* Bentigt werden: 
         fr Aufgabe  0: 2 x Norm+Link, 2 x OnD+text
         fr Aufgabe  1: 2 x Norm+Link, 2 x OnD+text
         fr Aufgabe  2: 2 x Norm+text, 2 x OnD+Link (mist)
         fr Aufgabe  3: 2 x Norm+Link, 2 x OnD+text
         fr Aufgabe  4: 2 x Norm+Link, 2 x OnD+text
         fr Aufgabe  5: 2 x Norm+Link, 2 x OnD+text
         fr Aufgabe  6: 2 x Norm+text, 2 x OnD+Link (mist)
         fr Aufgabe  7: 2 x Norm+Link, 2 x OnD+text
         fr Aufgabe  8: 2 x Norm+text, 2 x OnD+Link !!
         fr Aufgabe  9: 2 x Norm+text, 2 x OnD+Link !
         fr Aufgabe 10: 2 x Norm+text, 2 x OnD+Link (mist)
         fr Aufgabe 11: 2 x Norm+Link, 2 x OnD+text
         fr Aufgabe 12: 2 x Norm+Link, 2 x OnD+text
         fr Aufgabe 13: 2 x Norm+Link, 2 x OnD+text
         fr Aufgabe 14: 2 x Norm+text, 2 x OnD+Link (mist)
         fr Aufgabe 15: 2 x Norm+Link, 2 x OnD+text
         */

   
        String vis11, vis12;
        String vis21 = "", vis22 = "", vis23 = "";
        // boolean q1, q2, q3, q4;

        boolean q[] = {true, true, false, true, 
            true, true, false, true,
            true, true, true, false,
            false, false, true, false};
                    
        // two permutations for visualization, more for link / not-link questions
        if ((subjectNumber % 2) == 0) {
            vis11 = "normal";
            vis12 = "onDemandNormal";  
        } else {
            vis12 = "normal";
            vis11 = "onDemandNormal";  
            for (int qi = 0; qi < 16; qi++) {
                q[qi] = !q[qi];
            }
        }

        // 16 questions total / 4 groups  four questions:
        // 0011 0101 0110 1001 1010 1100
        // true/1: question is about link, false/0: question is about normal text
        /*
         q1 = q2 = q3 = q4 = false;
         if ((subjectNumber % 6) == 0)
         { q1 = false; q2 = false; q3 = true;  q4 = true;  }
         if ((subjectNumber % 6) == 1)
         { q1 = false; q2 = true;  q3 = false; q4 = true;  }
         if ((subjectNumber % 6) == 2)
         { q1 = false; q2 = true;  q3 = true;  q4 = false; }
         if ((subjectNumber % 6) == 3)
         { q1 = true;  q2 = false; q3 = false; q4 = true;  }
         if ((subjectNumber % 6) == 4)
         { q1 = true;  q2 = false; q3 = true;  q4 = false; }
         if ((subjectNumber % 6) == 5)
         { q1 = true;  q2 = true;  q3 = false; q4 = false; }
         */

        // Six permutations... I'm to lazy to code it another way :-\
        if ((subjectNumber % 6) == 0) {
            vis21 = "hidden";
            vis22 = "normal";
            vis23 = "background";
        }
        if ((subjectNumber % 6) == 1) {
            vis21 = "hidden";
            vis23 = "normal";
            vis22 = "background";
        }
        if ((subjectNumber % 6) == 2) {
            vis22 = "hidden";
            vis21 = "normal";
            vis23 = "background";
        }
        if ((subjectNumber % 6) == 3) {
            vis22 = "hidden";
            vis23 = "normal";
            vis21 = "background";
        }
        if ((subjectNumber % 6) == 4) {
            vis23 = "hidden";
            vis21 = "normal";
            vis22 = "background";
        }
        if ((subjectNumber % 6) == 5) {
            vis23 = "hidden";
            vis22 = "normal";
            vis21 = "background";
        }

        // = EINFHRUNG ======================================================================

        taskGroup = new TaskGroup();

        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        // initialize Visualization (at generation time!)
        lookoflink.Plugin.setVisualization("onDemandNormal");
    
        panel.addBoldText("<html><font color=black><font size=+2>Willkommen bei unserer Studie zur Visualisierung von Links!</font>");
        panel.addText(" ");
        panel.addText("Wir mchten verschiedene Arten fr die Visualisierungen von Links daraufhin testen, wie gut sie benutzbar sind.");
        panel.addText("Dazu werden wir verschiedene kleine Aufgaben stellen.");
        panel.addText(" ");
        panel.addText("Um einen kleinen Eindruck vom Ablauf der Studie zu erhalten, gibt es gleich eine Einfhrungsaufgabe.");
        panel.addText("Diese soll dazu dienen, dass Du dich mit dem Ablauf vertraut machen kannst.");
        panel.addText(" ");
        panel.addText("Zuvor soll jedoch eine Besonderheit vorgestellt werde: Links, die nur erscheinen, wenn dir Strg-Taste gedrckt");
        panel.addText("wird, bzw. wenn die Maus sich ber dem Link befindet.");
        panel.addText(" ");
        panel.addText("Um das einfach mal auszuprobieren, drcke den Start-Knopf und surfe ein wenig herum. Wenn Du genug hast, dann");
        panel.addText("wechsele zurck zu diesem Fenster und benutze den Weiter-Knopf, um fortzufahren.");
        panel.addText(" ");
        panel.addItem(Box.createVerticalGlue());
        start = new StartButton(experiment, "http://www.informatik.uni-hamburg.de");
        panel.addItem(start);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
   
        // -----------------------------------------------------------------------------------

        panel = new TaskPanel();

        panel.addBoldText("Das Vorgehen ist fr jede Aufgabe gleich:");
        panel.addText("1. Jede Aufgabe wird mit dem Start-Knopf unten gestartet.");
        panel.addText("    Daraufhin wird der Webbrowser erscheinen und eine Webseite laden.");
        panel.addText("    Von dieser Seite aus soll nun eine Antwort auf die hier gestellte Frage gefunden werden.");
        panel.addText(" ");
        panel.addText("2. Wenn Du das Gefhl hast, die Antwort gefunden zu haben, wechsele zurck zu diesem Programm.");
        panel.addText("    Dafr kannst Du einfach die Maus auf den linken Bildschirm bewegen.");
        // panel.addText("    Dafr klicke am unterne Bildschirmrand auf das blau-orange \"E\" (E wie Evaluator).");
        panel.addText("    Achtung: Bitte schliee den Web-Browser nicht!");
        panel.addText(" ");
        panel.addText("3. Dann drcke den Stop-Knopf und gib die Antwort auf die Frage in den weien Kasten ein.");
        panel.addText(" ");
        panel.addText("4. Zur nchsten Aufgabe kommst Du mit dem Weiter-Knopf.");
        panel.addText(" ");
        panel.addText(" ");
        panel.addBoldText("Die Aufgaben finden in folgendem Szenario statt:");
        panel.addText("Stell Dir vor, du hast gerade Zeit und mchtest einmal nachforschen, was fr bewegende Dinge ");
        panel.addText("in den letzten Jahren geschehen sind. Dazu liest Du im Archiv eines Nachrichtensenders ");
        panel.addText("einzelne Meldungen, die der Newsticker ausgespuckt hatte.");
        panel.addText(" ");
        panel.addText("Um heute abend beim Betriebsfest mit deinem angesammelten Wissen glnzen zu knnen, reichen Dir");
        panel.addText("jedoch diese Informationsschnipsel nicht, und dir kommt die von uns gestellte Frage in den Sinn.");
        panel.addText("Versuche deshalb, mglichst schnell und mglichst genau eine Antwort zu finden..");
        panel.addText(" ");
        panel.addText("Diese Antwort kann entweder gleich auf der ersten Seite - oder aber auch auf einer Folgeseite");
        panel.addText("zu finden sein, so dass ein Link verfolgt werden muss.");
        panel.addText(" ");
        panel.addText("Mit dem Weiter-Knopf geht es jetzt mit der Einfhrungsaufgabe los...");
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.NextButton(experiment));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
   
        // Testaufgabe -----------------------------------------------------------------------------------
    
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Die HTML-Zukunft heit XML");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        panel.addText("<html><font color=black><b>HTML</b> wird in welcher Version erwhnt?");
        panel.addItem(Box.createVerticalGlue());
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdatahb-13.07.98-000.html");
        stop = new StopButton(experiment);
        teb = new TextEntryBox("Q_HTML_VERSION", "Bitte trage die Versionsnummer hier ein..");
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);
        // teb.setComponentToEnable(next);
        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis11));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = PENTAGON ========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Pentagon: Vorsicht vor dem Web");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[0]) {
            panel.addText("<html><font color=black>Welche <b>Ziele militrischer Operationen</b> heute noch im Netz?");
        } else {
            panel.addText("<html><font color=black>Welche <b>Informationen ber Forschungs- und Entwicklungsvorhaben</b> wurden z.B. ins Netz gestellt?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_pentagon.html");
        stop = new StopButton(experiment);
        if (q[0]) {
            teb = new TextEntryBox("Q_PENTAGON_TARGETS(FLAG)", "Bitte trage die Antwort hier ein...");
        } else {
            teb = new TextEntryBox("Q_PENTAGON_SCIENCE(THEATER)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis11));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = AMNESTY =========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Amnesty: USA fhrend in High-Tech-Repression");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[1]) {
            panel.addText("<html><font color=black>Als <b>Waffenlieferant</b> betreiben die USA Verkufe in welchem Wert?");
        } else {
            panel.addText("<html><font color=black>Neben <b>Ketten, Fusseisen und flssigem Pfeffer</b> werden z.B. welche Folterwerkzeuge verwendet?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_amnesty.html");
        stop = new StopButton(experiment);
        if (q[1]) {
            teb = new TextEntryBox("Q_AMNESTY_SALES(11,8Mill$)", "Bitte trage die Antwort hier ein...");
        } else {
            teb = new TextEntryBox("Q_AMNESTY_TOOLS(GEWEHRE_GURTE)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis11));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = APPLE ===========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Microsoft-Proze: Apple erpret und sabotiert?");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[2]) {
            panel.addText("<html><font color=black><b>Avadis Tevanian</b> arbeitet seit wann bei Apple?");
        } else {  
            panel.addText("<html><font color=black>Am <b>Freitag</b> wurde das Dokument von wem verffentlicht?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_apple.html");
        stop = new StopButton(experiment);
        if (q[2]) {
            teb = new TextEntryBox("Q_APPLE_TEVANIAN(Feb97)", "Bitte trage die Antwort hier ein...");
        } else {
            teb = new TextEntryBox("Q_APPLE_PUBLISHER(DOJ)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis11));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = ENGELBART =======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("30 Jahre Computermaus");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[3]) {
            panel.addText("<html><font color=black><b>Howard Rheingold</b> schreibt vor allem ber welches Thema?");
        } else {  
            panel.addText("<html><font color=black>Die <b>Veranstaltung wird live bertragen</b> - wo?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_engelbart.html");
        stop = new StopButton(experiment);
        if (q[3]) {
            teb = new TextEntryBox("Q_ENGELBART_RHEINGOLD(VIRTUAL_COMMUNITIES)", "Bitte trage die Antwort hier ein...");
        } else {
            teb = new TextEntryBox("Q_ENGELBART_BROADCAST(INTERNET)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis11));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = FURBYS ==========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("NSA warnt vor Furbys");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[4]) {
            panel.addText("<html><font color=black>Die <b>National Security Agency</b> hat welchen Auftrag?");
        } else {  
            panel.addText("<html><font color=black>Welche Dinge drfen <b>von NSA-Angestellten nicht zur Arbeit mitgenommen werden</b>?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_furbys.html");
        stop = new StopButton(experiment);
        if (q[4]) {
            teb = new TextEntryBox("Q_FURBYS_MISSION(PROTECTING INFORMATION)", "Bitte trage die Antwort hier ein...");
        } else {  
            teb = new TextEntryBox("Q_FURBYS_FORBIDDEN(FOTO_VIDEO_AUDIO)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis11));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = POLITIKER =======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Deutsche Politiker im Internet - meist blamabel");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[5]) {
            panel.addText("<html><font color=black>Aus welchem Wahlkreis kommt <b>Johannes Kahrs</b> heute noch im Netz?");
        } else {
            panel.addText("<html><font color=black>Welcher <b>grne Politiker</b> wurde knapp geschlagen?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_politiker.html");
        stop = new StopButton(experiment);
        if (q[5]) {
            teb = new TextEntryBox("Q_POLITIKER_WAHLKREIS(HH11)", "Bitte trage die Antwort hier ein...");
        } else {  
            teb = new TextEntryBox("Q_POLITIKER_GRUENE(MATTHIAS_BERNINGER)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis11));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = PENTAGON ========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Protokoll des Java-Prozesses verffentlicht");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[6]) {
            panel.addText("<html><font color=black>Welches <b>Urteil</b> wurde (vorlufig) gefllt?");
        } else {
            panel.addText("<html><font color=black>Welcher <b>Richter</b> sitzt dem Prozess vor?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_protokoll.html");
        stop = new StopButton(experiment);
        if (q[6]) {
            teb = new TextEntryBox("Q_PROTOKOLL_URTEIL(HALB)", "Bitte trage die Antwort stichwortartig hier ein...");
        } else {
            teb = new TextEntryBox("Q_PROTOKOLL_RICHTER(WHYTE)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis11));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = TYSON ===========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Tysons psychologisches Gutachten im Internet");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[7]) {
            panel.addText("<html><font color=black><b>Mike Tyson</b> stammt aus welcher Stadt?");
        } else {  
            panel.addText("<html><font color=black>Was wurde <b>im Internet</b> ber Tyson verffentlicht?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_tyson.html");
        stop = new StopButton(experiment);
        if (q[7]) {
            teb = new TextEntryBox("Q_TYSON_HOMETOWN(SOUTHINGTON)", "Bitte trage die Antwort hier ein...");
        } else {  
            teb = new TextEntryBox("Q_TYSON_REPORT(PSYCH)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis12));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = UEBERWACHUNG ====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("berwachungstechnologien werden intelligenter");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[8]) {
            panel.addText("<html><font color=black>Die <b>britische Brgerrechtsgruppe Liberty</b> wurde von wem gegrndet?");
        } else {
            panel.addText("<html><font color=black>Wie wird <b>das Argument der Polizei</b> bezeichnet?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_ueberwachung.html");
        stop = new StopButton(experiment);
        if (q[8]) {
            teb = new TextEntryBox("Q_UEBERWACHUNG_FOUNDER(RONALD_KIDD)", "Bitte trage die Antwort hier ein...");
        } else {
            teb = new TextEntryBox("Q_UEBERWACHUNG_ARGUMENT(UNSINN)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis12));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);
    
        // = iMac ============================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("berwachungstechnologien werden intelligenter");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (q[9]) {
            panel.addText("<html><font color=black>Der <b>\"Internet-Macintosh\"</b> hat inzwischen was fr einen Bildschirm?");
        } else {  
            panel.addText("<html><font color=black>Welche Zeitschrift <b>zitiert einen PC-Data-Analysten</b> mit der Aussage, ein \"all time record\" sei erreicht?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/dep_imac.html");
        stop = new StopButton(experiment);
        if (q[9]) {
            teb = new TextEntryBox("Q_IMAC_SCREEN(FLACH14_BOGENLAMPE)", "Bitte trage die Antwort hier ein...");
        } else {  
            teb = new TextEntryBox("Q_IMAC_NEWSPAPER(RETAIL_WEEK)", "Bitte trage die Antwort hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis12));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = CDC BACKDOOR ====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Microsoft verharmlost Sicherheitsrisiko");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (!q[10]) {
            panel.addText("<html><font color=black>Welches <b>Protokoll</b> wird von dem im Text beschriebenen trojanischen Pferd fr die Verbindung verwendet?");
        } else { 
            panel.addText("<html><font color=black><b>Cult of the Dead Cow</b> wurde in welchem Jahr gegrndet?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-05.08.98-000.html");
        stop = new StopButton(experiment);
        if (!q[10]) {
            teb = new TextEntryBox("Q_CDCBACKDOOR_PROTOCOL", "Bitte trage den Namen des Protokolls hier ein...");
        } else {  
            teb = new TextEntryBox("Q_CDCBACKDOOR_YEAR", "Bitte trage das Jahr der Grndung hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis12));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = FBI FOIA ========================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("FBI macht Dokumente online zugnglich");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (!q[11]) {
            panel.addText("<html><font color=black>Der im Text erwhnte <b>Zeppelin</b> trug welchen Namen?");
        } else {
            panel.addText("<html><font color=black>Die <b>Flucht aus Alcatraz</b> ist auf wie vielen Seiten dokumentiert?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdatafr-17.06.98-000.html");
        stop = new StopButton(experiment);
        if (!q[11]) {
            teb = new TextEntryBox("Q_FBI_ZEPPELIN", "Bitte trage den Namen des Zeppelins hier ein...");
        } else {
            teb = new TextEntryBox("Q_FBI_PAGES", "Bitte trage die Anzahl der Seiten hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis12));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = MS ACADEMIA =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Microsoft honoriert akademische Schleichwerbung");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (!q[12]) {
            panel.addText("<html><font color=black>Die <b>Rume des Trgers</b> befinden sich wo?");
        } else {
            panel.addText("<html><font color=black>Die <b>Academic Cooperative</b> hat jetzt welchen neuen Namen?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataghi-26.05.98-000.html");
        stop = new StopButton(experiment);
        if (!q[12]) {
            teb = new TextEntryBox("Q_MSA_PLACE", "Bitte trage den Standort hier ein...");
        } else {
            teb = new TextEntryBox("Q_MSA_NAME", "Bitte trage den Namen hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis12));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SUN LINUX =======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Sun untersttzt Linux");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (!q[13]) {
            panel.addText("<html><font color=black>Was ist das <b>verkndete Ziel</b> von Linus Torvalds?");
        } else {
            panel.addText("<html><font color=black><b>Redhat</b> gibt es in welcher aktuellen Version?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataju-27.05.98-000.html");
        stop = new StopButton(experiment);

        if (!q[13]) {
            teb = new TextEntryBox("Q_SUN_TARGET", "Bitte trage das Ziel hier ein...");
        } else {
            teb = new TextEntryBox("Q_SUN_VERSION", "Bitte trage die Version hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis12));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = PHONE STUDY =====================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Heie Ohren am Mobiltelefon");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (!q[14]) {
            panel.addText("<html><font color=black>Die <b>Untersuchung</b> fand in welchem Land statt?");
        } else {
            panel.addText("<html><font color=black><b>GSM</b> krzt welchen Begriff ab?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataad-28.05.98-001.html");
        stop = new StopButton(experiment);
        if (!q[14]) {
            teb = new TextEntryBox("Q_GSM_COUNTRY", "Bitte trage das Land hier ein...");
        } else {  
            teb = new TextEntryBox("Q_GSM_ABBREV", "Bitte trage den Begriff hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, vis12));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        // = SPACE SHUTTLE ===================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();
    
        panel.addBlueText("Bitte lies die folgende Frage und beginne die Aufgabe mit einem Klick auf den Start-Knopf.");
        panel.addBlueText("Wenn Du die Antwort gefunden hast, drcke den Stop-Knopf.");
        panel.addBlueText("Dann trage bitte die Antwort in Stichworten in den weien Kasten ein.");
        panel.addBlueText("Zur nchsten Aufgabe geht es mit dem Weiter-Knopf.");

        panel.addItem(Box.createVerticalGlue());
        panel.addBlueText("Du findest einen interessanten Artikel zum Thema:");
        panel.addBoldText("Der schnellste Web-Server des Sonnensystems...");
        panel.addText(" ");
        panel.addBlueText("Dir kommt folgende Frage in den Sinn:");
        if (!q[15]) {
            panel.addText("<html><font color=black>Die <b>Datenbertragungsrate</b> zur Erde ist wie hoch??");
        } else {
            panel.addText("<html><font color=black>Das <b>Space Shuttle</b> hatte wie viele Besatzungsmitglieder?");
        }
        panel.addItem(Box.createVerticalGlue());
    
        start = new StartButton(experiment, "http://local.scone.de/heise.denewstickerdataje-28.05.98-000.html");
        stop = new StopButton(experiment);
        if (!q[15]) {
            teb = new TextEntryBox("SHUTTLE_WEBSPEED(64kbit)", "Bitte trage die Rate hier ein...");
        } else {
            teb = new TextEntryBox("SHUTTLE_BESATZUNG(7)", "Bitte trage die Anzahl hier ein...");
        }
        start.setComponentToEnable(stop);
        stop.setComponentToEnable(teb);

        panel.addItems(start, stop);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(teb);
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment, "background"));

        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);

        /*
         // = TESTS MIT TIMEOUT ================================================================
         // = TESTS MIT TIMEOUT ================================================================
         // = TESTS MIT TIMEOUT ================================================================
         // = TESTS MIT TIMEOUT ================================================================
         // ------------------------------------------------------------------------------------
         // = TEST Test! Spiegel online MIT TIMEOUT ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addText("<html><font color=black><h1>Zweiter Teil</h1>");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addText("Dieser zweite Testabschnitt hat einen anderen Testablauf. Hier sollst Du fr eine vorgegebene Zeit (ca. 30 Sekunden)");
         panel.addText("den Inhalt einer Webseite lesen. Die Seite wird wird nach dieser Zeit automatisch verschwinden. Dann werden Dir vier");
         panel.addText("kurze Fragen zum Inhalt gestellt.");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addText("<html><font color=black>Um die Fragen beantworten zu knnen, solltest Du versuchen den Text zu <B>verstehen</B>. Wenn Du fragen nicht beantworten kannst,");
         panel.addText("<html><font color=black>macht das natrlich nichts. Sonst wre der Test ja zu leicht!");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addText("<html><h1><font color=black><i>Szenario");
         panel.addText("Du hast -- wie immer -- nur wenig Zeit und versuchst Dich mchlichst genau und schnell ber die neuesten Entwicklungen");
         panel.addText("und Tendenzen im Bereich der EDV zu informieren. Dafr liest Du einige Seiten eines Nachrichtendienstes.");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke den ,,Start''-Knopf und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         StartButtonWithTimeout startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/jk-13.02.02-001/");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");
         panel.addText("Bitte gib als erstes Deine Antwort an und sage dann, wie sicher Du Dir bist.");

         panel.addText(" ");
         panel.addBoldText("Ab wann kann man zuknftig die Spiegelartikel der kommenden Woche bereits online abrufen?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGEL1", "Ab:", new String[] {"Samstag 10 Uhr", "Samstag 15 Uhr", "Sonntag 13 Uhr"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGEL1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wie heit der Vorstand von SpiegelNet?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGEL2", "Name:", new String[] {"Carsten Tummler", "Thoms Gbler", "Marco Knossler"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGEL2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welches Zahlsystem soll eingesetzt werden?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGEL3_L", "System:", new String[] {"ePayment", "Allcash", "click&buy"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGEL3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welcher im Artikel genante Anbieter setzt auch auf kostenpflichtige Inhalte?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_SPIEGEL4_L", "Anbieter:", new String[] {"Tomorrow Focus", "Stern Online", "Die Zeit"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_SPIEGEL4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis21));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         
         taskGroup.addTask(panel);
         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT I: Whiskey =============================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createRigidArea(new Dimension(0,40)));
         panel.addText("Auch dieser Test gibt eine Zeit von 30 Sekunden, um die Seite zu lesen.");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke den ,,Start''-Knopf und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://local.scone.de/heise.whiskyhilft.html");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Mit wem kann man die Korallen auf den Fijis ansehen?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_WHISKY1", "Name:", new String[] {"Jean Cousteau", "Franziska von Almsick", "Greg Louganis"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_WHISKY1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Mit wem das Berliner Nachtleben unsicher machen?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_WHISKY2_L", "Name:", new String[] {"Bruno Ganz", "Wim Wenders", "Ben Becker"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_WHISKY2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welcher Musikmacher kann auf Ihrer Privatfete spielen?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_WHISKY3_L", "Name:", new String[] {"Dr Motte", "Sven Vth", "L.U.P.O"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_WHISKY3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wo knnen sie nicht lange, aber gut mir Eingeborenen leben?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_WHISKY4", "Land:", new String[] {"Feuerland", "Peru", "Martinique"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_WHISKY4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis21));

         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         
         taskGroup.addTask(panel);
         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 2: SUN ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/lab-07.11.01-001/");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // Test 3-----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Fr welches Quartal prognostizieren die Analysten wieder Gewinne fr Sun?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_SUNWIN", "Ab:", new String[] {"erstes Quartal 2002", "zweites Quartal 2002", "drittes Quartal 2002"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_SUNWIN+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Ab wann rechnet Sun laut Quartalsbericht wieder mit Gewinnen?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_SUNWIN2", "Nicht vor:", new String[] {"April 2002", "Juni 2002", "Oktober 2002"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_SUNWIN2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wieviel Megahertz haben die neuen Prozessoren?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_SUNTAKT", "Takt:", new String[] {"900 MHz", "1200 MHz", "1900 MHz"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_SUNTAKT+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wie heien die schnellsten Midframe-Server der Welt?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_SUNNAME", "Name:", new String[] {"Sun Fire 4810", "Sun Fire 6800", "Sun Fire 6810"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_SUNNAME+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis21));

         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST 4 MIT TIMEOUT MICROSOFT TV =====================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/anw-08.11.01-000/");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Was mchte Charter Communications seinen Kunden zukommen lassen?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_CCPROD", "Fr die Kunden:", new String[] {"Informationen bers Internet", "Video on Demand", "interaktive Kinofilme"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_CCPROD+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wann soll die Software von Microsoft eingesetzt werden?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_CCTIME", "Wann:", new String[] {"wird schon eingesetzt", "in naher Zukunft", "im nchsten Jahr"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_CCTIME+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welche Position nimmt Charter in der Rangliste der Kabelfernsehanbieter ein?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_CCRANK", "Rang:", new String[] {"3.", "4.", "5."}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_CCRAND+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wo hatte sich Microsoft eingekauft?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_CCMSBUY", "Firma:", new String[] {"AT&T", "Sprint", "CNN"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_CCMSBUY+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis21));

         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 5 KAFFEE ===========================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/sha-12.08.01-003/");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Wie heisst die Kaffeemaschine?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_COFNAME", "Name:", new String[] {"Web Coffee Maker", "Coffeepot Cam", "The REAL Java"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_COFNAME+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Seit wann stand diese im Netz?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_COFDATE", "Seit:", new String[] {"1991", "1993", "1995"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_COFDATE+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("In welchem Raum stand sie?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_COFROOM", "Raum:", new String[] {"Trojan Room", "Coleridge Hall", "Blake Room"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_COFROOM+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welchen Titel verdient sich die \"Krups Pro Aroma\" damit eigentlich?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_COFTIT", "Titel:", new String[] {"meistgesehenste Kaffeemaschine", "grter Versteigerungsflop", "teuerste Kaffeemaschine"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_COFTIT+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis22));

         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 6 BROKAT ===========================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://local.scone.de/heise.brokatzerfaellt.html");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Wer bernimmt den Geschftsbereich \"mobiles Internet\"?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BROMOB", "Das Unternehmen:", new String[] {"Vodafone", "Eriksson", "eOne Global"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BROMOB+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wieviel kostet die Sparte \"Finanzanwendungen\"?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BROINFO", "Kosten:", new String[] {"10,4 Millionen EUR", "17,2 Millionen EUR", "21,3 Millionen EUR"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BROINFO+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wer aus dem Vorstand von Brokat wird in beiden Unternehmen im Vorstand sitzen?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BROMANG", "Manager:", new String[] {"Michael Janen", "Wilfried Kster", "Thomas Dorant"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BROMANG+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welche Ambitionen sind vom Tisch?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BROAMB", "Ambitionen:", new String[] {"Ostasien-Ambitionen", "Amerika-Ambitionen", "Osteuropa-Ambitionen"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BROAMB+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis22));

         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 7 ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://local.scone.de/heise.euro.html");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Auf welcher Website findet man die empfohlenen Informationen zum Euro?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_EURO1", "Name:", new String[] {"www.euro-wissen.de", "www.euro-online.de", "www.aktion-euro.de"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_EURO1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("In welcher Darstellungsweise wird Kindern altersgerecht der Euro nhergebracht?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_EURO2", "Art:", new String[] {"Ein interaktives Fernsehgert", "Ein Online-Spiel", "Eine animierte Bildergeschichte"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_EURO2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welches Material wird Lehrern fr den Unterricht angeboten?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_EURO3", "Material:", new String[] {"Wissenstests und Malvorlagen", "Kostenlose kindergerechte Broschren", "Bunte Euro-Poster"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_EURO3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welche staatliche Einrichtung hlt weiteres Informationsmaterial bereit?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_EURO4", "Einrichtung", new String[] {"Bundeszentrale fr politische Bildung", "Bundesamt fr Finanzen", "Bundesministerium fr Bildung und Forschung"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_EURO4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis22));

         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 8 ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/pmz-24.08.01-000/");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Wie heit der Konzern, der jetzt erstmals Lizenzen fr sein ,,Multimedia Messaging Protocol'' verkauft hat?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_EPLUS1", "Name:", new String[] {"NTT DoCoMo", "KSS YoMaKo", "LKK KaDoCo"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_EPLUS1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welche Nationalitt hat obiger Konzern?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_EPLUS2", "Land:", new String[] {"Japanisch", "Amerikanisch", "Deutsch"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_EPLUS2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wie heit der erwhnte niederlndische Partner?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_EPLUS3", "Name:", new String[] {"NFL Vodafone", "Vodacom NL", "KPN Mobile"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_EPLUS3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("An welchem Wochentag teilten die Unternehmen Ihren Lizenzvertrag der ffentlichkeit mit?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_EPLUS4", "Tag:", new String[] {"Montag", "Mittwoch", "Freitag"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_EPLUS4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis22));

         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 9 ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://local.scone.de/heise.baan.html");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Welcher Konzern versucht das Softwarehaus zu bernehmen?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BAAN1", "Name:", new String[] {"Syscon", "Ivensys", "Conbit"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BAAN1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wer opponiert gegen die bernahme?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BAAN2", "Gegner:", new String[] {"Der alte CEO", "Ein groer Anteilseigner", "Eine Gruppe von Anteilseignern"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BAAN2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Durch wen wurde der Handel mit den Baan-Aktien ausgesetzt?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BAAN3", "Name:", new String[] {"Londoner Borsenaufsicht", "New Yorker Brsenaufsicht", "Amsterdamer Brsenaufsicht"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BAAN3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Was erhofften sich Aktionre durch den Boykott der bernahme?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BAAN4", "Aktion:", new String[] {"Ein Verhindern der bernahme", "Eine Angeobots-Aufbesserung", "Mehr Einfluss auf die Firmenpolitik"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BAAN4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis23));

         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 9 ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://local.scone.de/heise.letsbuyit.html");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Wie heit die Konsortialbank, die sich aus dem Konsortium zurckzog?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BUYIT1", "Bank:", new String[] {"Deutsche Bank", "Sal. Oppenheim", "Commerzbank"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BUYIT1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wer sprach vom ,,Supergau im Leben eines IPO-Kandidaten''?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BUYIT2", "Name:", new String[] {"Wallstreet Online", "Brse Online", "Financial Times"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BUYIT2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Was macht der CEO Martin Cole fr die schlecht Lage verantwortlich?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BUYIT3", "Ursache:", new String[] {"Der niedrige Nemax", "Der niedrige DAX", "Das schlechte Marktumfeld"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BUYIT3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wodurch sind Internet-Unternehen generell in Verruf geraten?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_BUYIT4", "Durch:", new String[] {"Betrugsvorflle", "Todeslisten", "Hohe Verluste"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_BUYIT4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis23));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 10 ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://www.heise.de/newsticker/data/wst-14.12.00-001/");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Von welcher Gruppe handelt der genantte fiktive Dokumentarfilm?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_GATES1", "Gruppe:", new String[] {"People for Justice", "Citizens for Truth", "Folks for Freedom"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_GATES1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wie starb Bill Gates?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_GATES2", "Er wurde:", new String[] {"erschossen", "vergiftet", "erstochen"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_GATES2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welche Einrichtung ist in den Mord verwickelt?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_GATES3", "Name:", new String[] {"Das CIA", "Das Wirtschaftsministerium", "Das Justizministerium"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_GATES3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welche Adresse hat die makabre Website, die demnchst freigeschaltet werden soll?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_GATES4", "Adresse:", new String[] {"BillGatesIsDead.com", "KillBillGates.com", "WhoKilledBillGates.com"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_GATES4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis23));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);


         // = TEST MIT TIMEOUT 11 ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://local.scone.de/heise.fischer.html");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Wie heit der Radiosender aus San Diego, der das Lied der Gruppe ,,Fisher'' zuerst spielte?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FISHER1", "Gruppe:", new String[] {"Hits 100,7", "Music 100,7", "Star 100,7"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FISHER1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Zu welchem Medienkonzern gehrt Farmclub.com?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FISHER2", "Konzern:", new String[] {"Universal", "Warner Brothers", "Sony"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FISHER2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wie heisst das erste Albun der Gruppe Fischer?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FISHER3", "Name:", new String[] {"Blue Youth", "True North", "Sweet South"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FISHER3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welche bekannte Gruppe hatte nur 500 CDs in der ersten Woche verkauft?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FISHER4", "Gruppe:", new String[] {"No Doubt", "Linkin Park", "Matchbox 20"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FISHER4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.DepartureExperimentNextButton(experiment,vis23));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 12 ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://local.scone.de/heise.freeinisout.html");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("Wieviel Minuten kostenloser Zugang pro Tag wurde gewhrt?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FREEIN1", "Zeit:", new String[] {"10 Minuten", "20 Minuten", "30 Minuten"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FREEIN1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Ab wann soll der Zugang 2,9 Pfennig pro Minute kosten?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FREEIN2", "Ab:", new String[] {"Anfang Januar", "Mitte Januar", "Anfang Februar"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FREEIN2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welches Geschftsmodell traf bei den angefragten Unternehmen auf wenig Resonanz?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FREEIN3", "Modell:", new String[] {"Gezielte Werbebanner", "Austausch von Kundendaten", "Sponsorenschaft"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FREEIN3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wie hie der in der USA gestoppte Zugang?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FREEIN4", "Name:", new String[] {"FreeIn", "Free Access", "SurfFree"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FREEIN4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.MusicalNextButton(experiment));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         // = TEST MIT TIMEOUT 13 ================================================================

         taskGroup = new TaskGroup();

         // -----------------------------------------------------------------------------------
         
         panel = new TaskPanel();
         
         panel.addBoldText("Nchster Test");
         panel.addItem(Box.createVerticalGlue());
         panel.addBoldText("Bitte drcke ,,Start'' und lies den Text auf der Webseite.");
         panel.addItem(Box.createVerticalGlue());
         
         startx = new StartButtonWithTimeout(experiment, "http://local.scone.de/heise.viren.html");

         panel.addItem(startx);
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         // -----------------------------------------------------------------------------------

         panel = new TaskPanel();
         
         panel.addBoldText("Jetzt noch vier kleine Fragen zum Text:");

         panel.addText(" ");
         panel.addBoldText("?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FREEIN1", "Zeit:", new String[] {"10 Minuten", "20 Minuten", "30 Minuten"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FREEIN1+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Ab wann soll der Zugang 2,9 Pfennig pro Minute kosten?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FREEIN2", "Ab:", new String[] {"Anfang Januar", "Mitte Januar", "Anfang Februar"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FREEIN2+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Welches Geschftsmodell traf bei den angefragten Unternehmen auf wenig Resonanz?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FREEIN3", "Modell:", new String[] {"Gezielte Werbebanner", "Austausch von Kundendaten", "Sponsorenschaft"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FREEIN3+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addText(" ");
         panel.addBoldText("Wie hie der in der USA gestoppte Zugang?");
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         panel.addItem(new evaluator.util.OptionsBox("Q_FREEIN4", "Name:", new String[] {"FreeIn", "Free Access", "SurfFree"}));
         panel.addItem(new evaluator.util.CertitudeScale("Q_FREEIN4+"));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));

         panel.addItem(Box.createVerticalGlue());
         panel.addItem(new evaluator.departureexperiment.MusicalNextButton(experiment));
         panel.addItem(Box.createRigidArea(new Dimension(0,20)));
         taskGroup.addTask(panel);

         experiment.addTaskGroup(taskGroup);

         */
        // = AUSLEITUNG ======================================================================

        taskGroup = new TaskGroup();
        panel = new TaskPanel();

        panel.addBoldText("Das war alles! Vielen Dank fr die Teilnahme an unserem Experiment!");
        panel.addText(" ");
        panel.addText(" ");
        panel.addText("Wenn Du wissen mchtest, was aus Deiner Teilnahme fr Ergebnisse erzeugt wurden,");
        panel.addText("dann trage Deine Email hier ein, wir verschicken dann unsere Resultate.");
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        teb = new TextEntryBox("Q_EMAIL", "Platz fr Deine Email-Adresse");
        teb.setEnabled(true);
        panel.addItem(teb);
        panel.addItem(Box.createVerticalGlue());
        panel.addItem(new evaluator.util.QuitButton(experiment, "Fertig!"));
        panel.addItem(Box.createRigidArea(new Dimension(0, 20)));
        taskGroup.addTask(panel);

        taskGroup.addTask(panel);
        experiment.addTaskGroup(taskGroup);
    }
}
