package evaluator.departureexperiment;


import javax.swing.JButton;

import evaluator.util.ExperimentController;


/**
 * NextButton class
 *
 * <p>Description: Is used to create a next button that invokes the
 * advanceToNext method of the calling evaluatorFrame.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.3
 */

// <value>normal</value>
// <value>background</value>
// <value>onDemandNormal</value>
// <value>onDemandBackground</value>

public class DepartureExperimentNextButton extends JButton {
  
    public DepartureExperimentNextButton(ExperimentController experiment, String label, String visualization) {
        final ExperimentController _experiment;
        final String _visualization;

        _experiment = experiment;
        _visualization = visualization;
        setText(label);
        setFont(evaluator.util.UIToolbox.PLAINFONT);
        setFocusPainted(false);
        addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
                _experiment.nextTask();
                // Change Visualization...
                lookoflink.Plugin.setVisualization(_visualization);
                _experiment.browserControl("Maximize", "");
                _experiment.browserControl("BlankPage", "");
            }
        }
        );
    }

    public DepartureExperimentNextButton(ExperimentController experiment, String visualization) {
        this(experiment, "Weiter >", visualization);
    }

}
